/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.model;

import com.google.common.collect.ImmutableSet;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.model.CruiseDataModel;
import fr.ifremer.tutti.persistence.model.DataModelSupport;
import java.util.Iterator;
import java.util.Set;

public class ProgramDataModel
extends DataModelSupport
implements Iterable<CruiseDataModel> {
    private static final long serialVersionUID = 1L;
    private final Set<CruiseDataModel> cruises;

    public ProgramDataModel(Program program, Set<CruiseDataModel> cruises) {
        this(program.getId(), program.getName(), cruises);
    }

    public ProgramDataModel(String id, String label, Set<CruiseDataModel> cruises) {
        super(id, label);
        this.cruises = ImmutableSet.copyOf(cruises);
    }

    public int size() {
        return this.cruises.size();
    }

    @Override
    public Iterator<CruiseDataModel> iterator() {
        return this.cruises.iterator();
    }

    public CruiseDataModel getCruise(String id) {
        CruiseDataModel result = null;
        for (CruiseDataModel cruise : this) {
            if (!id.equals(cruise.getId())) continue;
            result = cruise;
            break;
        }
        return result;
    }
}

