/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.importactions;

import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.genericformat.GenericFormatContextSupport;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportRequest;
import fr.ifremer.tutti.service.genericformat.importactions.ImportActionSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RestoreAfterImportAction
extends ImportActionSupport {
    private static final Log log = LogFactory.getLog(RestoreAfterImportAction.class);
    private final PersistenceService persistenceService;

    public RestoreAfterImportAction(GenericFormatContextSupport importContext, PersistenceService persistenceService) {
        super(importContext);
        this.persistenceService = persistenceService;
    }

    @Override
    protected boolean canExecute() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute() {
        GenericFormatImportRequest importRequest = this.importContext.getImportRequest();
        try {
            this.rollbackSampleCategoryModel(importRequest);
        }
        finally {
            this.rollbackProtocol(importRequest);
        }
    }

    protected void rollbackSampleCategoryModel(GenericFormatImportRequest importRequest) {
        SampleCategoryModel sampleCategoryModel = importRequest.getSampleCategoryModel();
        if (log.isInfoEnabled()) {
            log.info((Object)("Rollback previous sample cateogry model: " + sampleCategoryModel));
        }
        this.persistenceService.setSampleCategoryModel(sampleCategoryModel);
    }

    protected void rollbackProtocol(GenericFormatImportRequest importRequest) {
        if (importRequest.isOverrideProtocol()) {
            String protocolOriginalName = this.importContext.getProtocolOriginalName();
            TuttiProtocol toDelete = this.persistenceService.getProtocolByName(protocolOriginalName);
            if (log.isInfoEnabled()) {
                log.info((Object)("Delete previous protocol: " + toDelete.getId() + " - " + toDelete.getName()));
            }
            this.persistenceService.deleteProtocol(toDelete.getId());
            TuttiProtocol importedProtocol = this.importContext.getImportedProtocol();
            importedProtocol.setName(protocolOriginalName);
            if (log.isInfoEnabled()) {
                log.info((Object)("Save imported protocol: " + importedProtocol.getId() + " - " + importedProtocol.getName()));
            }
            this.persistenceService.saveProtocol(importedProtocol);
        }
    }
}

