/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.exportactions;

import fr.ifremer.adagio.core.dao.referential.ObjectTypeCode;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportOperationContext;
import fr.ifremer.tutti.service.genericformat.csv.AttachmentRow;
import fr.ifremer.tutti.service.genericformat.csv.CatchRow;
import fr.ifremer.tutti.service.genericformat.exportactions.ExportFishingOperationActionSupport;
import fr.ifremer.tutti.service.genericformat.producer.CsvProducerForAttachment;
import fr.ifremer.tutti.service.genericformat.producer.CsvProducerForCatch;
import fr.ifremer.tutti.service.genericformat.producer.CsvProducerForSpecies;
import fr.ifremer.tutti.util.Numbers;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CreateCatchBatchRowsAction
extends ExportFishingOperationActionSupport {
    private static final Log log = LogFactory.getLog(CreateCatchBatchRowsAction.class);
    private final PersistenceService persistenceService;

    public CreateCatchBatchRowsAction(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    @Override
    public boolean doExecute(GenericFormatExportContext exportContext, GenericFormatExportOperationContext operationContext) {
        return (exportContext.isExportSpecies() || exportContext.isExportBenthos()) && operationContext.isWithCatchBatch();
    }

    @Override
    public void execute(GenericFormatExportContext exportContext, GenericFormatExportOperationContext operationContext) {
        boolean exportAll;
        boolean exportSpecies = exportContext.isExportSpecies();
        boolean exportBenthos = exportContext.isExportBenthos();
        boolean bl = exportAll = exportSpecies && exportBenthos;
        if (exportSpecies) {
            this.prepareSpeciesBatches(exportContext, operationContext);
        }
        if (exportBenthos) {
            this.prepareBenthosBatches(exportContext, operationContext);
        }
        CatchBatch catchBatch = operationContext.getCatchBatch();
        Float catchRaisingfactor = this.computeCatchRaisingfactor(catchBatch);
        Float speciesCatchRaisingFactor = null;
        if (exportSpecies) {
            speciesCatchRaisingFactor = this.computeSpeciesRaisingFactor(catchBatch, catchRaisingfactor);
        }
        Float benthosCatchRaisingFactor = null;
        if (exportBenthos) {
            benthosCatchRaisingFactor = this.computeBenthosRaisingFactor(catchBatch, catchRaisingfactor);
        }
        CsvProducerForCatch producerForCatch = exportContext.getProducerForCatch();
        if (exportAll) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Operation %s [catchRF: %s / speciesRF: %s / benthosRF: %s ]", operationContext.getOperation().getId(), catchRaisingfactor, speciesCatchRaisingFactor, benthosCatchRaisingFactor));
            }
            List<CatchRow> catchRows = producerForCatch.getDataToExport(operationContext, speciesCatchRaisingFactor, benthosCatchRaisingFactor);
            operationContext.setCatchRows(catchRows);
        } else if (exportSpecies) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Operation %s [catchRF: %s / speciesRF: %s ]", operationContext.getOperation().getId(), catchRaisingfactor, speciesCatchRaisingFactor));
            }
            List<CatchRow> catchRows = producerForCatch.getSpeciesOnlyDataToExport(operationContext, speciesCatchRaisingFactor);
            operationContext.setCatchRows(catchRows);
        } else if (exportBenthos) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Operation %s [catchRF: %s / benthosRF: %s ]", operationContext.getOperation().getId(), catchRaisingfactor, benthosCatchRaisingFactor));
            }
            List<CatchRow> catchRows = producerForCatch.getBenthosOnlyDataToExport(operationContext, benthosCatchRaisingFactor);
            operationContext.setCatchRows(catchRows);
        }
    }

    private void prepareSpeciesBatches(GenericFormatExportContext exportContext, GenericFormatExportOperationContext operationContext) {
        BatchContainer<SpeciesBatch> rootSpeciesBatch = operationContext.getRootSpeciesBatch();
        CsvProducerForSpecies producerForSpecies = exportContext.getProducerForSpecies();
        producerForSpecies.prepareSpeciesBatchRows(rootSpeciesBatch);
        if (exportContext.isExportAttachments()) {
            CsvProducerForAttachment producerForAttachment = exportContext.getProducerForAttachment();
            ArrayList<AttachmentRow> attachmentRows = new ArrayList<AttachmentRow>();
            for (SpeciesBatch speciesBatch : rootSpeciesBatch.getChildren()) {
                List<Attachment> attachments = this.persistenceService.getAllAttachments(ObjectTypeCode.BATCH, speciesBatch.getIdAsInt());
                producerForAttachment.addAttachments(attachments, attachmentRows);
            }
            operationContext.addAttachmentRows(attachmentRows);
        }
    }

    private void prepareBenthosBatches(GenericFormatExportContext exportContext, GenericFormatExportOperationContext operationContext) {
        BatchContainer<BenthosBatch> rootSpeciesBatch = operationContext.getRootBenthosBatch();
        CsvProducerForSpecies producerForSpecies = exportContext.getProducerForSpecies();
        producerForSpecies.prepareBenthosBatchRows(rootSpeciesBatch);
        CsvProducerForAttachment producerForAttachment = exportContext.getProducerForAttachment();
        if (exportContext.isExportAttachments()) {
            ArrayList<AttachmentRow> attachmentRows = new ArrayList<AttachmentRow>();
            for (BenthosBatch benthosBatch : rootSpeciesBatch.getChildren()) {
                List<Attachment> attachments = this.persistenceService.getAllAttachments(ObjectTypeCode.BATCH, benthosBatch.getIdAsInt());
                producerForAttachment.addAttachments(attachments, attachmentRows);
            }
            operationContext.addAttachmentRows(attachmentRows);
        }
    }

    private Float computeSpeciesRaisingFactor(CatchBatch catchBatch, Float catchRaisingFactor) {
        Float totalSortedSpeciesWeight = (Float)Numbers.getValueOrComputedValue((Number)catchBatch.getSpeciesTotalSortedWeight(), (Number)catchBatch.getSpeciesTotalSortedComputedWeight());
        Float totalSampleSortedSpeciesWeight = catchBatch.getSpeciesTotalSampleSortedComputedWeight();
        Float speciesCatchRaisingFactor = totalSampleSortedSpeciesWeight == null || totalSortedSpeciesWeight == null ? Float.valueOf(1.0f) : (totalSampleSortedSpeciesWeight.floatValue() == 0.0f ? Float.valueOf(0.0f) : Float.valueOf(totalSortedSpeciesWeight.floatValue() / totalSampleSortedSpeciesWeight.floatValue() * catchRaisingFactor.floatValue()));
        return speciesCatchRaisingFactor;
    }

    private Float computeBenthosRaisingFactor(CatchBatch catchBatch, Float catchRaisingFactor) {
        Float totalSampleSortedBenthosWeight = catchBatch.getBenthosTotalSampleSortedComputedWeight();
        Float totalSortedBenthosWeight = (Float)Numbers.getValueOrComputedValue((Number)catchBatch.getBenthosTotalSortedWeight(), (Number)catchBatch.getBenthosTotalSortedComputedWeight());
        Float benthosCatchRaisingFactor = totalSampleSortedBenthosWeight == null || totalSortedBenthosWeight == null ? Float.valueOf(1.0f) : (totalSampleSortedBenthosWeight.floatValue() == 0.0f ? Float.valueOf(0.0f) : Float.valueOf(totalSortedBenthosWeight.floatValue() / totalSampleSortedBenthosWeight.floatValue() * catchRaisingFactor.floatValue()));
        return benthosCatchRaisingFactor;
    }

    private Float computeCatchRaisingfactor(CatchBatch catchBatch) {
        Float totalWeight = (Float)Numbers.getValueOrComputedValue((Number)catchBatch.getCatchTotalWeight(), (Number)catchBatch.getCatchTotalComputedWeight());
        Float totalUnsortedWeight = catchBatch.getCatchTotalUnsortedComputedWeight();
        Float totalSortedWeight = catchBatch.getCatchTotalSortedComputedWeight();
        Float catchRaisingFactor = Float.valueOf(totalWeight == null || totalUnsortedWeight == null || totalSortedWeight == null ? 1.0f : (totalWeight.floatValue() - totalUnsortedWeight.floatValue()) / totalSortedWeight.floatValue());
        return catchRaisingFactor;
    }
}

