/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.util;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.birt.report.model.api.util.StringUtil;

public class ColorUtil {
    static Map cssToRgbMap = new HashMap();
    static Map rgbToCssMap = new HashMap();
    static final String[][] colors = new String[][]{{"maroon", "#800000"}, {"red", "#FF0000"}, {"orange", "#ffA500"}, {"yellow", "#FFFF00"}, {"olive", "#808000"}, {"purple", "#800080"}, {"fuchsia", "#FF00FF"}, {"white", "#FFFFFF"}, {"lime", "#00FF00"}, {"green", "#008000"}, {"navy", "#000080"}, {"blue", "#0000FF"}, {"aqua", "#00FFFF"}, {"teal", "#008080"}, {"black", "#000000"}, {"silver", "#C0C0C0"}, {"gray", "#808080"}};
    private static final String COLOR_CSS_PATTERN = "[rR][gG][bB][(][\\s]*[\\d]+[\\s]*[,][\\s]*[\\d]+[\\s]*[,][\\s]*[\\d]+[\\s]*[)]";
    private static final String COLOR_CSS_PERCENT_PATTERN = "[rR][gG][bB][(][\\s]*[\\d]+(.\\d+)?[\\s]*[%][\\s]*[,][\\s]*[\\d]+(.\\d+)?[\\s]*[%][\\s]*[,][\\s]*[\\d]+(.\\d+)?[\\s]*[%][\\s]*[)]";
    private static Pattern cssAbsolutePattern;
    private static Pattern cssRelativePattern;
    public static final int HTML_FORMAT = 1;
    public static final int INT_FORMAT = 0;
    public static final int JAVA_FORMAT = 2;
    public static final int CSS_ABSOLUTE_FORMAT = 3;
    public static final int CSS_RELATIVE_FORMAT = 4;
    public static final int DEFAULT_FORMAT = 3;

    static {
        int i = 0;
        while (i < colors.length) {
            Integer rgb = Integer.decode(colors[i][1]);
            cssToRgbMap.put(colors[i][0], rgb);
            rgbToCssMap.put(rgb, colors[i][0]);
            ++i;
        }
        cssAbsolutePattern = Pattern.compile(COLOR_CSS_PATTERN);
        cssRelativePattern = Pattern.compile(COLOR_CSS_PERCENT_PATTERN);
    }

    public static int parsePredefinedColor(String color) {
        if (color == null) {
            return -1;
        }
        Integer rgbValue = (Integer)cssToRgbMap.get(color.toLowerCase());
        return rgbValue == null ? -1 : rgbValue;
    }

    public static String getPredefinedColor(int rgb) {
        return (String)rgbToCssMap.get(rgb);
    }

    public static boolean isCssAbsolute(String value) {
        return cssAbsolutePattern.matcher(value).matches();
    }

    public static boolean isCssRelative(String value) {
        return cssRelativePattern.matcher(value).matches();
    }

    public static String format(int rgbValue, int rgbFormat) {
        String rgbText = StringUtil.toRgbText(rgbValue).toUpperCase();
        switch (rgbFormat) {
            case 0: {
                return String.valueOf(rgbValue);
            }
            case 1: {
                return rgbText;
            }
            case 2: {
                return rgbText.replaceFirst("#", "0x");
            }
            case 3: {
                return ColorUtil.hexToRGB(rgbText, true);
            }
            case 4: {
                return ColorUtil.hexToRGB(rgbText, false);
            }
        }
        return ColorUtil.hexToRGB(rgbText, true);
    }

    public static String format(String value, int rgbFormat) {
        int rgbValue = ColorUtil.parseColor(value);
        if (rgbValue != -1) {
            return ColorUtil.format(rgbValue, rgbFormat);
        }
        return null;
    }

    private static String hexToRGB(String hexColor, boolean isAbsolute) {
        assert (hexColor.length() == 7);
        String r = hexColor.substring(1, 3);
        String g = hexColor.substring(3, 5);
        String b = hexColor.substring(5, 7);
        r = Integer.valueOf(r, 16).toString();
        g = Integer.valueOf(g, 16).toString();
        b = Integer.valueOf(b, 16).toString();
        StringBuffer sb = new StringBuffer();
        if (isAbsolute) {
            sb.append("RGB(").append(r).append(",");
            sb.append(g).append(",");
            sb.append(b).append(")");
        } else {
            int r_iValue = Integer.valueOf(r);
            int g_iValue = Integer.valueOf(g);
            int b_iValue = Integer.valueOf(b);
            float r_fValue = (float)((int)((float)(r_iValue * 10 * 100) / 255.0f + 0.5f)) / 10.0f;
            float g_fValue = (float)((int)((float)(g_iValue * 10 * 100) / 255.0f + 0.5f)) / 10.0f;
            float b_fValue = (float)((int)((float)(b_iValue * 10 * 100) / 255.0f + 0.5f)) / 10.0f;
            sb.append("RGB(").append(String.valueOf(r_fValue)).append("%,");
            sb.append(String.valueOf(g_fValue)).append("%,");
            sb.append(String.valueOf(b_fValue)).append("%)");
        }
        return sb.toString();
    }

    private static int parseRGBColor(String rgbColor) {
        int end;
        if (!ColorUtil.isCssAbsolute(rgbColor) && !ColorUtil.isCssRelative(rgbColor)) {
            return -1;
        }
        boolean hasPercentage = false;
        int start = rgbColor.indexOf(40);
        String subStr1 = rgbColor.substring(start + 1, end = rgbColor.indexOf(41)).trim();
        if (subStr1.indexOf(37) != -1) {
            subStr1 = subStr1.replace('%', ' ');
            hasPercentage = true;
        }
        String[] numbers = subStr1.split(",");
        StringBuilder colorValue = new StringBuilder("#");
        int i = 0;
        while (i < 3) {
            int intValue = 0;
            String number = numbers[i].trim();
            if (hasPercentage) {
                float value = Float.parseFloat(number);
                if (value > 100.0f) {
                    value = 100.0f;
                }
                intValue = (int)(value * 255.0f / 100.0f + 0.5f);
            } else {
                intValue = Integer.parseInt(number);
                if (intValue > 255) {
                    intValue = 255;
                }
            }
            String strValue = "0" + Integer.toHexString(intValue);
            strValue = strValue.substring(strValue.length() - 2);
            colorValue.append(strValue);
            ++i;
        }
        return Integer.decode(colorValue.toString());
    }

    public static int parseColor(String value) {
        if (StringUtil.isBlank(value)) {
            return -1;
        }
        char first = value.charAt(0);
        if (first == '#' || first >= '0' && first <= '9') {
            int retValue;
            block8: {
                if (first == '#' && value.length() == 4) {
                    char[] rgb_chars = value.toCharArray();
                    char[] rrggbb_chars = new char[]{'#', rgb_chars[1], rgb_chars[1], rgb_chars[2], rgb_chars[2], rgb_chars[3], rgb_chars[3]};
                    value = String.valueOf(rrggbb_chars);
                }
                try {
                    retValue = Integer.decode(value);
                    if (retValue <= 0xFFFFFF) break block8;
                    return 0xFFFFFF;
                }
                catch (NumberFormatException numberFormatException) {
                    return -1;
                }
            }
            return retValue;
        }
        int rgbValue = ColorUtil.parsePredefinedColor(value);
        if (rgbValue != -1) {
            return rgbValue;
        }
        if (ColorUtil.isCssAbsolute(value) || ColorUtil.isCssRelative(value)) {
            return ColorUtil.parseRGBColor(value);
        }
        return -1;
    }

    public static int[] getRGBs(int rgbValue) {
        if (rgbValue > 0xFFFFFF || rgbValue < 0) {
            return null;
        }
        int rgb = rgbValue;
        int r = rgb >> 16;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        return new int[]{r, g, b};
    }

    public static int[] getRGBs(String colorValue) {
        int rgb = ColorUtil.parseColor(colorValue);
        return rgb == -1 ? null : ColorUtil.getRGBs(rgb);
    }

    public static int formRGB(int r, int g, int b) {
        int n = r > 255 ? 255 : (r = r < 0 ? 0 : r);
        int n2 = g > 255 ? 255 : (g = g < 0 ? 0 : g);
        b = b > 255 ? 255 : (b < 0 ? 0 : b);
        return (r << 16) + (g << 8) + b;
    }
}

