/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl;

public class NamingUtil {
    private static final String OLAP_PREFIX = "olap/";
    private static final String CUBE_PREFIX = "olap/cube_";
    private static final String DIMENSION_PREFIX = "olap/dim_";
    private static final String HIERARCHY_PREFIX = "olap/hierarchy_";
    private static final String LEVEL_INDEX = "olap/level_index_";
    private static final String HIERARCHY_OFFSET = "olap/hierarchy_offset_";
    private static final String FACT_TABLE = "olap/fact_table_";
    private static final String FTSU_LIST = "olap/ftsu_list_";
    private static final String AGGREGATION_RS_DOC = "olap/rs_doc_";
    public static final String DERIVED_MEASURE_PREFIX = "_${DERIVED_MEASURE}$_";

    public static String getCubeDocName(String cubeName) {
        return CUBE_PREFIX + cubeName;
    }

    public static String getDimensionDocName(String dimensionName) {
        return DIMENSION_PREFIX + dimensionName;
    }

    public static String getHierarchyDocName(String dimensionName, String hierarchylName) {
        return HIERARCHY_PREFIX + dimensionName + hierarchylName;
    }

    public static String getLevelIndexDocName(String dimensionName, String levelName) {
        return LEVEL_INDEX + dimensionName + '_' + levelName;
    }

    public static String getLevelIndexOffsetDocName(String dimensionName, String levelName) {
        return String.valueOf(NamingUtil.getLevelIndexDocName(dimensionName, levelName)) + "_offset";
    }

    public static String getHierarchyOffsetDocName(String dimensionName, String hierarchylName) {
        return HIERARCHY_OFFSET + dimensionName + hierarchylName;
    }

    public static String getFactTableName(String factTableName) {
        return FACT_TABLE + factTableName;
    }

    public static String getDerivedMeasureName(String measureName) {
        return DERIVED_MEASURE_PREFIX + measureName;
    }

    public static String getMeasureName(String name) {
        if (name != null && name.startsWith(DERIVED_MEASURE_PREFIX)) {
            return name.substring(DERIVED_MEASURE_PREFIX.length());
        }
        return name;
    }

    public static boolean isDerivedMeasureName(String name) {
        if (name != null) {
            return name.startsWith(DERIVED_MEASURE_PREFIX);
        }
        return false;
    }

    public static String getFTSUListName(String factTableName) {
        return FTSU_LIST + factTableName;
    }

    public static String getAggregationRSDocName(String ID) {
        return AGGREGATION_RS_DOC + ID;
    }
}

