/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.LocalContext;
import freemarker.core.NonSequenceOrCollectionException;
import freemarker.core.ParameterRole;
import freemarker.core.TemplateElement;
import freemarker.template.SimpleNumber;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateSequenceModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

final class IteratorBlock
extends TemplateElement {
    private Expression listSource;
    private String loopVariableName;
    private boolean isForEach;

    IteratorBlock(Expression listExpression, String indexName, TemplateElement nestedBlock, boolean isForEach) {
        this.listSource = listExpression;
        this.loopVariableName = indexName;
        this.isForEach = isForEach;
        this.nestedBlock = nestedBlock;
    }

    void accept(Environment env) throws TemplateException, IOException {
        TemplateModel baseModel = this.listSource.eval(env);
        if (baseModel == null) {
            if (env.isClassicCompatible()) {
                return;
            }
            this.listSource.assertNonNull(null, env);
        }
        env.visitIteratorBlock(new Context(baseModel));
    }

    protected String dump(boolean canonical) {
        StringBuffer buf = new StringBuffer();
        if (canonical) {
            buf.append('<');
        }
        buf.append(this.getNodeTypeSymbol());
        buf.append(' ');
        if (this.isForEach) {
            buf.append(this.loopVariableName);
            buf.append(" in ");
            buf.append(this.listSource.getCanonicalForm());
        } else {
            buf.append(this.listSource.getCanonicalForm());
            buf.append(" as ");
            buf.append(this.loopVariableName);
        }
        if (canonical) {
            buf.append(">");
            if (this.nestedBlock != null) {
                buf.append(this.nestedBlock.getCanonicalForm());
            }
            buf.append("</");
            buf.append(this.getNodeTypeSymbol());
            buf.append('>');
        }
        return buf.toString();
    }

    int getParameterCount() {
        return 2;
    }

    Object getParameterValue(int idx) {
        switch (idx) {
            case 0: {
                return this.listSource;
            }
            case 1: {
                return this.loopVariableName;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    ParameterRole getParameterRole(int idx) {
        switch (idx) {
            case 0: {
                return ParameterRole.LIST_SOURCE;
            }
            case 1: {
                return ParameterRole.TARGET_LOOP_VARIABLE;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    String getNodeTypeSymbol() {
        return this.isForEach ? "#foreach" : "#list";
    }

    class Context
    implements LocalContext {
        private boolean hasNext;
        private TemplateModel loopVar;
        private int index;
        private Collection variableNames = null;
        private TemplateModel list;

        Context(TemplateModel list) {
            this.list = list;
        }

        void runLoop(Environment env) throws TemplateException, IOException {
            if (this.list instanceof TemplateCollectionModel) {
                TemplateCollectionModel baseListModel = (TemplateCollectionModel)this.list;
                TemplateModelIterator it = baseListModel.iterator();
                this.hasNext = it.hasNext();
                while (this.hasNext) {
                    this.loopVar = it.next();
                    this.hasNext = it.hasNext();
                    if (IteratorBlock.this.nestedBlock != null) {
                        env.visit(IteratorBlock.this.nestedBlock);
                    }
                    ++this.index;
                }
            } else if (this.list instanceof TemplateSequenceModel) {
                TemplateSequenceModel tsm = (TemplateSequenceModel)this.list;
                int size = tsm.size();
                this.index = 0;
                while (this.index < size) {
                    this.loopVar = tsm.get(this.index);
                    boolean bl = this.hasNext = size > this.index + 1;
                    if (IteratorBlock.this.nestedBlock != null) {
                        env.visitByHiddingParent(IteratorBlock.this.nestedBlock);
                    }
                    ++this.index;
                }
            } else if (env.isClassicCompatible()) {
                this.loopVar = this.list;
                if (IteratorBlock.this.nestedBlock != null) {
                    env.visitByHiddingParent(IteratorBlock.this.nestedBlock);
                }
            } else {
                throw new NonSequenceOrCollectionException(IteratorBlock.this.listSource, this.list, env);
            }
        }

        public TemplateModel getLocalVariable(String name) {
            if (name.startsWith(IteratorBlock.this.loopVariableName)) {
                switch (name.length() - IteratorBlock.this.loopVariableName.length()) {
                    case 0: {
                        return this.loopVar;
                    }
                    case 6: {
                        if (!name.endsWith("_index")) break;
                        return new SimpleNumber(this.index);
                    }
                    case 9: {
                        if (!name.endsWith("_has_next")) break;
                        return this.hasNext ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
                    }
                }
            }
            return null;
        }

        public Collection getLocalVariableNames() {
            if (this.variableNames == null) {
                this.variableNames = new ArrayList(3);
                this.variableNames.add(IteratorBlock.this.loopVariableName);
                this.variableNames.add(IteratorBlock.this.loopVariableName + "_index");
                this.variableNames.add(IteratorBlock.this.loopVariableName + "_has_next");
            }
            return this.variableNames;
        }
    }
}

