/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.internal.adapter;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.IDataScriptEngine;
import org.eclipse.birt.data.engine.api.querydefn.ScriptDataSourceDesign;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.data.adapter.internal.adapter.DataAdapterUtil;
import org.eclipse.birt.report.model.api.ScriptDataSourceHandle;
import org.mozilla.javascript.Context;

public class ScriptDataSourceAdapter
extends ScriptDataSourceDesign {
    public static final String CASSANDRA_DATA_SOURCE_VALUE = "me.prettyprint.hector";
    public static final String SCRIPT_TYPE = "script_type";
    public static final String CASSANDRA_DATA_SOURCE_SCRIPT = "Cassandra";

    public ScriptDataSourceAdapter(ScriptDataSourceHandle source, DataSessionContext context) throws BirtException {
        super(source.getQualifiedName());
        DataAdapterUtil.adaptBaseDataSource(source, this);
        if (source.getProperty(SCRIPT_TYPE) != null && source.getProperty(SCRIPT_TYPE).equals(CASSANDRA_DATA_SOURCE_VALUE)) {
            this.validateScriptDataSource(source, context);
        }
        this.setOpenScript(source.getOpen());
        this.setCloseScript(source.getClose());
    }

    private void validateScriptDataSource(ScriptDataSourceHandle source, DataSessionContext context) throws AdapterException {
        ScriptContext scriptContext = null;
        try {
            scriptContext = context.getDataEngineContext().getScriptContext();
            IDataScriptEngine scriptEngine = (IDataScriptEngine)((Object)scriptContext.getScriptEngine("javascript"));
            Context cx = scriptEngine.getJSContext(scriptContext);
            cx.getApplicationClassLoader().loadClass("me.prettyprint.hector.api.factory.HFactory");
        }
        catch (BirtException birtException) {
            try {
                this.retryCustomClassLoader(context);
            }
            catch (ClassNotFoundException e) {
                throw new AdapterException("datasource.cassandra.error", e);
            }
            catch (BirtException e) {
                throw new AdapterException("datasource.cassandra.error", e);
            }
        }
        catch (ClassNotFoundException e) {
            try {
                this.retryCustomClassLoader(context);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new AdapterException("datasource.cassandra.error", e);
            }
            catch (BirtException birtException) {
                throw new AdapterException("datasource.cassandra.error", e);
            }
        }
    }

    private void retryCustomClassLoader(DataSessionContext context) throws ClassNotFoundException, BirtException {
        ClassLoader customClassLoader = context.getDataEngineContext().getClassLoader();
        customClassLoader.loadClass("me.prettyprint.hector.api.factory.HFactory");
    }
}

