/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import liquibase.change.Change;
import liquibase.change.ChangeFactory;
import liquibase.change.ChangeMetaData;
import liquibase.change.ChangeParameterMetaData;
import liquibase.change.CheckSum;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeNote;
import liquibase.change.DatabaseChangeProperty;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.exception.RollbackImpossibleException;
import liquibase.exception.SetupException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.resource.ResourceAccessor;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.serializer.core.string.StringChangeLogSerializer;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.SqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.util.StringUtils;

public abstract class AbstractChange
implements Change {
    private ResourceAccessor resourceAccessor;
    private ChangeSet changeSet;

    @Override
    public void finishInitialization() throws SetupException {
    }

    @Override
    public ChangeMetaData createChangeMetaData() {
        try {
            DatabaseChange databaseChange = this.getClass().getAnnotation(DatabaseChange.class);
            if (databaseChange == null) {
                throw new UnexpectedLiquibaseException("No @DatabaseChange annotation for " + this.getClass().getName());
            }
            HashSet<ChangeParameterMetaData> params = new HashSet<ChangeParameterMetaData>();
            PropertyDescriptor[] propertyDescriptorArray = Introspector.getBeanInfo(this.getClass()).getPropertyDescriptors();
            int n = propertyDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                DatabaseChangeProperty annotation;
                PropertyDescriptor property = propertyDescriptorArray[n2];
                Method readMethod = property.getReadMethod();
                Method writeMethod = property.getWriteMethod();
                if (readMethod == null) {
                    try {
                        readMethod = this.getClass().getMethod("is" + StringUtils.upperCaseFirst(property.getName()), new Class[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (readMethod != null && writeMethod != null && ((annotation = readMethod.getAnnotation(DatabaseChangeProperty.class)) == null || annotation.isChangeProperty())) {
                    params.add(this.createChangeParameterMetadata(property.getDisplayName()));
                }
                ++n2;
            }
            HashMap<String, String> notes = new HashMap<String, String>();
            DatabaseChangeNote[] databaseChangeNoteArray = databaseChange.databaseNotes();
            int n3 = databaseChangeNoteArray.length;
            n = 0;
            while (n < n3) {
                DatabaseChangeNote note = databaseChangeNoteArray[n];
                notes.put(note.database(), note.notes());
                ++n;
            }
            return new ChangeMetaData(databaseChange.name(), databaseChange.description(), databaseChange.priority(), databaseChange.appliesTo(), notes, params);
        }
        catch (Throwable e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    protected ChangeParameterMetaData createChangeParameterMetadata(String parameterName) {
        try {
            String displayName = parameterName.replaceAll("([A-Z])", " $1");
            displayName = String.valueOf(displayName.substring(0, 1).toUpperCase()) + displayName.substring(1);
            PropertyDescriptor property = null;
            PropertyDescriptor[] propertyDescriptorArray = Introspector.getBeanInfo(this.getClass()).getPropertyDescriptors();
            int n = propertyDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor prop = propertyDescriptorArray[n2];
                if (prop.getDisplayName().equals(parameterName)) {
                    property = prop;
                    break;
                }
                ++n2;
            }
            if (property == null) {
                throw new UnexpectedLiquibaseException("Could not find property " + parameterName);
            }
            Method readMethod = property.getReadMethod();
            if (readMethod == null) {
                readMethod = this.getClass().getMethod("is" + StringUtils.upperCaseFirst(property.getName()), new Class[0]);
            }
            Type type = readMethod.getGenericReturnType();
            DatabaseChangeProperty changePropertyAnnotation = readMethod.getAnnotation(DatabaseChangeProperty.class);
            String mustEqualExisting = this.createMustEqualExistingMetaData(parameterName, changePropertyAnnotation);
            String description = this.createDescriptionMetaData(parameterName, changePropertyAnnotation);
            String example = this.createExampleValueMetaData(parameterName, changePropertyAnnotation);
            String since = this.createSinceMetaData(parameterName, changePropertyAnnotation);
            LiquibaseSerializable.SerializationType serializationType = this.createSerializationTypeMetaData(parameterName, changePropertyAnnotation);
            String[] requiredForDatabase = this.createRequiredDatabasesMetaData(parameterName, changePropertyAnnotation);
            String[] supportsDatabase = this.createSupportedDatabasesMetaData(parameterName, changePropertyAnnotation);
            return new ChangeParameterMetaData(this, parameterName, displayName, description, example, since, type, requiredForDatabase, supportsDatabase, mustEqualExisting, serializationType);
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    protected String createSinceMetaData(String parameterName, DatabaseChangeProperty changePropertyAnnotation) {
        if (changePropertyAnnotation == null) {
            return null;
        }
        return StringUtils.trimToNull(changePropertyAnnotation.since());
    }

    protected String createDescriptionMetaData(String parameterName, DatabaseChangeProperty changePropertyAnnotation) {
        if (changePropertyAnnotation == null) {
            return null;
        }
        return StringUtils.trimToNull(changePropertyAnnotation.description());
    }

    protected LiquibaseSerializable.SerializationType createSerializationTypeMetaData(String parameterName, DatabaseChangeProperty changePropertyAnnotation) {
        if (changePropertyAnnotation == null) {
            return LiquibaseSerializable.SerializationType.NAMED_FIELD;
        }
        return changePropertyAnnotation.serializationType();
    }

    protected String createMustEqualExistingMetaData(String parameterName, DatabaseChangeProperty changePropertyAnnotation) {
        if (changePropertyAnnotation == null) {
            return null;
        }
        return changePropertyAnnotation.mustEqualExisting();
    }

    protected String createExampleValueMetaData(String parameterName, DatabaseChangeProperty changePropertyAnnotation) {
        if (changePropertyAnnotation == null) {
            return null;
        }
        return StringUtils.trimToNull(changePropertyAnnotation.exampleValue());
    }

    protected String[] createRequiredDatabasesMetaData(String parameterName, DatabaseChangeProperty changePropertyAnnotation) {
        if (changePropertyAnnotation == null) {
            return new String[]{"COMPUTE"};
        }
        return changePropertyAnnotation.requiredForDatabase();
    }

    protected String[] createSupportedDatabasesMetaData(String parameterName, DatabaseChangeProperty changePropertyAnnotation) {
        if (changePropertyAnnotation == null) {
            return new String[]{"COMPUTE"};
        }
        return changePropertyAnnotation.supportsDatabase();
    }

    @Override
    @DatabaseChangeProperty(isChangeProperty=false)
    public ChangeSet getChangeSet() {
        return this.changeSet;
    }

    @Override
    public void setChangeSet(ChangeSet changeSet) {
        this.changeSet = changeSet;
    }

    @Override
    public boolean generateStatementsVolatile(Database database) {
        SqlStatement[] statements = this.generateStatements(database);
        if (statements == null) {
            return false;
        }
        SqlStatement[] sqlStatementArray = statements;
        int n = statements.length;
        int n2 = 0;
        while (n2 < n) {
            SqlStatement statement = sqlStatementArray[n2];
            if (SqlGeneratorFactory.getInstance().generateStatementsVolatile(statement, database)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean generateRollbackStatementsVolatile(Database database) {
        SqlStatement[] statements = this.generateStatements(database);
        if (statements == null) {
            return false;
        }
        SqlStatement[] sqlStatementArray = statements;
        int n = statements.length;
        int n2 = 0;
        while (n2 < n) {
            SqlStatement statement = sqlStatementArray[n2];
            if (SqlGeneratorFactory.getInstance().generateRollbackStatementsVolatile(statement, database)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean supports(Database database) {
        if (this.generateStatementsVolatile(database)) {
            return true;
        }
        SqlStatement[] statements = this.generateStatements(database);
        if (statements == null) {
            return true;
        }
        SqlStatement[] sqlStatementArray = statements;
        int n = statements.length;
        int n2 = 0;
        while (n2 < n) {
            SqlStatement statement = sqlStatementArray[n2];
            if (!SqlGeneratorFactory.getInstance().supports(statement, database)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public Warnings warn(Database database) {
        Warnings warnings = new Warnings();
        if (this.generateStatementsVolatile(database)) {
            return warnings;
        }
        SqlStatement[] statements = this.generateStatements(database);
        if (statements == null) {
            return warnings;
        }
        SqlStatement[] sqlStatementArray = statements;
        int n = statements.length;
        int n2 = 0;
        while (n2 < n) {
            SqlStatement statement = sqlStatementArray[n2];
            if (SqlGeneratorFactory.getInstance().supports(statement, database)) {
                warnings.addAll(SqlGeneratorFactory.getInstance().warn(statement, database));
            } else if (statement.skipOnUnsupported()) {
                warnings.addWarning(String.valueOf(statement.getClass().getName()) + " is not supported on " + database.getShortName() + ", but " + ChangeFactory.getInstance().getChangeMetaData(this).getName() + " will still execute");
            }
            ++n2;
        }
        return warnings;
    }

    @Override
    public ValidationErrors validate(Database database) {
        ValidationErrors changeValidationErrors = new ValidationErrors();
        for (ChangeParameterMetaData param : ChangeFactory.getInstance().getChangeMetaData(this).getParameters().values()) {
            if (!param.isRequiredFor(database) || param.getCurrentValue(this) != null) continue;
            changeValidationErrors.addError(String.valueOf(param.getParameterName()) + " is required for " + ChangeFactory.getInstance().getChangeMetaData(this).getName() + " on " + database.getShortName());
        }
        if (changeValidationErrors.hasErrors()) {
            return changeValidationErrors;
        }
        String unsupportedWarning = String.valueOf(ChangeFactory.getInstance().getChangeMetaData(this).getName()) + " is not supported on " + database.getShortName();
        if (!this.supports(database)) {
            changeValidationErrors.addError(unsupportedWarning);
        } else {
            boolean sawUnsupportedError = false;
            SqlStatement[] statements = this.generateStatements(database);
            if (statements != null) {
                SqlStatement[] sqlStatementArray = statements;
                int n = statements.length;
                int n2 = 0;
                while (n2 < n) {
                    SqlStatement statement = sqlStatementArray[n2];
                    boolean supported = SqlGeneratorFactory.getInstance().supports(statement, database);
                    if (!supported && !sawUnsupportedError) {
                        if (!statement.skipOnUnsupported()) {
                            changeValidationErrors.addError(unsupportedWarning);
                            sawUnsupportedError = true;
                        }
                    } else {
                        changeValidationErrors.addAll(SqlGeneratorFactory.getInstance().validate(statement, database));
                    }
                    ++n2;
                }
            }
        }
        return changeValidationErrors;
    }

    @Override
    public SqlStatement[] generateRollbackStatements(Database database) throws RollbackImpossibleException {
        return this.generateRollbackStatementsFromInverse(database);
    }

    @Override
    public boolean supportsRollback(Database database) {
        return this.createInverses() != null;
    }

    @Override
    public CheckSum generateCheckSum() {
        return CheckSum.compute(new StringChangeLogSerializer().serialize(this, false));
    }

    private SqlStatement[] generateRollbackStatementsFromInverse(Database database) throws RollbackImpossibleException {
        Change[] inverses = this.createInverses();
        if (inverses == null) {
            throw new RollbackImpossibleException("No inverse to " + this.getClass().getName() + " created");
        }
        ArrayList<SqlStatement> statements = new ArrayList<SqlStatement>();
        try {
            Change[] changeArray = inverses;
            int n = inverses.length;
            int n2 = 0;
            while (n2 < n) {
                Change inverse = changeArray[n2];
                if (!inverse.supports(database)) {
                    throw new RollbackImpossibleException(String.valueOf(ChangeFactory.getInstance().getChangeMetaData(inverse).getName()) + " is not supported on " + database.getShortName());
                }
                statements.addAll(Arrays.asList(inverse.generateStatements(database)));
                ++n2;
            }
        }
        catch (LiquibaseException e) {
            throw new RollbackImpossibleException(e);
        }
        return statements.toArray(new SqlStatement[statements.size()]);
    }

    protected Change[] createInverses() {
        return null;
    }

    @Override
    public void setResourceAccessor(ResourceAccessor resourceAccessor) {
        this.resourceAccessor = resourceAccessor;
    }

    @DatabaseChangeProperty(isChangeProperty=false)
    public ResourceAccessor getResourceAccessor() {
        return this.resourceAccessor;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects(Database database) {
        if (this.generateStatementsVolatile(database)) {
            return new HashSet<DatabaseObject>();
        }
        HashSet<DatabaseObject> affectedObjects = new HashSet<DatabaseObject>();
        SqlStatement[] statements = this.generateStatements(database);
        if (statements != null) {
            SqlStatement[] sqlStatementArray = statements;
            int n = statements.length;
            int n2 = 0;
            while (n2 < n) {
                SqlStatement statement = sqlStatementArray[n2];
                affectedObjects.addAll(SqlGeneratorFactory.getInstance().getAffectedDatabaseObjects(statement, database));
                ++n2;
            }
        }
        return affectedObjects;
    }

    @Override
    public Set<String> getSerializableFields() {
        return ChangeFactory.getInstance().getChangeMetaData(this).getParameters().keySet();
    }

    @Override
    public Object getSerializableFieldValue(String field) {
        return ChangeFactory.getInstance().getChangeMetaData(this).getParameters().get(field).getCurrentValue(this);
    }

    @Override
    public String getSerializedObjectName() {
        return ChangeFactory.getInstance().getChangeMetaData(this).getName();
    }

    @Override
    public LiquibaseSerializable.SerializationType getSerializableFieldType(String field) {
        return ChangeFactory.getInstance().getChangeMetaData(this).getParameters().get(field).getSerializationType();
    }

    @Override
    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/dbchangelog-ext";
    }
}

