/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.impl;

import java.util.Iterator;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.nLayout.area.IArea;
import org.eclipse.birt.report.engine.nLayout.area.IContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.IImageArea;
import org.eclipse.birt.report.engine.nLayout.area.ITemplateArea;
import org.eclipse.birt.report.engine.nLayout.area.ITextArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.CellArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.w3c.dom.css.CSSValue;

public abstract class AbstractArea
implements IArea {
    protected static Logger logger = Logger.getLogger(AbstractArea.class.getName());
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected int baseLine = 0;
    protected float scale = 1.0f;
    protected transient CSSValue vAlign;
    protected String bookmark = null;
    protected boolean ignoreReordering = false;
    protected transient ContainerArea parent;
    protected transient boolean isDummy = false;
    protected IHyperlinkAction action = null;

    AbstractArea(AbstractArea area) {
        this.x = area.getX();
        this.y = area.getY();
        this.baseLine = area.getBaseLine();
        this.bookmark = area.getBookmark();
        this.action = area.getAction();
        this.scale = area.getScale();
        this.width = area.getWidth();
        this.height = area.getHeight();
        this.isDummy = area.isDummy;
    }

    public ContainerArea getParent() {
        return this.parent;
    }

    public void setParent(ContainerArea parent) {
        this.parent = parent;
    }

    public CSSValue getVerticalAlign() {
        return this.vAlign;
    }

    public void setVerticalAlign(CSSValue vAlign) {
        this.vAlign = vAlign;
    }

    AbstractArea() {
    }

    @Override
    public String getBookmark() {
        return this.bookmark;
    }

    public void setBookmark(String bookmark) {
        this.bookmark = bookmark;
    }

    @Override
    public IHyperlinkAction getAction() {
        return this.action;
    }

    public void setAction(IHyperlinkAction action) {
        this.action = action;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setAllocatedPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setAllocatedY(int ay) {
        this.y = ay;
    }

    public void setAllocatedX(int ax) {
        this.x = ax;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getAllocatedWidth() {
        return this.width;
    }

    public int getAllocatedHeight() {
        return this.height;
    }

    public void setBaseLine(int baseLine) {
        this.baseLine = baseLine;
    }

    public int getBaseLine() {
        if (this.baseLine == 0) {
            return this.height;
        }
        return this.baseLine;
    }

    public abstract AbstractArea cloneArea();

    public AbstractArea deepClone() {
        return this.cloneArea();
    }

    public int getAllocatedX() {
        return this.x;
    }

    public int getAllocatedY() {
        return this.y;
    }

    public boolean isIgnoreReordering() {
        return this.ignoreReordering;
    }

    public void setIgnoreReordering(boolean ignoreReordering) {
        this.ignoreReordering = ignoreReordering;
    }

    public static void debugPrint(IArea area) {
        if (area instanceof IContainerArea) {
            System.out.print(area.getClass() + "||");
            System.out.println("x:" + area.getX() + " y:" + area.getY() + " width:" + area.getWidth() + " height:" + area.getHeight());
            Iterator<IArea> i = ((IContainerArea)area).getChildren();
            while (i.hasNext()) {
                IArea child = i.next();
                AbstractArea.debugPrint(child);
            }
        } else {
            AbstractArea.debugPrintVisual(area);
        }
    }

    public static void debugPrintVisual(IArea area) {
        if (area instanceof ITextArea) {
            System.out.println(((ITextArea)area).getText());
        } else if (area instanceof IImageArea) {
            System.out.println("[image]");
        } else if (area instanceof ITemplateArea) {
            System.out.println("[template]");
        }
    }

    public static void debugPrintWithComputedXY(IArea area) {
        AbstractArea.debugPrint(area, 0, 0);
    }

    private static void debugPrint(IArea area, int x, int y) {
        if (area instanceof IContainerArea) {
            System.out.print(area.getClass() + "||");
            if (((ContainerArea)area).getContent() != null) {
                System.out.print(((ContainerArea)area).getContent().getInstanceID() + "||");
            }
            if (area instanceof CellArea) {
                System.out.print("rowspan:" + ((CellArea)area).getRowSpan() + "||");
            }
            System.out.println("x:" + (x += area.getX()) + " y:" + (y += area.getY()) + " width:" + area.getWidth() + " height:" + area.getHeight());
            Iterator<IArea> i = ((IContainerArea)area).getChildren();
            while (i.hasNext()) {
                IArea child = i.next();
                AbstractArea.debugPrint(child, x, y);
            }
            y = (x -= area.getX()) - area.getY();
        } else {
            AbstractArea.debugPrintVisual(area);
        }
    }
}

