/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.olap.OLAPException;
import javax.olap.cursor.DimensionCursor;
import javax.olap.cursor.EdgeCursor;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.ICubeCursor;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.data.api.IBindingValueFetcher;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.AggregationRowAccessor;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;

public class BindingValueFetcher
implements IBindingValueFetcher {
    private Node node = new Node(null);
    private List<String> bindingNames;
    private List<String> levels;
    private AggregationRowAccessor currentRow;
    private int currentRowIndex;
    private List currentBindingValues;
    private List<Set<String>> dimLevelOfInteresting;
    private static Dummy DUMMYOBJ = new Dummy();

    public BindingValueFetcher(ICubeCursor cursor, ICubeQueryDefinition queryDefn, List<String> bindingOfInteresting, List<Set<String>> dimLevelOfInteresting) throws DataException {
        this.bindingNames = bindingOfInteresting;
        this.levels = new ArrayList<String>();
        this.currentBindingValues = new ArrayList();
        this.dimLevelOfInteresting = dimLevelOfInteresting;
        this.populateOrderedLvls(cursor);
        this.populateBindingValueTree(cursor, bindingOfInteresting);
    }

    private void populateBindingValueTree(ICubeCursor cursor, List<String> bindingOfInteresting) throws DataException {
        ArrayList memberValue = new ArrayList();
        List edges = cursor.getOrdinateEdge();
        if (edges.size() > 0) {
            this.populateNode(edges, cursor, memberValue, bindingOfInteresting);
        }
    }

    private void populateNode(List<EdgeCursor> edgeCursors, ICubeCursor cursor, List memberValue, List<String> bindingOfInteresting) throws DataException {
        EdgeCursor edge = edgeCursors.get(0);
        edge.beforeFirst();
        while (edge.next()) {
            ArrayList<Object> temp = new ArrayList<Object>();
            temp.addAll(memberValue);
            List dimCursors = edge.getDimensionCursor();
            for (DimensionCursor dim : dimCursors) {
                temp.add(dim.getObject(0));
            }
            if (edgeCursors.size() == 1) {
                ArrayList<Object> bindingValues = new ArrayList<Object>();
                for (String bindingName : bindingOfInteresting) {
                    bindingValues.add(cursor.getObject(bindingName));
                }
                this.node.add(temp, bindingValues);
                continue;
            }
            this.populateNode(edgeCursors.subList(1, edgeCursors.size()), cursor, temp, bindingOfInteresting);
        }
    }

    private void populateOrderedLvls(ICubeCursor cursor) throws OLAPException {
        for (EdgeCursor edge : cursor.getOrdinateEdge()) {
            for (DimensionCursor dim : edge.getDimensionCursor()) {
                String dimLvl = dim.getName();
                dimLvl = String.valueOf(dimLvl) + "/" + dimLvl.split("/")[1];
                this.levels.add(dimLvl);
            }
        }
    }

    @Override
    public Object getValue(String bindingName, AggregationRowAccessor row, int rowIndex) throws DataException {
        int index = this.bindingNames.indexOf(bindingName);
        if (index != -1) {
            Set<String> involvedLvl = this.dimLevelOfInteresting.get(index);
            if (this.currentRow != row || this.currentRowIndex != rowIndex) {
                ArrayList<Object> memberValues = new ArrayList<Object>();
                memberValues.add(DUMMYOBJ);
                for (String lvlName : this.levels) {
                    if (involvedLvl.contains(lvlName) || row.isAxisLevel(lvlName)) {
                        memberValues.add(row.getFieldValue(lvlName));
                        continue;
                    }
                    memberValues.add(DUMMYOBJ);
                }
                this.currentBindingValues = this.node.getBindingValue(memberValues);
                this.currentRow = row;
                this.currentRowIndex = rowIndex;
            }
            return this.currentBindingValues == null ? null : this.currentBindingValues.get(index);
        }
        return null;
    }

    private static class Dummy {
        private Dummy() {
        }
    }

    private class Node {
        private Object value;
        private Set<Node> sub;
        private List bindingValues;

        Node(Object value) {
            this.value = value;
            this.sub = new HashSet<Node>();
        }

        private boolean valueEqual(Object o) throws DataException {
            if (o == DUMMYOBJ) {
                return true;
            }
            if (this.value == null) {
                return true;
            }
            return ScriptEvalUtil.compare(this.value, o) == 0;
        }

        public Node find(List memberValue) throws DataException {
            if (!this.valueEqual(memberValue.get(0))) {
                return null;
            }
            if (memberValue.size() == 1 && this.valueEqual(memberValue.get(0))) {
                return this;
            }
            for (Node subNode : this.sub) {
                Node result = subNode.find(memberValue.subList(1, memberValue.size()));
                if (result == null) continue;
                return result;
            }
            return null;
        }

        public String toString() {
            String result = "";
            for (Node subNode : this.sub) {
                result = String.valueOf(result) + subNode.value + ",";
            }
            return result;
        }

        public List getBindingValue(List memberValues) throws DataException {
            Node result = this.find(memberValues);
            if (result == null) {
                return null;
            }
            return result.bindingValues;
        }

        public void add(List memberValues, List bindingValues) throws DataException {
            if (!memberValues.isEmpty()) {
                Object o = memberValues.get(0);
                boolean addNewNode = true;
                for (Node subNode : this.sub) {
                    if (subNode.valueEqual(o)) {
                        subNode.add(memberValues.size() == 1 ? new ArrayList() : memberValues.subList(1, memberValues.size()), bindingValues);
                        addNewNode = false;
                    }
                    if (!addNewNode) break;
                }
                if (addNewNode) {
                    Node newNode = new Node(o);
                    this.sub.add(newNode);
                    newNode.add(memberValues.size() == 1 ? new ArrayList() : memberValues.subList(1, memberValues.size()), bindingValues);
                }
            } else {
                this.bindingValues = bindingValues;
            }
        }
    }
}

