/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.wpml;

import java.util.HashSet;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.ir.DimensionType;

public class WordUtil {
    private static final String LINESTYLE_SOLID = "solid";
    private static final String LINESTYLE_DASH = "dash";
    private static final String LINESTYLE_DOT = "dot";
    private static final String LINESTYLE_SINGLE = "single";
    private static HashSet<Character> splitChar = new HashSet();
    public static final double INCH_PT = 72.0;
    public static final double PT_TWIPS = 20.0;
    public static final double INCH_TWIPS = 1440.0;

    static {
        splitChar.add(Character.valueOf(' '));
        splitChar.add(Character.valueOf('\r'));
        splitChar.add(Character.valueOf('\n'));
    }

    public static String validBookmarkName(String name) {
        String bookmark = name.replaceAll(" ", "_");
        bookmark = bookmark.replaceAll("\"", "_");
        return bookmark;
    }

    public static int convertTo(DimensionType value, int prefValue, int dpi) {
        if (value == null) {
            return prefValue;
        }
        if ("%".equalsIgnoreCase(value.getUnits())) {
            return (int)((double)prefValue * value.getMeasure() / 100.0);
        }
        return (int)WordUtil.convertTo(value, dpi);
    }

    public static double convertTo(DimensionType value, int dpi) {
        double INCH_PX = dpi;
        double PX_TWIPS = 1440.0 / INCH_PX;
        if (value == null || "%".equalsIgnoreCase(value.getUnits())) {
            return -1.0;
        }
        if ("px".equalsIgnoreCase(value.getUnits())) {
            return value.getMeasure() * PX_TWIPS;
        }
        if ("em".equalsIgnoreCase(value.getUnits()) || "ex".equalsIgnoreCase(value.getUnits())) {
            return value.getMeasure() * 12.0 * 20.0;
        }
        double val = value.convertTo("in");
        return val * 1440.0;
    }

    public static double convertImageSize(DimensionType value, int ref, int dpi) {
        double INCH_PX = dpi;
        double PX_PT = 72.0 / INCH_PX;
        if (value == null) {
            return (double)ref * PX_PT;
        }
        if ("px".equalsIgnoreCase(value.getUnits())) {
            return value.getMeasure() * PX_PT;
        }
        if ("%".equalsIgnoreCase(value.getUnits())) {
            return value.getMeasure() / 100.0 * (double)ref * PX_PT;
        }
        return value.convertTo("in") * 72.0;
    }

    public static double twipToPt(double t) {
        return t / 20.0;
    }

    public static int milliPt2Twips(float floatValue) {
        return (int)((double)Math.round(floatValue / 1000.0f) * 20.0);
    }

    public static int parseFontSize(float value) {
        return Math.round(value / 500.0f);
    }

    public static String capitalize(String text) {
        boolean capitalizeNextChar = true;
        char[] array = text.toCharArray();
        int i = 0;
        while (i < array.length) {
            Character c = Character.valueOf(text.charAt(i));
            if (splitChar.contains(c)) {
                capitalizeNextChar = true;
            } else if (capitalizeNextChar) {
                array[i] = Character.toUpperCase(array[i]);
                capitalizeNextChar = false;
            }
            ++i;
        }
        return new String(array);
    }

    public static String parseColor(String color) {
        return EmitterUtil.parseColor(color);
    }

    public static String parseBorderStyle(String style) {
        if (LINESTYLE_SOLID.equalsIgnoreCase(style)) {
            return LINESTYLE_SINGLE;
        }
        return style;
    }

    public static String parseImageBorderStyle(String style) {
        if ("dotted".equalsIgnoreCase(style)) {
            return LINESTYLE_DOT;
        }
        if ("dashed".equalsIgnoreCase(style)) {
            return LINESTYLE_DASH;
        }
        if (LINESTYLE_SOLID.equalsIgnoreCase(style)) {
            return LINESTYLE_SINGLE;
        }
        return style;
    }

    public static String parseVerticalAlign(String align) {
        if ("middle".equals(align)) {
            return "center";
        }
        return align;
    }

    public static String removeQuote(String val) {
        if (val.charAt(0) == '\"' && val.charAt(val.length() - 1) == '\"') {
            return val.substring(1, val.length() - 1);
        }
        return val;
    }

    public static int parseBorderSize(float size) {
        int w = Math.round(size);
        return 8 * w / 1000;
    }

    public static String parseLineStyle(String style) {
        if ("dotted".equalsIgnoreCase(style)) {
            return LINESTYLE_DOT;
        }
        if ("dashed".equalsIgnoreCase(style)) {
            return LINESTYLE_DASH;
        }
        if ("double".equalsIgnoreCase(style)) {
            return LINESTYLE_SOLID;
        }
        return style;
    }

    public static String[] parseBackgroundSize(String height, String width, int imageWidth, int imageHeight, double pageWidth, double pageHeight) {
        String actualHeight = height;
        String actualWidth = width;
        if (height == null || "auto".equalsIgnoreCase(height)) {
            actualHeight = String.valueOf(String.valueOf(pageHeight)) + "pt";
        }
        if (width == null || "auto".equalsIgnoreCase(width)) {
            actualWidth = String.valueOf(String.valueOf(pageWidth)) + "pt";
        }
        actualHeight = actualHeight.trim();
        if ("contain".equalsIgnoreCase(actualWidth = actualWidth.trim()) || "contain".equalsIgnoreCase(actualHeight)) {
            double rh = (double)imageHeight / pageHeight;
            double rw = (double)imageWidth / pageWidth;
            if (rh > rw) {
                actualHeight = String.valueOf(String.valueOf(pageHeight)) + "pt";
                actualWidth = String.valueOf(String.valueOf((double)imageWidth * pageHeight / (double)imageHeight)) + "pt";
            } else {
                actualWidth = String.valueOf(String.valueOf(pageWidth)) + "pt";
                actualHeight = String.valueOf(String.valueOf((double)imageHeight * pageWidth / (double)imageWidth)) + "pt";
            }
        } else if ("cover".equals(actualWidth) || "cover".equals(actualHeight)) {
            double rh = (double)imageHeight / pageHeight;
            double rw = (double)imageWidth / pageWidth;
            if (rh > rw) {
                actualWidth = String.valueOf(String.valueOf(pageWidth)) + "pt";
                actualHeight = String.valueOf(String.valueOf((double)imageHeight * pageWidth / (double)imageWidth)) + "pt";
            } else {
                actualHeight = String.valueOf(String.valueOf(pageHeight)) + "pt";
                actualWidth = String.valueOf(String.valueOf((double)imageWidth * pageHeight / (double)imageHeight)) + "pt";
            }
        }
        if (height != null && height.endsWith("%")) {
            actualHeight = String.valueOf(WordUtil.getPercentValue(height, pageHeight)) + "pt";
        }
        if (width != null && width.endsWith("%")) {
            actualWidth = String.valueOf(WordUtil.getPercentValue(width, pageWidth)) + "pt";
        }
        return new String[]{actualHeight, actualWidth};
    }

    private static String getPercentValue(String height, double pageHeight) {
        String value = null;
        try {
            String percent = height.substring(0, height.length() - 1);
            int percentValue = Integer.valueOf(percent);
            value = String.valueOf(pageHeight * (double)percentValue / 100.0);
        }
        catch (NumberFormatException numberFormatException) {
            value = height;
        }
        return value;
    }

    public static boolean isField(int autoTextType) {
        return autoTextType == 1 || autoTextType == 0;
    }

    public static boolean isField(IContent content) {
        if (content.getContentType() == 12) {
            IAutoTextContent autoText = (IAutoTextContent)content;
            int type = autoText.getType();
            return WordUtil.isField(type);
        }
        return false;
    }
}

