/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches;

import com.google.common.base.Function;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.TuttiConfiguration;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.accidental.create.CreateAccidentalBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyCellComponent;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.split.SplitBenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.create.CreateIndividualObservationBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.create.CreateMarineLitterBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyCellComponent;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.SplitSpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiTabContainerUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.catches.EnterWeightUI;
import fr.ifremer.tutti.ui.swing.util.computable.ComputableData;
import fr.ifremer.tutti.ui.swing.util.computable.ComputableDataEditor;
import fr.ifremer.tutti.util.Weights;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.swing.CardLayout2Ext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGOMRectElement;
import org.apache.batik.dom.svg.SVGOMTextElement;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.gvt.GVTTreeRendererAdapter;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.GVTTreeRendererListener;
import org.apache.batik.util.RunnableQueue;
import org.apache.batik.util.XMLResourceDescriptor;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.tab.TabHandler;
import org.nuiton.util.Resource;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGStylable;

public class EditCatchesUIHandler
extends AbstractTuttiTabContainerUIHandler<EditCatchesUIModel, EditCatchesUI>
implements TabHandler {
    public static final String MAIN_CARD = "main";
    public static final String CREATE_BATCH_CARD = "createBatch";
    public static final String SPLIT_BATCH_CARD = "splitBatch";
    public static final String ADD_SAMPLE_CATEGORY_BATCH_CARD = "addSampleCategoryBatch";
    public static final String EDIT_FREQUENCY_CARD = "editFrequency";
    public static final String EDIT_CARACTERISTICS_CARD = "caracteristicsCard";
    public static final String CAROUSSEL_TREMIE_VESSEL = "carousselTremieVessel";
    public static final String CLASSIC_VESSEL = "classicVessel";
    private static final Log log;
    private TuttiBeanMonitor<EditCatchesUIModel> catchBatchMonitor;
    private final PropertyChangeListener totalWeightRejectedListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            EditCatchesUIModel source = (EditCatchesUIModel)evt.getSource();
            Float totalWeight = (Float)evt.getNewValue();
            if (totalWeight != null && Weights.isEqualWeight(totalWeight.floatValue(), 0.0f)) {
                source.setCatchTotalRejectedWeight(null);
            }
        }
    };
    protected JSVGCanvas canvas;
    protected Document svgDocument;

    public void beforeInit(EditCatchesUI ui) {
        super.beforeInit((ApplicationUI)ui);
        this.catchBatchMonitor = new TuttiBeanMonitor("marineLitterTotalWeight", "speciesTotalSortedWeight", "speciesTotalInertWeight", "speciesTotalLivingNotItemizedWeight", "benthosTotalSortedWeight", "benthosTotalInertWeight", "benthosTotalLivingNotItemizedWeight");
        EditCatchesUIModel model = ui.getContextValue(EditCatchesUIModel.class);
        model.setValidationContext(this.getContext().getValidationContext());
        this.listModelIsModify(model);
        this.catchBatchMonitor.setBean(model);
    }

    public void afterInit(EditCatchesUI ui) {
        ui.getBenthosTabSplitBatch().getModel().setSplitMode(true);
        ui.getBenthosTabAddSampleCategoryBatch().getModel().setSplitMode(false);
        ui.getSpeciesTabSplitBatch().getModel().setSplitMode(true);
        ui.getSpeciesTabAddSampleCategoryBatch().getModel().setSplitMode(false);
        this.initUI(ui);
        EditCatchesUIModel model = (EditCatchesUIModel)this.getModel();
        this.changeValidatorContext(model.getValidationContext(), this.getValidator());
        this.listenValidationTableHasNoFatalError((SimpleBeanValidator)this.getValidator(), model);
        this.setCustomTab(0, model);
        this.setCustomTab(1, model);
        this.setCustomTab(2, ui.getSpeciesTabContent().getModel());
        this.setCustomTab(3, ui.getBenthosTabContent().getModel());
        this.setCustomTab(4, ui.getMarineLitterTabContent().getModel());
        this.setCustomTab(5, ui.getIndividualObservationTabContent().getModel());
        this.setCustomTab(6, ui.getAccidentalTabContent().getModel());
        this.getTabPanel().setSelectedIndex(1);
        this.getTabPanel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EditCatchesUIHandler.this.closeAttachments();
            }
        });
        try {
            this.initResumeSvg();
        }
        catch (IOException err) {
            if (log.isErrorEnabled()) {
                log.error((Object)"error while initializing the resume background", (Throwable)err);
            }
            this.getContext().getErrorHelper().showErrorDialog(I18n.t((String)"tutti.editCatchBatch.svgLoading.error", (Object[])new Object[0]), (Throwable)err);
        }
    }

    public void initResumeSvg() throws IOException {
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory f = new SAXSVGDocumentFactory(parser);
        URL url = Resource.getURL((String)"EcranResume.svg");
        this.svgDocument = f.createDocument(url.toString());
        this.canvas = new JSVGCanvas();
        this.canvas.setSize(new Dimension(1, 1));
        this.canvas.setMySize(new Dimension(1, 1));
        ((EditCatchesUI)this.getUI()).getSvgCanvasPanel().add((Component)this.canvas, "Center");
        this.canvas.setRecenterOnResize(true);
        this.canvas.addGVTTreeRendererListener((GVTTreeRendererListener)new GVTTreeRendererAdapter(){

            public void gvtRenderingCompleted(GVTTreeRendererEvent gvtTreeRendererEvent) {
                log.info((Object)"gvtRenderingCompleted");
                TuttiConfiguration config = EditCatchesUIHandler.this.getConfig();
                WeightUnit catchWeightUnit = WeightUnit.KG;
                WeightUnit speciesWeightUnit = config.getSpeciesWeightUnit();
                WeightUnit benthosWeightUnit = config.getBenthosWeightUnit();
                WeightUnit marineLitterWeightUnit = config.getMarineLitterWeightUnit();
                EditCatchesUIModel model = (EditCatchesUIModel)EditCatchesUIHandler.this.getModel();
                EditCatchesUIHandler.this.initSvgField("catchTotalWeight", model.getCatchTotalComputedOrNotWeight(), catchWeightUnit, new String[0]);
                EditCatchesUIHandler.this.initSvgField("catchTotalSortedComputedWeight", catchWeightUnit, new String[0]);
                EditCatchesUIHandler.this.initSvgField("catchTotalRejectedWeight", model.getCatchTotalRejectedComputedOrNotWeight(), catchWeightUnit, new String[0]);
                EditCatchesUIHandler.this.initSvgField("catchTotalSortedSortedComputedWeight", catchWeightUnit, new String[0]);
                EditCatchesUIHandler.this.initSvgField("speciesTotalSortedWeight", model.getSpeciesTotalSortedComputedOrNotWeight(), speciesWeightUnit, new String[0]);
                EditCatchesUIHandler.this.initSvgField("speciesTotalSampleSortedComputedWeight", speciesWeightUnit, new String[0]);
                EditCatchesUIHandler.this.initSvgField("benthosTotalSortedWeight", model.getBenthosTotalSortedComputedOrNotWeight(), benthosWeightUnit, new String[0]);
                EditCatchesUIHandler.this.initSvgField("benthosTotalSampleSortedComputedWeight", benthosWeightUnit, new String[0]);
                EditCatchesUIHandler.this.initSvgField("catchTotalUnsortedComputedWeight", catchWeightUnit, new String[0]);
                EditCatchesUIHandler.this.initSvgField("speciesTotalUnsortedComputedWeight", speciesWeightUnit, new String[0]);
                EditCatchesUIHandler.this.initSvgField("benthosTotalUnsortedComputedWeight", benthosWeightUnit, new String[0]);
                model.addPropertyChangeListener(new ChangeElementBackgroundColorPropertyChangeListener("speciesTotalUnsortedComputedWeight", Sets.newHashSet((Object[])new String[]{"catchTotalRejectedWeight", "catchTotalRejectedComputedWeight", "speciesTotalSortedWeight", "speciesTotalSortedComputedWeight", "speciesTotalSampleSortedComputedWeight"}), EditCatchesUIHandler.this.canvas, EditCatchesUIHandler.this.svgDocument, new Function<EditCatchesUIModel, Color>(){

                    public Color apply(EditCatchesUIModel model) {
                        boolean warning = model.isSpeciesTotalUnsortedComputedWeightInWarning();
                        return warning ? Color.ORANGE : Color.decode("#006bba");
                    }
                }));
                model.addPropertyChangeListener(new ChangeElementBackgroundColorPropertyChangeListener("benthosTotalUnsortedComputedWeight", Sets.newHashSet((Object[])new String[]{"catchTotalRejectedWeight", "catchTotalRejectedComputedWeight", "benthosTotalSortedWeight", "benthosTotalSortedComputedWeight", "benthosTotalSampleSortedComputedWeight"}), EditCatchesUIHandler.this.canvas, EditCatchesUIHandler.this.svgDocument, new Function<EditCatchesUIModel, Color>(){

                    public Color apply(EditCatchesUIModel model) {
                        boolean warning = model.isBenthosTotalUnsortedComputedWeightInWarning();
                        return warning ? Color.ORANGE : Color.decode("#006bba");
                    }
                }));
                EditCatchesUIHandler.this.initSvgField("speciesTotalComputedWeight", speciesWeightUnit, "benthosTotalComputedWeight", "marineLitterTotalWeight");
                EditCatchesUIHandler.this.initSvgField("benthosTotalComputedWeight", benthosWeightUnit, "speciesTotalComputedWeight", "marineLitterTotalWeight");
                EditCatchesUIHandler.this.initSvgField("marineLitterTotalWeight", model.getMarineLitterTotalComputedOrNotWeight(), marineLitterWeightUnit, "speciesTotalComputedWeight", "benthosTotalComputedWeight");
                model.addPropertyChangeListener(new RatioPropertyChangeListener("ratioSpeciesSampleSortedOverSpeciesSortedWeightLabel", "speciesTotalSampleSortedComputedWeight", "speciesTotalSortedWeight", "speciesTotalSortedComputedWeight", EditCatchesUIHandler.this.canvas, EditCatchesUIHandler.this.svgDocument));
                model.addPropertyChangeListener(new RatioPropertyChangeListener("ratioBenthosSampleSortedOverBenthosSortedWeightLabel", "benthosTotalSampleSortedComputedWeight", "benthosTotalSortedWeight", "benthosTotalSortedComputedWeight", EditCatchesUIHandler.this.canvas, EditCatchesUIHandler.this.svgDocument));
                EditCatchesUIHandler.this.initSpeciesCount("speciesDistinctSortedSpeciesCount");
                EditCatchesUIHandler.this.initSpeciesCount("benthosDistinctSortedSpeciesCount");
            }
        });
        this.canvas.setDocumentState(1);
        this.canvas.setDocument(this.svgDocument);
    }

    protected void initSpeciesCount(final String property) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init " + property + " field"));
        }
        this.canvas.getUpdateManager().getUpdateRunnableQueue().invokeLater(new Runnable(){

            @Override
            public void run() {
                Element labelElement = EditCatchesUIHandler.this.svgDocument.getElementById(property + "Label");
                labelElement.setTextContent(I18n.t((String)("tutti.editCatchBatch.field." + property), (Object[])new Object[0]));
            }
        });
        ((EditCatchesUIModel)this.getModel()).addPropertyChangeListener(property, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Integer value = (Integer)evt.getNewValue();
                Element labelElement = EditCatchesUIHandler.this.svgDocument.getElementById(property + "Value");
                labelElement.setTextContent(JAXXUtil.getStringValue((Object)value));
            }
        });
    }

    protected void initSvgField(String property, WeightUnit weightUnit, String ... idsInGroup) {
        this.initSvgField(property, null, weightUnit, idsInGroup);
    }

    protected void initSvgField(final String property, final ComputableData<Float> computableData, final WeightUnit weightUnit, final String ... idsInGroup) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init " + property + " field"));
        }
        this.canvas.getUpdateManager().getUpdateRunnableQueue().invokeLater(new Runnable(){

            @Override
            public void run() {
                Element rectElement = EditCatchesUIHandler.this.svgDocument.getElementById(property + "Rect");
                SVGOMRectElement rectElem = (SVGOMRectElement)rectElement;
                SVGRect bbox = rectElem.getBBox();
                Float x = Float.valueOf(bbox.getX());
                Element labelElement = EditCatchesUIHandler.this.svgDocument.getElementById(property + "Label");
                if (computableData == null) {
                    SVGStylable field = (SVGStylable)labelElement;
                    CSSStyleDeclaration style = field.getStyle();
                    style.setProperty("font-style", "italic", null);
                }
                SVGOMTextElement labelTextElem = (SVGOMTextElement)labelElement;
                labelElement.setTextContent(weightUnit.decorateLabel(I18n.t((String)("tutti.editCatchBatch.field." + property), (Object[])new Object[0])));
                bbox = labelTextElem.getBBox();
                float labelX = bbox.getX();
                float width = Math.abs(x.floatValue() - labelX) + 10.0f;
                SVGOMRectElement labelRectElement = (SVGOMRectElement)EditCatchesUIHandler.this.svgDocument.getElementById(property + "LabelRect");
                float actualWidth = Math.abs(labelRectElement.getBBox().getX() - labelX) + 10.0f;
                if (actualWidth < width) {
                    labelRectElement.setAttribute("width", Float.toString(width));
                    labelRectElement.setAttribute("x", String.valueOf(labelX - 10.0f));
                    for (String id : idsInGroup) {
                        Element el = EditCatchesUIHandler.this.svgDocument.getElementById(id + "LabelRect");
                        el.setAttribute("width", Float.toString(width));
                        el.setAttribute("x", String.valueOf(labelX - 10.0f));
                    }
                }
            }
        });
        Color colorComputedWeights = this.getConfig().getColorComputedWeights();
        if (computableData == null) {
            OnDataOrComputedDataValueChangedListener listener = new OnDataOrComputedDataValueChangedListener(property, weightUnit, true, this.canvas, this.svgDocument, colorComputedWeights, idsInGroup);
            ((EditCatchesUIModel)this.getModel()).addPropertyChangeListener(property, listener);
        } else {
            Element element = this.svgDocument.getElementById(property);
            EventTarget target = (EventTarget)((Object)element);
            target.addEventListener("click", new OnValueClickListener(computableData, property, weightUnit), false);
            OnDataOrComputedDataValueChangedListener listener = new OnDataOrComputedDataValueChangedListener(property, weightUnit, false, this.canvas, this.svgDocument, colorComputedWeights, idsInGroup);
            computableData.addPropertyChangeListener(listener);
        }
    }

    public void closeAttachments() {
        ((EditCatchesUI)this.ui).getCatchesCaracteristicsAttachmentsButton().onCloseUI();
        ((EditCatchesUI)this.ui).getSpeciesTabContent().getSpeciesBatchAttachmentsButton().onCloseUI();
        ((EditCatchesUI)this.ui).getBenthosTabContent().getBenthosBatchAttachmentsButton().onCloseUI();
        ((EditCatchesUI)this.ui).getMarineLitterTabContent().getMarineLitterBatchAttachmentsButton().onCloseUI();
        ((EditCatchesUI)this.ui).getIndividualObservationTabContent().getIndividualObservationBatchAttachmentsButton().onCloseUI();
        ((EditCatchesUI)this.ui).getAccidentalTabContent().getAccidentalBatchAttachmentsButton().onCloseUI();
    }

    protected JComponent getComponentToFocus() {
        ComputableDataEditor<Float> result = ((EditCatchesUIModel)this.getModel()).getCatchTotalComputedWeight() != null ? null : ((EditCatchesUI)this.getUI()).getCatchTotalWeightField();
        return result;
    }

    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        ((EditCatchesUI)this.ui).getCatchesCaracteristicsAttachmentsButton().onCloseUI();
        this.closeUI(((EditCatchesUI)this.ui).getSpeciesTabContent());
        this.closeUI(((EditCatchesUI)this.ui).getBenthosTabContent());
        this.closeUI(((EditCatchesUI)this.ui).getMarineLitterTabContent());
        this.closeUI(((EditCatchesUI)this.ui).getAccidentalTabContent());
        this.closeUI(((EditCatchesUI)this.ui).getIndividualObservationTabContent());
    }

    public SwingValidator<EditCatchesUIModel> getValidator() {
        return ((EditCatchesUI)this.ui).getValidator();
    }

    @Override
    protected Set<String> getPropertiesToIgnore() {
        Set<String> result = super.getPropertiesToIgnore();
        result.addAll(Sets.newHashSet((Object[])new String[]{"catchTotalComputedWeight", "catchTotalUnsortedComputedWeight", "catchTotalSortedComputedWeight", "catchTotalSortedSortedComputedWeight", "catchTotalRejectedComputedWeight", "speciesTotalComputedWeight", "speciesTotalSortedComputedWeight", "speciesTotalUnsortedComputedWeight", "speciesTotalSampleSortedComputedWeight", "speciesTotalInertComputedWeight", "speciesTotalLivingNotItemizedComputedWeight", "benthosTotalComputedWeight", "benthosTotalSortedComputedWeight", "benthosTotalUnsortedComputedWeight", "benthosTotalSampleSortedComputedWeight", "benthosTotalInertComputedWeight", "benthosTotalLivingNotItemizedComputedWeight", "speciesDistinctSortedSpeciesCount", "benthosDistinctSortedSpeciesCount", "attachment", "batchUpdated"}));
        return result;
    }

    public JTabbedPane getTabPanel() {
        return ((EditCatchesUI)this.ui).getTabPane();
    }

    @Override
    public boolean onTabChanged(int currentIndex, int newIndex) {
        ((EditCatchesUI)this.ui).getCatchesCaracteristicsAttachmentsButton().onCloseUI();
        ((EditCatchesUI)this.ui).getComputeSpeciesBatchButton().setVisible(newIndex < 4);
        ((EditCatchesUI)this.ui).getCleanSpeciesBatchButton().setVisible(newIndex < 3);
        return super.onTabChanged(currentIndex, newIndex);
    }

    public boolean onHideTab(int currentIndex, int newIndex) {
        boolean result;
        this.closeAttachments();
        EditCatchesUIModel model = (EditCatchesUIModel)this.getModel();
        if (model.isModify()) {
            if (model.isValid()) {
                int answer = this.askSaveBeforeLeaving(I18n.t((String)"tutti.editCatchBatch.askSaveBeforeLeaving.saveCatchBatch", (Object[])new Object[0]));
                switch (answer) {
                    case 0: {
                        this.getContext().getActionEngine().runAction((AbstractButton)((EditCatchesUI)this.getUI()).getSaveButton());
                        result = true;
                        break;
                    }
                    case 1: {
                        this.getContext().getActionEngine().runAction((AbstractButton)((EditCatchesUI)this.getUI()).getCancelButton());
                        result = true;
                        break;
                    }
                    default: {
                        result = false;
                        break;
                    }
                }
            } else {
                result = this.askCancelEditBeforeLeaving(I18n.t((String)"tutti.editCatchBatch.askCancelEditBeforeLeaving.cancelEditCatchBatch", (Object[])new Object[0]));
                if (result) {
                    this.getContext().getActionEngine().runAction((AbstractButton)((EditCatchesUI)this.ui).getCancelButton());
                }
            }
        } else {
            result = true;
        }
        return result;
    }

    public void onShowTab(int currentIndex, int newIndex) {
        this.registerValidators();
    }

    public boolean removeTab(int i) {
        return false;
    }

    public boolean onRemoveTab() {
        return false;
    }

    public void uninstallTotalRejectWeightListener() {
        ((EditCatchesUIModel)this.getModel()).removePropertyChangeListener("catchTotalRejectedWeight", this.totalWeightRejectedListener);
    }

    public void installTotalRejectWeightListener() {
        ((EditCatchesUIModel)this.getModel()).addPropertyChangeListener("catchTotalRejectedWeight", this.totalWeightRejectedListener);
    }

    public TuttiBeanMonitor<EditCatchesUIModel> getCatchBatchMonitor() {
        return this.catchBatchMonitor;
    }

    protected void registerValidators() {
        this.registerValidators(this.getValidator(), ((EditCatchesUI)this.ui).getSpeciesTabContent().getHandler().getValidator(), ((EditCatchesUI)this.ui).getBenthosTabContent().getHandler().getValidator(), ((EditCatchesUI)this.ui).getMarineLitterTabContent().getHandler().getValidator());
    }

    public void editSpeciesFrequencies(SpeciesFrequencyCellComponent.FrequencyCellEditor editor) {
        SpeciesFrequencyUI frequencyEditor = ((EditCatchesUI)this.ui).getSpeciesTabFrequencyEditor();
        frequencyEditor.getHandler().editBatch(editor);
        this.setSpeciesSelectedCard(EDIT_FREQUENCY_CARD);
        SpeciesBatchRowModel editRow = editor.getEditRow();
        String title = this.buildReminderLabelTitle(editRow.getSpecies(), editRow, ((EditCatchesUI)this.ui).getSpeciesTabFishingOperationReminderLabel().getTitle(), I18n.t((String)"tutti.editSpeciesFrequencies.title", (Object[])new Object[0]));
        ((EditCatchesUI)this.ui).getSpeciesTabFrequencyEditorReminderLabel().setTitle(title);
    }

    public void splitSpeciesBatch(SpeciesBatchRowModel editRow, SplitSpeciesBatchUI splitBatchEditor) {
        splitBatchEditor.getHandler().editBatch(editRow);
        this.setSpeciesSelectedCard(SPLIT_BATCH_CARD);
        String title = this.buildReminderLabelTitle(editRow.getSpecies(), editRow, ((EditCatchesUI)this.ui).getSpeciesTabFishingOperationReminderLabel().getTitle(), I18n.t((String)"tutti.splitSpeciesBatch.title", (Object[])new Object[0]));
        ((EditCatchesUI)this.ui).getSpeciesTabSplitBatchReminderLabel().setTitle(title);
    }

    public void addSampleCategorySpeciesBatch(SpeciesBatchRowModel editRow, SplitSpeciesBatchUI splitBatchEditor, int sampleCategoryId) {
        splitBatchEditor.getHandler().editBatch(editRow, sampleCategoryId);
        this.setSpeciesSelectedCard(ADD_SAMPLE_CATEGORY_BATCH_CARD);
        String title = this.buildReminderLabelTitle(editRow.getSpecies(), editRow, ((EditCatchesUI)this.ui).getSpeciesTabFishingOperationReminderLabel().getTitle(), I18n.t((String)"tutti.addSampleCategorySpeciesBatch.title", (Object[])new Object[0]));
        ((EditCatchesUI)this.ui).getSpeciesTabAddSampleCategoryBatchReminderLabel().setTitle(title);
    }

    public void setSpeciesSelectedCard(String card) {
        JPanel panel = ((EditCatchesUI)this.ui).getSpeciesTabPanel();
        CardLayout2Ext layout = (CardLayout2Ext)panel.getLayout();
        if (!card.equals(layout.getSelected())) {
            layout.setSelected(card);
            Table actionPanel = ((EditCatchesUI)this.getUI()).getCreateFishingOperationActions();
            if (MAIN_CARD.equals(card)) {
                this.registerValidators();
                actionPanel.setVisible(true);
            } else {
                actionPanel.setVisible(false);
                JPanel tuttiUi = null;
                JXTitledPanel titlePanel = null;
                String title = "";
                if (CREATE_BATCH_CARD.equals(card)) {
                    tuttiUi = ((EditCatchesUI)this.ui).getSpeciesTabCreateBatch();
                    titlePanel = ((EditCatchesUI)this.ui).getSpeciesTabCreateBatchReminderLabel();
                    title = I18n.n((String)"tutti.createSpeciesBatch.title", (Object[])new Object[0]);
                } else if (SPLIT_BATCH_CARD.equals(card)) {
                    tuttiUi = ((EditCatchesUI)this.ui).getSpeciesTabSplitBatch();
                } else if (ADD_SAMPLE_CATEGORY_BATCH_CARD.equals(card)) {
                    tuttiUi = ((EditCatchesUI)this.ui).getSpeciesTabAddSampleCategoryBatch();
                } else if (EDIT_FREQUENCY_CARD.equals(card)) {
                    tuttiUi = ((EditCatchesUI)this.ui).getSpeciesTabFrequencyEditor();
                }
                if (tuttiUi != null) {
                    this.registerValidators(tuttiUi.getHandler().getValidator());
                }
                if (titlePanel != null) {
                    titlePanel.setTitle(((EditCatchesUI)this.ui).getSpeciesTabFishingOperationReminderLabel().getTitle() + " - " + I18n.t((String)title, (Object[])new Object[0]));
                }
            }
        }
    }

    public void editBenthosFrequencies(BenthosFrequencyCellComponent.FrequencyCellEditor editor) {
        BenthosFrequencyUI frequencyEditor = ((EditCatchesUI)this.ui).getBenthosTabFrequencyEditor();
        frequencyEditor.getHandler().editBatch(editor);
        this.setBenthosSelectedCard(EDIT_FREQUENCY_CARD);
        BenthosBatchRowModel editRow = editor.getEditRow();
        String title = this.buildReminderLabelTitle(editRow.getSpecies(), editRow, ((EditCatchesUI)this.ui).getBenthosTabFishingOperationReminderLabel().getTitle(), I18n.t((String)"tutti.editBenthosFrequencies.title", (Object[])new Object[0]));
        ((EditCatchesUI)this.ui).getBenthosTabFrequencyEditorReminderLabel().setTitle(title);
    }

    public void splitBenthosBatch(BenthosBatchRowModel editRow, SplitBenthosBatchUI splitBatchEditor) {
        splitBatchEditor.getHandler().editBatch(editRow);
        this.setBenthosSelectedCard(SPLIT_BATCH_CARD);
        String title = this.buildReminderLabelTitle(editRow.getSpecies(), editRow, ((EditCatchesUI)this.ui).getBenthosTabFishingOperationReminderLabel().getTitle(), I18n.t((String)"tutti.splitBenthosBatch.title", (Object[])new Object[0]));
        ((EditCatchesUI)this.ui).getBenthosTabSplitBatchReminderLabel().setTitle(title);
    }

    public void addSampleCategoryBenthosBatch(BenthosBatchRowModel editRow, SplitBenthosBatchUI splitBatchEditor, int sampleCategoryId) {
        splitBatchEditor.getHandler().editBatch(editRow, sampleCategoryId);
        this.setBenthosSelectedCard(ADD_SAMPLE_CATEGORY_BATCH_CARD);
        String title = this.buildReminderLabelTitle(editRow.getSpecies(), editRow, ((EditCatchesUI)this.ui).getBenthosTabFishingOperationReminderLabel().getTitle(), I18n.t((String)"tutti.addSampleCategoryBenthosBatch.title", (Object[])new Object[0]));
        ((EditCatchesUI)this.ui).getBenthosTabAddSampleCategoryBatchReminderLabel().setTitle(title);
    }

    public void setBenthosSelectedCard(String card) {
        JPanel panel = ((EditCatchesUI)this.ui).getBenthosTabPanel();
        CardLayout2Ext layout = (CardLayout2Ext)panel.getLayout();
        if (!card.equals(layout.getSelected())) {
            layout.setSelected(card);
            Table actionPanel = ((EditCatchesUI)this.getUI()).getCreateFishingOperationActions();
            if (MAIN_CARD.equals(card)) {
                this.registerValidators();
                actionPanel.setVisible(true);
            } else {
                actionPanel.setVisible(false);
                JPanel tuttiUi = null;
                JXTitledPanel titlePanel = null;
                String title = "";
                if (CREATE_BATCH_CARD.equals(card)) {
                    tuttiUi = ((EditCatchesUI)this.ui).getBenthosTabCreateBatch();
                    titlePanel = ((EditCatchesUI)this.ui).getBenthosTabCreateBatchReminderLabel();
                    title = I18n.n((String)"tutti.createBenthosBatch.title", (Object[])new Object[0]);
                } else if (SPLIT_BATCH_CARD.equals(card)) {
                    tuttiUi = ((EditCatchesUI)this.ui).getBenthosTabSplitBatch();
                } else if (ADD_SAMPLE_CATEGORY_BATCH_CARD.equals(card)) {
                    tuttiUi = ((EditCatchesUI)this.ui).getBenthosTabAddSampleCategoryBatch();
                } else if (EDIT_FREQUENCY_CARD.equals(card)) {
                    tuttiUi = ((EditCatchesUI)this.ui).getBenthosTabFrequencyEditor();
                }
                if (tuttiUi != null) {
                    this.registerValidators(tuttiUi.getHandler().getValidator());
                }
                if (titlePanel != null) {
                    titlePanel.setTitle(((EditCatchesUI)this.ui).getBenthosTabFishingOperationReminderLabel().getTitle() + " - " + I18n.t((String)title, (Object[])new Object[0]));
                }
            }
        }
    }

    public void setMarineLitterSelectedCard(String card) {
        JPanel panel = ((EditCatchesUI)this.ui).getMarineLitterTabPanel();
        CardLayout2Ext layout = (CardLayout2Ext)panel.getLayout();
        if (!card.equals(layout.getSelected())) {
            layout.setSelected(card);
            Table actionPanel = ((EditCatchesUI)this.getUI()).getCreateFishingOperationActions();
            if (MAIN_CARD.equals(card)) {
                this.registerValidators();
                actionPanel.setVisible(true);
            } else {
                actionPanel.setVisible(false);
                CreateMarineLitterBatchUI tuttiUi = null;
                JXTitledPanel titlePanel = null;
                String title = "";
                if (CREATE_BATCH_CARD.equals(card)) {
                    tuttiUi = ((EditCatchesUI)this.ui).getMarineLitterTabCreateBatch();
                    titlePanel = ((EditCatchesUI)this.ui).getMarineLitterTabCreateBatchReminderLabel();
                    title = I18n.n((String)"tutti.createMarineLitterBatch.title", (Object[])new Object[0]);
                }
                if (tuttiUi != null) {
                    this.registerValidators(tuttiUi.getHandler().getValidator());
                }
                if (titlePanel != null) {
                    titlePanel.setTitle(((EditCatchesUI)this.ui).getMarineLitterTabCreateBatchReminderLabel().getTitle() + " - " + I18n.t((String)title, (Object[])new Object[0]));
                }
            }
        }
    }

    public void setIndividualObservationSelectedCard(String card) {
        this.setIndividualObservationSelectedCard(card, null);
    }

    public void setIndividualObservationSelectedCard(String card, Species species) {
        JPanel panel = ((EditCatchesUI)this.ui).getIndividualObservationTabPanel();
        CardLayout2Ext layout = (CardLayout2Ext)panel.getLayout();
        if (!card.equals(layout.getSelected())) {
            layout.setSelected(card);
            Table actionPanel = ((EditCatchesUI)this.getUI()).getCreateFishingOperationActions();
            if (MAIN_CARD.equals(card)) {
                this.registerValidators();
                actionPanel.setVisible(true);
            } else {
                actionPanel.setVisible(false);
                CreateIndividualObservationBatchUI tuttiUi = null;
                JXTitledPanel titlePanel = null;
                String title = "";
                if (CREATE_BATCH_CARD.equals(card)) {
                    tuttiUi = ((EditCatchesUI)this.ui).getIndividualObservationTabCreateBatch();
                    titlePanel = ((EditCatchesUI)this.ui).getIndividualObservationTabCreateBatchReminderLabel();
                    title = I18n.n((String)"tutti.createIndividualObservationBatch.title", (Object[])new Object[0]);
                } else if (EDIT_CARACTERISTICS_CARD.equals(card)) {
                    titlePanel = ((EditCatchesUI)this.ui).getIndividualObservationCaracteristicMapEditorReminderLabel();
                    title = I18n.n((String)"tutti.editCaracteristics.title", (Object[])new Object[0]);
                }
                if (tuttiUi != null) {
                    this.registerValidators(tuttiUi.getHandler().getValidator());
                }
                if (titlePanel != null) {
                    titlePanel.setTitle(((EditCatchesUI)this.ui).getIndividualObservationTabFishingOperationReminderLabel().getTitle() + " - " + I18n.t((String)title, (Object[])new Object[]{this.decorate(species)}));
                }
            }
        }
    }

    public void setAccidentalSelectedCard(String card) {
        this.setAccidentalSelectedCard(card, null);
    }

    public void setAccidentalSelectedCard(String card, Species species) {
        JPanel panel = ((EditCatchesUI)this.ui).getAccidentalTabPanel();
        CardLayout2Ext layout = (CardLayout2Ext)panel.getLayout();
        if (!card.equals(layout.getSelected())) {
            layout.setSelected(card);
            Table actionPanel = ((EditCatchesUI)this.getUI()).getCreateFishingOperationActions();
            if (MAIN_CARD.equals(card)) {
                this.registerValidators();
                actionPanel.setVisible(true);
            } else {
                actionPanel.setVisible(false);
                CreateAccidentalBatchUI tuttiUi = null;
                JXTitledPanel titlePanel = null;
                String title = "";
                if (CREATE_BATCH_CARD.equals(card)) {
                    tuttiUi = ((EditCatchesUI)this.ui).getAccidentalTabCreateBatch();
                    titlePanel = ((EditCatchesUI)this.ui).getAccidentalTabCreateBatchReminderLabel();
                    title = I18n.n((String)"tutti.createAccidentalBatch.title", (Object[])new Object[0]);
                } else if (EDIT_CARACTERISTICS_CARD.equals(card)) {
                    titlePanel = ((EditCatchesUI)this.ui).getAccidentalCaracteristicMapEditorReminderLabel();
                    title = I18n.n((String)"tutti.editCaracteristics.title", (Object[])new Object[0]);
                }
                if (tuttiUi != null) {
                    this.registerValidators(tuttiUi.getHandler().getValidator());
                }
                if (titlePanel != null) {
                    titlePanel.setTitle(((EditCatchesUI)this.ui).getAccidentalTabFishingOperationReminderLabel().getTitle() + " - " + I18n.t((String)title, (Object[])new Object[]{this.decorate(species)}));
                }
            }
        }
    }

    public String getWeightStringValueForTotalWeight(JLabel label, Float rejectWeight, Float totalWeight) {
        String result = rejectWeight == null || totalWeight == null ? this.getWeightStringValue(label, totalWeight) : I18n.t((String)"tutti.editCatchBatch.field.speciesOrBenthosTotalWeight.not.computed", (Object[])new Object[0]);
        return result;
    }

    public Color getWeightColorForTotalWeight(Float rejectWeight, Float totalWeight) {
        Color result = rejectWeight == null || totalWeight == null ? this.getConfig().getColorComputedWeights() : Color.RED;
        return result;
    }

    static {
        I18n.n((String)"tutti.editCatchBatch.field.catchTotalWeight", (Object[])new Object[0]);
        I18n.n((String)"tutti.editCatchBatch.field.catchTotalRejectedWeight", (Object[])new Object[0]);
        I18n.n((String)"tutti.editCatchBatch.field.speciesTotalSortedWeight", (Object[])new Object[0]);
        I18n.n((String)"tutti.editCatchBatch.field.benthosTotalSortedWeight", (Object[])new Object[0]);
        I18n.n((String)"tutti.editCatchBatch.field.marineLitterTotalWeight", (Object[])new Object[0]);
        I18n.n((String)"tutti.editCatchBatch.field.catchTotalSortedComputedWeight", (Object[])new Object[0]);
        I18n.n((String)"tutti.editCatchBatch.field.catchTotalSortedSortedComputedWeight", (Object[])new Object[0]);
        I18n.n((String)"tutti.editCatchBatch.field.catchTotalUnsortedComputedWeight", (Object[])new Object[0]);
        I18n.n((String)"tutti.editCatchBatch.field.speciesTotalComputedWeight", (Object[])new Object[0]);
        I18n.n((String)"tutti.editCatchBatch.field.speciesTotalUnsortedComputedWeight", (Object[])new Object[0]);
        I18n.n((String)"tutti.editCatchBatch.field.speciesTotalSampleSortedComputedWeight", (Object[])new Object[0]);
        I18n.n((String)"tutti.editCatchBatch.field.benthosTotalComputedWeight", (Object[])new Object[0]);
        I18n.n((String)"tutti.editCatchBatch.field.benthosTotalUnsortedComputedWeight", (Object[])new Object[0]);
        I18n.n((String)"tutti.editCatchBatch.field.benthosTotalSampleSortedComputedWeight", (Object[])new Object[0]);
        I18n.n((String)"tutti.editCatchBatch.field.speciesDistinctSortedSpeciesCount", (Object[])new Object[0]);
        I18n.n((String)"tutti.editCatchBatch.field.benthosDistinctSortedSpeciesCount", (Object[])new Object[0]);
        log = LogFactory.getLog(EditCatchesUIHandler.class);
    }

    private static class RatioPropertyChangeListener
    extends UpdateRunnableQueuePropertyChangeListener {
        private final String elementId;
        private final String numeratorProperty;
        private final String denominatorProperty;
        private final String denominatorComputedProperty;
        private Integer ratio = null;

        public RatioPropertyChangeListener(String elementId, String numeratorProperty, String denominatorProperty, String denominatorComputedProperty, JSVGCanvas canvas, Document svgDocument) {
            super(canvas, svgDocument);
            this.elementId = elementId;
            this.numeratorProperty = numeratorProperty;
            this.denominatorProperty = denominatorProperty;
            this.denominatorComputedProperty = denominatorComputedProperty;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if (this.numeratorProperty.equals(propertyName) || this.denominatorProperty.equals(propertyName)) {
                block6: {
                    EditCatchesUIModel model = (EditCatchesUIModel)evt.getSource();
                    try {
                        String numerator = BeanUtils.getProperty((Object)model, (String)this.numeratorProperty);
                        String denominator = BeanUtils.getProperty((Object)model, (String)this.denominatorProperty);
                        if (denominator == null) {
                            denominator = BeanUtils.getProperty((Object)model, (String)this.denominatorComputedProperty);
                        }
                        if (numerator != null && denominator != null) {
                            Float numeratorValue = Float.valueOf(numerator);
                            Float denominatorValue = Float.valueOf(denominator);
                            if (denominatorValue.floatValue() != 0.0f) {
                                this.ratio = (int)(100.0f * numeratorValue.floatValue() / denominatorValue.floatValue());
                            }
                        }
                    }
                    catch (ReflectiveOperationException e) {
                        if (!log.isErrorEnabled()) break block6;
                        log.error((Object)"Error while computing the ration", (Throwable)e);
                    }
                }
                this.getUpdateRunnableQueue().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("update " + RatioPropertyChangeListener.this.elementId + " field"));
                        }
                        Element ratioElement = RatioPropertyChangeListener.this.svgDocument.getElementById(RatioPropertyChangeListener.this.elementId);
                        String textContent = RatioPropertyChangeListener.this.ratio != null ? RatioPropertyChangeListener.this.ratio + "%" : null;
                        ratioElement.setTextContent(textContent);
                    }
                });
            }
        }
    }

    private static class ChangeElementBackgroundColorPropertyChangeListener
    extends UpdateRunnableQueuePropertyChangeListener {
        private final String elementId;
        private Set<String> propertiesToListen;
        private Function<EditCatchesUIModel, Color> colorFunction;

        public ChangeElementBackgroundColorPropertyChangeListener(String elementId, Set<String> propertiesToListen, JSVGCanvas canvas, Document svgDocument, Function<EditCatchesUIModel, Color> colorFunction) {
            super(canvas, svgDocument);
            this.elementId = elementId;
            this.propertiesToListen = propertiesToListen;
            this.colorFunction = colorFunction;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            EditCatchesUIModel model = (EditCatchesUIModel)evt.getSource();
            final Color background = (Color)this.colorFunction.apply((Object)model);
            if (this.propertiesToListen.contains(evt.getPropertyName())) {
                this.getUpdateRunnableQueue().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("update " + ChangeElementBackgroundColorPropertyChangeListener.this.elementId + " field"));
                        }
                        Element rectElement = ChangeElementBackgroundColorPropertyChangeListener.this.svgDocument.getElementById(ChangeElementBackgroundColorPropertyChangeListener.this.elementId + "LabelRect");
                        SVGStylable field = (SVGStylable)rectElement;
                        CSSStyleDeclaration style = field.getStyle();
                        String color = "#" + Integer.toHexString(background.getRGB()).substring(2);
                        style.setProperty("fill", color, null);
                    }
                });
            }
        }
    }

    private static class OnDataOrComputedDataValueChangedListener
    extends UpdateRunnableQueuePropertyChangeListener {
        private final String property;
        private final WeightUnit weightUnit;
        private final boolean onlyReactOnComputedData;
        private final Color colorComputedWeights;
        private final String[] idsInGroup;

        public OnDataOrComputedDataValueChangedListener(String property, WeightUnit weightUnit, boolean onlyReactOnComputedData, JSVGCanvas canvas, Document svgDocument, Color colorComputedWeights, String ... idsInGroup) {
            super(canvas, svgDocument);
            this.property = property;
            this.weightUnit = weightUnit;
            this.onlyReactOnComputedData = onlyReactOnComputedData;
            this.colorComputedWeights = colorComputedWeights;
            this.idsInGroup = idsInGroup;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Float newValue;
            boolean computedData;
            if (this.onlyReactOnComputedData) {
                computedData = true;
                newValue = (Float)evt.getNewValue();
            } else {
                ComputableData computableData = (ComputableData)((Object)evt.getSource());
                if (computableData.getData() == null) {
                    computedData = true;
                    newValue = (Float)computableData.getComputedData();
                } else {
                    computedData = false;
                    newValue = (Float)computableData.getData();
                }
            }
            this.updateValue(newValue, computedData);
        }

        private void updateValue(final Float value, final boolean computed) {
            this.getUpdateRunnableQueue().invokeLater(new Runnable(){

                @Override
                public void run() {
                    Element element;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("update " + OnDataOrComputedDataValueChangedListener.this.property + " field"));
                    }
                    if ((element = OnDataOrComputedDataValueChangedListener.this.svgDocument.getElementById(OnDataOrComputedDataValueChangedListener.this.property + "Value")) == null) {
                        return;
                    }
                    String textContent = value != null ? Weights.getWeightStringValue(value) + " " + OnDataOrComputedDataValueChangedListener.this.weightUnit.getShortLabel() : null;
                    element.setTextContent(textContent);
                    SVGStylable field = (SVGStylable)element;
                    CSSStyleDeclaration style = field.getStyle();
                    String computedColor = "#" + Integer.toHexString(OnDataOrComputedDataValueChangedListener.this.colorComputedWeights.getRGB()).substring(2);
                    style.setProperty("fill", computed ? computedColor : "#000000", null);
                    style.setProperty("font-style", computed ? "italic" : "normal", null);
                    SVGOMTextElement textElem = (SVGOMTextElement)element;
                    SVGRect bbox = textElem.getBBox();
                    if (bbox != null) {
                        float width = bbox.getWidth() + 15.0f;
                        SVGOMRectElement rectElement = (SVGOMRectElement)OnDataOrComputedDataValueChangedListener.this.svgDocument.getElementById(OnDataOrComputedDataValueChangedListener.this.property + "Rect");
                        float actualWidth = rectElement.getBBox().getWidth();
                        if (actualWidth < width) {
                            rectElement.setAttribute("width", Float.toString(width));
                            for (String id : OnDataOrComputedDataValueChangedListener.this.idsInGroup) {
                                Element el = OnDataOrComputedDataValueChangedListener.this.svgDocument.getElementById(id + "Rect");
                                el.setAttribute("width", Float.toString(width));
                            }
                        }
                    }
                }
            });
        }
    }

    private static abstract class UpdateRunnableQueuePropertyChangeListener
    implements PropertyChangeListener {
        protected final JSVGCanvas canvas;
        protected RunnableQueue updateRunnableQueue;
        protected final Document svgDocument;

        public UpdateRunnableQueuePropertyChangeListener(JSVGCanvas canvas, Document svgDocument) {
            this.canvas = canvas;
            this.svgDocument = svgDocument;
        }

        protected RunnableQueue getUpdateRunnableQueue() {
            if (this.updateRunnableQueue == null) {
                this.updateRunnableQueue = this.canvas.getUpdateManager().getUpdateRunnableQueue();
            }
            return this.updateRunnableQueue;
        }
    }

    private class OnValueClickListener
    implements EventListener {
        private final ComputableData<Float> computableData;
        private final String property;
        private final WeightUnit weightUnit;

        public OnValueClickListener(ComputableData<Float> computableData, String property, WeightUnit weightUnit) {
            this.computableData = computableData;
            this.property = property;
            this.weightUnit = weightUnit;
        }

        @Override
        public void handleEvent(Event evt) {
            log.info((Object)"element clicked");
            EnterWeightUI dialog = new EnterWeightUI(EditCatchesUIHandler.this.getContext());
            Float originalWeight = this.computableData.getData();
            Float weight = dialog.openAndGetWeightValue(I18n.t((String)("tutti.editCatchBatch.field." + this.property), (Object[])new Object[0]), originalWeight, this.weightUnit);
            if (!Objects.equals(originalWeight, weight)) {
                this.computableData.setData(weight);
            }
        }
    }
}

