/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmId;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.pupitri.PupitriImportResult;
import fr.ifremer.tutti.service.pupitri.PupitriImportService;
import fr.ifremer.tutti.ui.swing.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.action.EditFishingOperationAction;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.ImportPupitriPopupUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.AbstractApplicationUIHandler;

public class ImportPupitriAction
extends AbstractTuttiAction<SpeciesBatchUIModel, SpeciesBatchUI, SpeciesBatchUIHandler> {
    private static final Log log = LogFactory.getLog(ImportPupitriAction.class);
    protected File importedTrunkFile;
    protected File importedCarrouselFile;
    protected PersistenceService persistenceService = this.getContext().getPersistenceService();
    protected EditFishingOperationAction editAction;
    protected PupitriImportResult importResult;

    public ImportPupitriAction(SpeciesBatchUIHandler handler) {
        super(handler, false);
    }

    public EditFishingOperationAction getEditAction() {
        if (this.editAction == null) {
            FishingOperationsUI parentContainer = (FishingOperationsUI)((SpeciesBatchUIHandler)this.handler).getParentContainer(FishingOperationsUI.class);
            this.editAction = (EditFishingOperationAction)this.getContext().getActionFactory().createLogicAction((AbstractApplicationUIHandler)parentContainer.getHandler(), EditFishingOperationAction.class);
        }
        return this.editAction;
    }

    public boolean prepareAction() throws Exception {
        SpeciesBatchUIModel speciesBatchUIModel;
        boolean result = true;
        SampleCategoryModel sampleCategoryModel = this.getDataContext().getSampleCategoryModel();
        ArrayList missingCategories = Lists.newArrayList();
        if (!sampleCategoryModel.containsCategoryId(PmfmId.SIZE_CATEGORY.getValue())) {
            missingCategories.add("<li>" + this.persistenceService.getSizeCategoryCaracteristic().getParameterName() + "</li>");
        }
        if (!sampleCategoryModel.containsCategoryId(PmfmId.SEX.getValue())) {
            missingCategories.add("<li>" + this.persistenceService.getSexCaracteristic().getParameterName() + "</li>");
        }
        if (!missingCategories.isEmpty()) {
            result = false;
            JOptionPane.showMessageDialog((Component)this.getContext().getActionUI(), I18n.t((String)"tutti.editSpeciesBatch.action.importPupitri.invalidSampleCategoryModel.message", (Object[])new Object[]{Joiner.on((String)"").join((Iterable)missingCategories)}), I18n.t((String)"tutti.editSpeciesBatch.action.importPupitri.invalidSampleCategoryModel.title", (Object[])new Object[0]), 0, UIManager.getIcon("error"));
        }
        if (result && (speciesBatchUIModel = ((SpeciesBatchUI)this.getUI()).getModel()).getRowCount() > 0) {
            String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n.t((String)"tutti.editSpeciesBatch.action.importPupitri.existingData.message", (Object[])new Object[0]), I18n.t((String)"tutti.editSpeciesBatch.action.importPupitri.existingData.help", (Object[])new Object[0]));
            Component dialogParentComponent = this.getDialogParentComponent();
            int answer = JOptionPane.showConfirmDialog(dialogParentComponent, htmlMessage, I18n.t((String)"tutti.editSpeciesBatch.action.importPupitri.existingData.title", (Object[])new Object[0]), 2, 2);
            boolean bl = result = answer == 0;
        }
        if (result) {
            ImportPupitriPopupUI importPupitriDialog = new ImportPupitriPopupUI(((SpeciesBatchUIHandler)this.handler).getContext());
            importPupitriDialog.open();
            this.importedTrunkFile = importPupitriDialog.getTrunkFile().getSelectedFile();
            this.importedCarrouselFile = importPupitriDialog.getCarrouselFile().getSelectedFile();
            result = this.importedTrunkFile != null && this.importedCarrouselFile != null;
        }
        return result;
    }

    @Override
    public void doAction() throws Exception {
        EditCatchesUI parentContainer = (EditCatchesUI)((SpeciesBatchUIHandler)this.handler).getParentContainer(EditCatchesUI.class);
        EditCatchesUIModel model = parentContainer.getModel();
        FishingOperation operation = model.getFishingOperation();
        CatchBatch catchBatch = model.toEntity();
        PupitriImportService service = this.getContext().getPupitriImportService();
        this.importResult = service.importPupitri(this.importedTrunkFile, this.importedCarrouselFile, operation, catchBatch);
        if (this.importResult.isFishingOperationFound()) {
            this.getEditAction().loadCatchBatch(operation);
        }
    }

    public void releaseAction() {
        this.importedTrunkFile = null;
        this.importedCarrouselFile = null;
        super.releaseAction();
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        if (this.importResult.isFishingOperationFound()) {
            boolean showReport;
            Set notImportedSpeciesIds = this.importResult.getNotImportedSpeciesIds();
            int rejectedSpeciesNb = notImportedSpeciesIds.size();
            this.sendMessage(I18n.t((String)"tutti.editSpeciesBatch.action.importPupitri.success", (Object[])new Object[]{((SpeciesBatchUIModel)this.getModel()).getRootNumber(), rejectedSpeciesNb}));
            if (!notImportedSpeciesIds.isEmpty()) {
                StringBuilder content = new StringBuilder();
                for (String notImportedSpeciesId : notImportedSpeciesIds) {
                    content.append("<li>").append(notImportedSpeciesId).append("</li>");
                }
                String text = "<html><body>" + I18n.t((String)"tutti.editSpeciesBatch.action.importPupitri.speciesNotImported.message", (Object[])new Object[]{rejectedSpeciesNb, content.toString()}) + "</body></html>";
                this.displayWarningMessage(I18n.t((String)"tutti.editSpeciesBatch.action.importPupitri.speciesNotImported.title", (Object[])new Object[0]), text);
            }
            String reportAttachmentFilename = this.importResult.getReportAttachmentFilename();
            String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n.t((String)"tutti.editSpeciesBatch.action.importPupitri.showReport.message", (Object[])new Object[]{reportAttachmentFilename}), "");
            Component ui = this.getDialogParentComponent();
            boolean bl = showReport = JOptionPane.showOptionDialog(ui, htmlMessage, I18n.t((String)"tutti.editSpeciesBatch.action.importPupitri.showReport.title", (Object[])new Object[0]), 2, 3, null, new Object[]{I18n.t((String)"tutti.editSpeciesBatch.action.showReport", (Object[])new Object[0]), I18n.t((String)"tutti.editSpeciesBatch.action.doNotShowReport", (Object[])new Object[0])}, I18n.t((String)"tutti.editSpeciesBatch.action.showReport", (Object[])new Object[0])) == 0;
            if (showReport) {
                String reportAttachmentId = this.importResult.getReportAttachmentId();
                File attachmentFile = this.persistenceService.getAttachmentFile(reportAttachmentId);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Open pupitri report at " + attachmentFile));
                }
                TuttiUIUtil.browseFile(attachmentFile);
            }
        } else {
            this.displayWarningMessage(I18n.t((String)"tutti.editSpeciesBatch.action.importPupitri.no.matching.fishingOperation.title", (Object[])new Object[0]), "<html><body>" + I18n.t((String)"tutti.editSpeciesBatch.action.importPupitri.no.matching.fishingOperation", (Object[])new Object[0]) + "</body></html>");
            this.sendMessage(I18n.t((String)"tutti.editSpeciesBatch.action.importPupitri.no.matching.data", (Object[])new Object[0]));
        }
    }
}

