/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.FrequencyConfigurationMode;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyCellComponent;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyLogCellComponent;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyLogsTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.BenthosFrequencyUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.frequency.actions.ApplyBenthosFrequencyRafaleAction;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.TuttiNumberTickUnitSource;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberTickUnitSource;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.data.xy.IntervalXYDataset;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class BenthosFrequencyUIHandler
extends AbstractTuttiTableUIHandler<BenthosFrequencyRowModel, BenthosFrequencyUIModel, BenthosFrequencyUI> {
    private static final Log log = LogFactory.getLog(BenthosFrequencyUIHandler.class);
    private BenthosFrequencyCellComponent.FrequencyCellEditor frequencyEditor;
    private Map<Integer, SpeciesProtocol> speciesProtocol;
    private Map<String, Caracteristic> lengthStepCaracteristics;
    private JFreeChart chart;
    protected WeightUnit weightUnit;
    protected ApplyBenthosFrequencyRafaleAction applyBenthosFrequencyRafaleAction;

    public BenthosFrequencyUIHandler() {
        super("lengthStep", "number", "weight");
    }

    public BenthosFrequencyTableModel getTableModel() {
        return (BenthosFrequencyTableModel)((Object)this.getTable().getModel());
    }

    @Override
    public JXTable getTable() {
        return ((BenthosFrequencyUI)this.ui).getTable();
    }

    @Override
    public boolean isRowValid(BenthosFrequencyRowModel row) {
        BenthosFrequencyUIModel model = (BenthosFrequencyUIModel)this.getModel();
        boolean valid = model.isRowValid(row);
        return valid;
    }

    @Override
    protected void onModelRowsChanged(List<BenthosFrequencyRowModel> rows) {
        BenthosFrequencyUIModel model = (BenthosFrequencyUIModel)this.getModel();
        model.reloadRows();
        this.getTableModel().setRows(rows);
        BenthosFrequencyLogsTableModel logsTableModel = (BenthosFrequencyLogsTableModel)((Object)((BenthosFrequencyUI)this.ui).getLogsTable().getModel());
        logsTableModel.setRows(Lists.newArrayList());
    }

    @Override
    protected void onRowModified(int rowIndex, BenthosFrequencyRowModel row, String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<BenthosFrequencyRowModel> rowMonitor, BenthosFrequencyRowModel row) {
    }

    @Override
    protected void onRowValidStateChanged(int rowIndex, BenthosFrequencyRowModel row, Boolean oldValue, Boolean newValue) {
        super.onRowValidStateChanged(rowIndex, row, oldValue, newValue);
        ((BenthosFrequencyUI)this.ui).getValidator().doValidate();
    }

    public SwingValidator<BenthosFrequencyUIModel> getValidator() {
        return ((BenthosFrequencyUI)this.ui).getValidator();
    }

    public void beforeInit(BenthosFrequencyUI ui) {
        this.applyBenthosFrequencyRafaleAction = new ApplyBenthosFrequencyRafaleAction(ui);
        super.beforeInit((ApplicationUI)ui);
        this.weightUnit = this.getConfig().getBenthosWeightUnit();
        SampleCategoryModel sampleCategoryModel = this.getDataContext().getSampleCategoryModel();
        BenthosFrequencyUIModel model = new BenthosFrequencyUIModel(this.weightUnit, sampleCategoryModel);
        ((BenthosFrequencyUI)this.ui).setContextValue(model);
    }

    public void afterInit(BenthosFrequencyUI ui) {
        this.initUI(ui);
        ArrayList lengthStepCaracterics = Lists.newArrayList((Iterable)this.getDataContext().getLengthStepCaracteristics());
        this.lengthStepCaracteristics = TuttiEntities.splitById(lengthStepCaracterics);
        BenthosFrequencyUIModel model = (BenthosFrequencyUIModel)this.getModel();
        this.speciesProtocol = this.getContext().isProtocolFilled() ? this.getPersistenceService().toBenthosProtocolMap() : Maps.newHashMap();
        Caracteristic modelCaracteristic = model.getLengthStepCaracteristic();
        this.initBeanFilterableComboBox(ui.getLengthStepCaracteristicComboBox(), lengthStepCaracterics, modelCaracteristic);
        float step = this.getStep(modelCaracteristic);
        model.setStep(Float.valueOf(step));
        model.setMinStep(null);
        model.setMaxStep(null);
        ui.getRafaleStepField().getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    Float step = (Float)((BenthosFrequencyUI)BenthosFrequencyUIHandler.this.ui).getRafaleStepField().getModel().getNumberValue();
                    BenthosFrequencyUIHandler.this.applyBenthosFrequencyRafaleAction.applyRafaleStep(step, false);
                    JTextField field = (JTextField)e.getSource();
                    field.selectAll();
                }
            }
        });
        model.addPropertyChangeListener("lengthStepCaracteristic", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Caracteristic newValue = (Caracteristic)evt.getNewValue();
                float step = BenthosFrequencyUIHandler.this.getStep(newValue);
                ((BenthosFrequencyUIModel)BenthosFrequencyUIHandler.this.getModel()).setStep(Float.valueOf(step));
                ((BenthosFrequencyUIModel)BenthosFrequencyUIHandler.this.getModel()).setDataSetIntervalWidth(step);
                BenthosFrequencyUIHandler.this.chart.getXYPlot().getDomainAxis().setStandardTickUnits((TickUnitSource)new TuttiNumberTickUnitSource(step == 1.0f));
                if (CollectionUtils.isNotEmpty(((BenthosFrequencyUIModel)BenthosFrequencyUIHandler.this.getModel()).getRows())) {
                    for (BenthosFrequencyRowModel rowModel : ((BenthosFrequencyUIModel)BenthosFrequencyUIHandler.this.getModel()).getRows()) {
                        rowModel.setLengthStepCaracteristic(newValue);
                        BenthosFrequencyUIHandler.this.recomputeRowValidState(rowModel);
                    }
                }
                ((BenthosFrequencyUI)BenthosFrequencyUIHandler.this.ui).getValidator().doValidate();
            }
        });
        model.addPropertyChangeListener("lengthStepCaracteristicUnit", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String unit = (String)evt.getNewValue();
                if (unit == null) {
                    unit = I18n.t((String)"tutti.editBenthosFrequencies.unkownStepUnit", (Object[])new Object[0]);
                }
                ((BenthosFrequencyUI)BenthosFrequencyUIHandler.this.getUI()).getMinStepLabel().setText(BenthosFrequencyUIHandler.this.getLabelWithUnit(I18n.t((String)"tutti.editBenthosFrequencies.field.minStep", (Object[])new Object[0]), unit));
                ((BenthosFrequencyUI)BenthosFrequencyUIHandler.this.getUI()).getMinStepLabel().setToolTipText(BenthosFrequencyUIHandler.this.getLabelWithUnit(I18n.t((String)"tutti.editBenthosFrequencies.field.minStep.tip", (Object[])new Object[0]), unit));
                ((BenthosFrequencyUI)BenthosFrequencyUIHandler.this.getUI()).getMaxStepLabel().setText(BenthosFrequencyUIHandler.this.getLabelWithUnit(I18n.t((String)"tutti.editBenthosFrequencies.field.maxStep", (Object[])new Object[0]), unit));
                ((BenthosFrequencyUI)BenthosFrequencyUIHandler.this.getUI()).getMaxStepLabel().setToolTipText(BenthosFrequencyUIHandler.this.getLabelWithUnit(I18n.t((String)"tutti.editBenthosFrequencies.field.maxStep.tip", (Object[])new Object[0]), unit));
                ((BenthosFrequencyUI)BenthosFrequencyUIHandler.this.getUI()).getRafaleStepLabel().setText(BenthosFrequencyUIHandler.this.getLabelWithUnit(I18n.t((String)"tutti.editBenthosFrequencies.field.rafaleStep", (Object[])new Object[0]), unit));
                ((BenthosFrequencyUI)BenthosFrequencyUIHandler.this.getUI()).getRafaleStepLabel().setToolTipText(BenthosFrequencyUIHandler.this.getLabelWithUnit(I18n.t((String)"tutti.editBenthosFrequencies.field.rafaleStep.tip", (Object[])new Object[0]), unit));
                TableColumnExt column = (TableColumnExt)((BenthosFrequencyUI)BenthosFrequencyUIHandler.this.getUI()).getTable().getColumn(BenthosFrequencyTableModel.LENGTH_STEP);
                column.setHeaderValue((Object)BenthosFrequencyUIHandler.this.getLabelWithUnit(I18n.t((String)"tutti.editSpeciesFrequencies.table.header.lengthStep", (Object[])new Object[0]), unit));
                column.setToolTipText(BenthosFrequencyUIHandler.this.getLabelWithUnit(I18n.t((String)"tutti.editSpeciesFrequencies.table.header.lengthStep", (Object[])new Object[0]), unit));
            }
        });
        model.addPropertyChangeListener("configurationMode", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                final FrequencyConfigurationMode newValue = (FrequencyConfigurationMode)((Object)evt.getNewValue());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JComponent componentToFocus = BenthosFrequencyUIHandler.this.getComponentToFocus(newValue);
                        if (componentToFocus != null) {
                            componentToFocus.grabFocus();
                        }
                        BenthosFrequencyUIHandler.this.updateLogVisibility();
                    }
                });
            }
        });
        this.chart = ChartFactory.createXYBarChart(null, (String)I18n.t((String)"tutti.editSpeciesFrequencies.table.header.lengthStep", (Object[])new Object[0]), (boolean)false, (String)I18n.t((String)"tutti.editSpeciesFrequencies.table.header.number", (Object[])new Object[0]), (IntervalXYDataset)model.dataset);
        this.chart.clearSubtitles();
        ValueAxis rangeAxis = this.chart.getXYPlot().getRangeAxis();
        rangeAxis.setAutoRange(true);
        rangeAxis.setStandardTickUnits((TickUnitSource)new NumberTickUnitSource(true));
        ValueAxis domainAxis = this.chart.getXYPlot().getDomainAxis();
        domainAxis.setAutoRange(true);
        domainAxis.setStandardTickUnits((TickUnitSource)new TuttiNumberTickUnitSource(true));
        domainAxis.setMinorTickMarksVisible(true);
        this.chart.getXYPlot().getRenderer().setSeriesPaint(0, (Paint)this.getConfig().getColorComputedWeights());
        ChartPanel chartPanel = new ChartPanel(this.chart);
        chartPanel.setDomainZoomable(false);
        chartPanel.setMouseZoomable(false);
        chartPanel.setPopupMenu(null);
        JPanel histogramPanel = ui.getHistogramPanel();
        histogramPanel.add((Component)chartPanel, "Center");
        JXTable table = this.getTable();
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        this.addFloatColumnToModel((TableColumnModel)columnModel, BenthosFrequencyTableModel.LENGTH_STEP, "\\d{0,6}(\\.\\d{0,1})?", (JTable)table);
        this.addIntegerColumnToModel((TableColumnModel)columnModel, BenthosFrequencyTableModel.NUMBER, "\\d{0,6}", (JTable)table);
        this.addFloatColumnToModel((TableColumnModel)columnModel, BenthosFrequencyTableModel.WEIGHT, this.weightUnit, (JTable)table);
        BenthosFrequencyTableModel tableModel = new BenthosFrequencyTableModel(this.weightUnit, (TableColumnModelExt)columnModel, model);
        table.setModel((TableModel)((Object)tableModel));
        table.setColumnModel((TableColumnModel)columnModel);
        this.initTable(table);
        this.installTableKeyListener((TableColumnModel)columnModel, (JTable)table);
        JXTable logTable = ui.getLogsTable();
        DefaultTableColumnModelExt logColumnModel = new DefaultTableColumnModelExt();
        this.addColumnToModel((TableColumnModel)logColumnModel, BenthosFrequencyLogCellComponent.newEditor(ui), BenthosFrequencyLogCellComponent.newRender(), BenthosFrequencyLogsTableModel.LABEL);
        BenthosFrequencyLogsTableModel logTableModel = new BenthosFrequencyLogsTableModel((TableColumnModelExt)logColumnModel);
        logTableModel.setRows(new ArrayList());
        logTable.setModel((TableModel)((Object)logTableModel));
        logTable.setColumnModel((TableColumnModel)logColumnModel);
        logTable.getTableHeader().setReorderingAllowed(false);
        Highlighter evenHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)HighlightPredicate.ODD, (Color)this.getConfig().getColorAlternateRow());
        logTable.addHighlighter(evenHighlighter);
        this.listenValidatorValid((SimpleBeanValidator)ui.getValidator(), model);
    }

    protected JComponent getComponentToFocus() {
        FrequencyConfigurationMode configurationMode = ((BenthosFrequencyUIModel)this.getModel()).getConfigurationMode();
        BeanFilterableComboBox<Caracteristic> componentToFocus = this.getComponentToFocus(configurationMode);
        if (componentToFocus == null) {
            componentToFocus = ((BenthosFrequencyUI)this.getUI()).getLengthStepCaracteristicComboBox();
        }
        return componentToFocus;
    }

    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        this.frequencyEditor = null;
        ((BenthosFrequencyUI)this.ui).getValidator().setBean(null);
        ((BenthosFrequencyUIModel)this.getModel()).setValid(false);
        ((BenthosFrequencyUIModel)this.getModel()).setSimpleCount(null);
        EditCatchesUI parent = (EditCatchesUI)this.getParentContainer(EditCatchesUI.class);
        parent.getHandler().setBenthosSelectedCard("main");
    }

    public void editBatch(BenthosFrequencyCellComponent.FrequencyCellEditor editor) {
        Integer number;
        Integer taxonId;
        SpeciesProtocol speciesProtocol;
        BenthosBatchRowModel speciesBatch = editor.getEditRow();
        BenthosFrequencyUIModel model = (BenthosFrequencyUIModel)this.getModel();
        model.setNextEditableRowIndex(editor.getNextEditableRowIndex());
        model.setTotalNumber(null);
        model.setTotalComputedWeight(null);
        model.setTotalWeight(null);
        model.setSimpleCount(null);
        model.setMinStep(null);
        model.setMaxStep(null);
        this.frequencyEditor = editor;
        Caracteristic lengthStepCaracteristic = null;
        ArrayList rows = Lists.newArrayList();
        if (speciesBatch != null) {
            Species species;
            SpeciesProtocol sProtocol;
            List<BenthosFrequencyRowModel> previousFrequency;
            Float lengthStep;
            model.setTotalWeight(speciesBatch.getWeight());
            List<BenthosFrequencyRowModel> frequency = speciesBatch.getFrequency();
            if (CollectionUtils.isNotEmpty(frequency)) {
                BenthosFrequencyTableModel tableModel = this.getTableModel();
                for (BenthosFrequencyRowModel rowModel : frequency) {
                    BenthosFrequencyRowModel newRow = tableModel.createNewRow(false);
                    newRow.setLengthStepCaracteristic(rowModel.getLengthStepCaracteristic());
                    newRow.setLengthStep(rowModel.getLengthStep());
                    newRow.setNumber(rowModel.getNumber());
                    newRow.setWeight(rowModel.getWeight());
                    rows.add(newRow);
                }
                BenthosFrequencyRowModel rowModel = frequency.get(0);
                lengthStepCaracteristic = rowModel.getLengthStepCaracteristic();
                lengthStep = rowModel.getLengthStep();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Use existing lengthStep caracteristic / step " + this.decorate(lengthStepCaracteristic) + " / " + lengthStep));
                }
            }
            BenthosBatchRowModel previousSiblingRow = this.frequencyEditor.getPreviousSiblingRow();
            if (lengthStepCaracteristic == null && previousSiblingRow != null && CollectionUtils.isNotEmpty(previousFrequency = previousSiblingRow.getFrequency())) {
                BenthosFrequencyRowModel rowModel;
                rowModel = previousFrequency.get(0);
                lengthStepCaracteristic = rowModel.getLengthStepCaracteristic();
                lengthStep = rowModel.getLengthStep();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Use previous sibling existing lengthStep caracteristic / step " + this.decorate(lengthStepCaracteristic) + " / " + lengthStep));
                }
            }
            if (lengthStepCaracteristic == null && (sProtocol = this.speciesProtocol.get((species = speciesBatch.getSpecies()).getReferenceTaxonId())) != null) {
                String lengthStepPmfmId = sProtocol.getLengthStepPmfmId();
                lengthStepCaracteristic = this.lengthStepCaracteristics.get(lengthStepPmfmId);
                lengthStep = sProtocol.getLengthStep();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Use existing from protocol lengthStep caracteristic / step " + this.decorate(lengthStepCaracteristic) + " / " + lengthStep));
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will edit batch row: " + speciesBatch + " with " + rows.size() + " frequency"));
        }
        FrequencyConfigurationMode mode = FrequencyConfigurationMode.AUTO_GEN;
        if (lengthStepCaracteristic == null && ((speciesProtocol = this.speciesProtocol.get(taxonId = speciesBatch.getSpecies().getReferenceTaxonId())) == null || speciesProtocol.getLengthStepPmfmId() == null)) {
            mode = FrequencyConfigurationMode.SIMPLE_COUNTING;
        }
        if ((number = speciesBatch.getNumber()) != null && rows.isEmpty()) {
            mode = FrequencyConfigurationMode.SIMPLE_COUNTING;
            model.setSimpleCount(number);
        }
        model.setConfigurationMode(null);
        model.setConfigurationMode(mode);
        ((BenthosFrequencyUI)this.ui).getValidator().setBean((Object)model);
        Collections.sort(rows);
        model.setLengthStepCaracteristic(lengthStepCaracteristic);
        model.setRows(rows);
        model.setBatch(speciesBatch);
    }

    protected JComponent getComponentToFocus(FrequencyConfigurationMode mode) {
        BeanFilterableComboBox<Caracteristic> componentToFocus = null;
        if (mode != null) {
            boolean withLengthStepCaracteristic = ((BenthosFrequencyUIModel)this.getModel()).getLengthStepCaracteristic() != null;
            switch (mode) {
                case AUTO_GEN: {
                    if (withLengthStepCaracteristic) {
                        componentToFocus = ((BenthosFrequencyUI)this.ui).getMinStepField();
                        break;
                    }
                    componentToFocus = ((BenthosFrequencyUI)this.ui).getLengthStepCaracteristicComboBox();
                    break;
                }
                case RAFALE: {
                    if (withLengthStepCaracteristic) {
                        componentToFocus = ((BenthosFrequencyUI)this.ui).getRafaleStepField();
                        break;
                    }
                    componentToFocus = ((BenthosFrequencyUI)this.ui).getLengthStepCaracteristicComboBox();
                    break;
                }
                case SIMPLE_COUNTING: {
                    componentToFocus = ((BenthosFrequencyUI)this.ui).getSimpleCountingField();
                    break;
                }
                default: {
                    componentToFocus = null;
                }
            }
        }
        return componentToFocus;
    }

    protected float getStep(Caracteristic caracteristic) {
        Float precision = null;
        if (caracteristic != null) {
            precision = caracteristic.getPrecision();
        }
        if (precision == null) {
            precision = Float.valueOf(1.0f);
        }
        return precision.floatValue();
    }

    protected void updateLogVisibility() {
        boolean logVisible = ((BenthosFrequencyUIModel)this.getModel()).isRafaleMode();
        BenthosFrequencyUI ui = (BenthosFrequencyUI)this.getUI();
        JSplitPane firstSplitPane = ui.getFirstSplitPane();
        JSplitPane secondSplitPane = ui.getSecondSplitPane();
        int lastDividerLocation = secondSplitPane.getLastDividerLocation();
        if (lastDividerLocation == 0) {
            lastDividerLocation = 200;
        }
        secondSplitPane.setDividerLocation(logVisible ? lastDividerLocation : 0);
        secondSplitPane.setDividerSize(logVisible ? firstSplitPane.getDividerSize() : 0);
        ui.getLogsScrollPane().setVisible(logVisible);
    }

    protected String getLabelWithUnit(String label, String unit) {
        return label + " (" + unit + ")";
    }

    public <E> void initBeanFilterableComboBox(BeanFilterableComboBox<E> comboBox, List<E> data, E selectedData) {
        super.initBeanFilterableComboBox(comboBox, data, selectedData);
    }

    public BenthosFrequencyCellComponent.FrequencyCellEditor getFrequencyEditor() {
        return this.frequencyEditor;
    }
}

