/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.de;

import org.eclipse.birt.report.item.crosstab.core.ICrosstabConstants;
import org.eclipse.birt.report.item.crosstab.core.IDimensionViewConstants;
import org.eclipse.birt.report.item.crosstab.core.de.AbstractCrosstabItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.internal.DimensionViewTask;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;

public class DimensionViewHandle
extends AbstractCrosstabItemHandle
implements IDimensionViewConstants,
ICrosstabConstants {
    DimensionViewHandle(DesignElementHandle handle) {
        super(handle);
    }

    public PropertyHandle getLevelsProperty() {
        return this.handle.getPropertyHandle("levels");
    }

    public DimensionHandle getCubeDimension() {
        DimensionHandle cubeDimension = (DimensionHandle)this.handle.getElementProperty("dimension");
        if (cubeDimension == null) {
            CubeHandle cube;
            String dimensionName = this.getCubeDimensionName();
            CrosstabReportItemHandle crosstab = this.getCrosstab();
            CubeHandle cubeHandle = cube = crosstab != null ? crosstab.getCube() : null;
            if (dimensionName != null && cube != null) {
                cubeDimension = cube.getDimension(dimensionName);
            }
        }
        return cubeDimension;
    }

    public String getCubeDimensionName() {
        return this.handle.getStringProperty("dimension");
    }

    public int getLevelCount() {
        return this.getLevelsProperty().getContentCount();
    }

    public LevelViewHandle getLevel(String name) {
        int i = 0;
        while (i < this.getLevelCount()) {
            String cubeLevelName;
            LevelViewHandle levelView = this.getLevel(i);
            if (levelView != null && ((cubeLevelName = levelView.getCubeLevelName()) != null && cubeLevelName.equals(name) || cubeLevelName == null && name == null)) {
                return levelView;
            }
            ++i;
        }
        return null;
    }

    public LevelViewHandle findLevel(String name) {
        int i = 0;
        while (i < this.getLevelCount()) {
            String cubeLevelName;
            LevelHandle handle;
            LevelViewHandle levelView = this.getLevel(i);
            if (levelView != null && (handle = levelView.getCubeLevel()) != null && ((cubeLevelName = handle.getName()) != null && cubeLevelName.equals(name) || cubeLevelName == null && name == null)) {
                return levelView;
            }
            ++i;
        }
        return null;
    }

    public LevelViewHandle getLevel(int index) {
        DesignElementHandle element = this.getLevelsProperty().getContent(index);
        return (LevelViewHandle)CrosstabUtil.getReportItem(element, "LevelView");
    }

    public LevelViewHandle insertLevel(LevelHandle levelHandle, int index) throws SemanticException {
        return new DimensionViewTask(this).insertLevel(levelHandle, index);
    }

    public void removeLevel(String name) throws SemanticException {
        new DimensionViewTask(this).removeLevel(name);
    }

    public void removeLevel(int index) throws SemanticException {
        new DimensionViewTask(this).removeLevel(index);
    }

    public int getIndex() {
        return this.handle.getIndex();
    }

    public int getAxisType() {
        CrosstabViewHandle crosstabView = (CrosstabViewHandle)CrosstabUtil.getReportItem(this.handle.getContainer(), "CrosstabView");
        return crosstabView == null ? -1 : crosstabView.getAxisType();
    }
}

