/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.adagio.synchro.intercept.SynchroWriteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.MapUtils;

public class SynchroTableOperationBuffer
implements SynchroWriteBuffer {
    private Map<String, Map<String, Object>> missingUpdates = Maps.newHashMap();
    private Map<String, Map<String, List<Object>>> childTablesToUpdate = Maps.newHashMap();
    private Map<String, Map<Set<String>, List<List<Object>>>> childTablesToUpdateComplexMap = Maps.newHashMap();
    private final String tableName;

    public SynchroTableOperationBuffer(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Map<String, Map<String, Object>> getMissingUpdates() {
        return this.missingUpdates;
    }

    @Override
    public void addMissingColumnUpdate(String columnName, String pkStr, Object columnValue) {
        HashMap destRows = this.missingUpdates.get(columnName);
        if (destRows == null) {
            destRows = Maps.newHashMap();
            this.missingUpdates.put(columnName, destRows);
        }
        destRows.put(pkStr, columnValue);
    }

    @Override
    public void addChildToUpdate(String childTablename, Set<String> columnNames, List<Object> columnValues) {
        List childColumnValues;
        HashMap childTable = this.childTablesToUpdateComplexMap.get(childTablename);
        if (childTable == null) {
            childTable = Maps.newHashMap();
            this.childTablesToUpdateComplexMap.put(childTablename, childTable);
        }
        if ((childColumnValues = (List)childTable.get(columnNames)) == null) {
            childColumnValues = Lists.newArrayList();
            childTable.put(columnNames, childColumnValues);
        }
        childColumnValues.add(columnValues);
    }

    public Map<String, Map<Set<String>, List<List<Object>>>> getChildToUpdateComplexMap() {
        return this.childTablesToUpdateComplexMap;
    }

    @Override
    public void addChildToUpdate(String childTablename, String columnName, Object columnValue) {
        List childColumnValues;
        HashMap childTable = this.childTablesToUpdate.get(childTablename);
        if (childTable == null) {
            childTable = Maps.newHashMap();
            this.childTablesToUpdate.put(childTablename, childTable);
        }
        if ((childColumnValues = (List)childTable.get(columnName)) == null) {
            childColumnValues = Lists.newArrayList();
            childTable.put(columnName, childColumnValues);
        }
        childColumnValues.add(columnValue);
    }

    @Override
    public void addChildsToUpdate(String childTablename, String columnName, List<Object> columnValues) {
        List childColumnValues;
        HashMap childTable = this.childTablesToUpdate.get(childTablename);
        if (childTable == null) {
            childTable = Maps.newHashMap();
            this.childTablesToUpdate.put(childTablename, childTable);
        }
        if ((childColumnValues = (List)childTable.get(columnName)) == null) {
            childColumnValues = Lists.newArrayList();
            childTable.put(columnName, columnValues);
        }
        childColumnValues.addAll(columnValues);
    }

    public Map<String, Map<String, List<Object>>> getChildToUpdate() {
        return this.childTablesToUpdate;
    }

    public boolean isEmpty() {
        return MapUtils.isEmpty(this.missingUpdates) && MapUtils.isEmpty(this.childTablesToUpdate) && MapUtils.isEmpty(this.childTablesToUpdateComplexMap);
    }
}

