/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.ifremer.shared.application.ApplicationBusinessException;
import fr.ifremer.shared.application.swing.ApplicationUI;
import fr.ifremer.shared.application.swing.util.Cancelable;
import fr.ifremer.shared.application.type.WeightUnit;
import fr.ifremer.tutti.ichtyometer.feed.FeedReaderEvent;
import fr.ifremer.tutti.ichtyometer.feed.FeedReaderListener;
import fr.ifremer.tutti.ichtyometer.feed.FeedReaderRecord;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.FrequencyConfigurationMode;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyCellComponent;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIHandler;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.i18n.I18n;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class SpeciesFrequencyUIHandler
extends AbstractTuttiTableUIHandler<SpeciesFrequencyRowModel, SpeciesFrequencyUIModel, SpeciesFrequencyUI>
implements Cancelable {
    private static final Log log = LogFactory.getLog(SpeciesFrequencyUIHandler.class);
    private SpeciesFrequencyCellComponent.FrequencyCellEditor frequencyEditor;
    private Map<Integer, SpeciesProtocol> speciesProtocol;
    private Map<String, Caracteristic> lengthStepCaracteristics;
    protected WeightUnit weightUnit;
    protected final FeedReaderListener feedReaderListener = new FeedReaderListener(){

        public void recordRead(FeedReaderEvent event) {
            final FeedReaderRecord record = event.getRecord();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!((SpeciesFrequencyUIModel)SpeciesFrequencyUIHandler.this.getModel()).isSimpleCountingMode()) {
                        SpeciesFrequencyUIHandler.this.consumeFeedRecord(record);
                    }
                }
            });
        }
    };

    public SpeciesFrequencyUIHandler() {
        super("lengthStep", "number", "weight");
    }

    public SpeciesFrequencyTableModel getTableModel() {
        return (SpeciesFrequencyTableModel)((Object)this.getTable().getModel());
    }

    @Override
    public JXTable getTable() {
        return ((SpeciesFrequencyUI)this.ui).getTable();
    }

    @Override
    protected boolean isRowValid(SpeciesFrequencyRowModel row) {
        return row.getLengthStepCaracteristic() != null && row.getLengthStep() != null && row.getLengthStep().floatValue() > 0.0f && (row.getNumber() == null && row.getWeight() == null || row.getNumber() != null && row.getNumber() > 0 && (((SpeciesFrequencyUIModel)this.getModel()).getNbRowsWithWeight() == 0 || row.getWeight() != null && row.getWeight().floatValue() > 0.0f));
    }

    @Override
    protected void onModelRowsChanged(List<SpeciesFrequencyRowModel> rows) {
        super.onModelRowsChanged(rows);
        SpeciesFrequencyUIModel model = (SpeciesFrequencyUIModel)this.getModel();
        model.setEmptyRows(Sets.newHashSet());
        if (CollectionUtils.isNotEmpty(rows)) {
            for (SpeciesFrequencyRowModel row : rows) {
                model.updateRowWithWeight(row);
            }
            for (SpeciesFrequencyRowModel row : rows) {
                this.recomputeRowValidState(row);
            }
        }
        model.recomputeTotalNumberAndWeight();
    }

    @Override
    protected void onRowModified(int rowIndex, SpeciesFrequencyRowModel row, String propertyName, Object oldValue, Object newValue) {
        boolean recomputeAllRows;
        SpeciesFrequencyUIModel model = (SpeciesFrequencyUIModel)this.getModel();
        int nbRowsWithWeight = model.getNbRowsWithWeight();
        model.updateRowWithWeight(row);
        boolean bl = recomputeAllRows = nbRowsWithWeight != model.getNbRowsWithWeight();
        if (recomputeAllRows) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Revalidate all rows");
            }
            for (SpeciesFrequencyRowModel r : model.getRows()) {
                this.recomputeRowValidState(r);
            }
        }
        this.recomputeTotalNumberAndWeight();
        if (!recomputeAllRows) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Revalidate the single selected row");
            }
            this.recomputeRowValidState(row);
        }
        model.updateEmptyRow(row);
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<SpeciesFrequencyRowModel> rowMonitor, SpeciesFrequencyRowModel row) {
    }

    @Override
    protected void onRowValidStateChanged(int rowIndex, SpeciesFrequencyRowModel row, Boolean oldValue, Boolean newValue) {
        super.onRowValidStateChanged(rowIndex, row, oldValue, newValue);
        ((SpeciesFrequencyUI)this.ui).getValidator().doValidate();
    }

    public SwingValidator<SpeciesFrequencyUIModel> getValidator() {
        return ((SpeciesFrequencyUI)this.ui).getValidator();
    }

    public void beforeInit(SpeciesFrequencyUI ui) {
        super.beforeInit((ApplicationUI)ui);
        this.weightUnit = this.getConfig().getSpeciesWeightUnit();
        SampleCategoryModel sampleCategoryModel = this.getDataContext().getSampleCategoryModel();
        SpeciesFrequencyUIModel model = new SpeciesFrequencyUIModel(this.weightUnit, sampleCategoryModel);
        ((SpeciesFrequencyUI)this.ui).setContextValue(model);
        this.getContext().addPropertyChangeListener("ichtyometerConnected", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean connected = (Boolean)evt.getNewValue();
                if (connected && SpeciesFrequencyUIHandler.this.frequencyEditor != null) {
                    SpeciesFrequencyUIHandler.this.listenItchtyometer();
                }
            }
        });
    }

    public void afterInit(SpeciesFrequencyUI ui) {
        this.initUI(this.ui);
        ArrayList lengthStepCaracterics = Lists.newArrayList((Iterable)this.getDataContext().getLengthStepCaracteristics());
        this.lengthStepCaracteristics = TuttiEntities.splitById(lengthStepCaracterics);
        SpeciesFrequencyUIModel model = (SpeciesFrequencyUIModel)this.getModel();
        this.speciesProtocol = this.getContext().isProtocolFilled() ? this.getPersistenceService().toSpeciesProtocolMap() : Maps.newHashMap();
        Caracteristic modelCaracteristic = model.getLengthStepCaracteristic();
        this.initBeanFilterableComboBox(((SpeciesFrequencyUI)this.ui).getLengthStepCaracteristicComboBox(), lengthStepCaracterics, modelCaracteristic);
        Float precision = null;
        if (modelCaracteristic != null) {
            precision = model.getLengthStepCaracteristic().getPrecision();
        }
        if (precision == null) {
            precision = Float.valueOf(1.0f);
        }
        model.setStep(precision.floatValue());
        model.setMinStep(null);
        model.setMaxStep(null);
        ((SpeciesFrequencyUI)this.ui).getRafaleStepField().getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    Float step = (Float)((SpeciesFrequencyUI)SpeciesFrequencyUIHandler.this.ui).getRafaleStepField().getModel();
                    SpeciesFrequencyUIHandler.this.applyRafaleStep(step, false);
                    JTextField field = (JTextField)e.getSource();
                    field.selectAll();
                }
            }
        });
        model.addPropertyChangeListener("lengthStepCaracteristic", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Caracteristic newValue = (Caracteristic)evt.getNewValue();
                if (((SpeciesFrequencyUIModel)SpeciesFrequencyUIHandler.this.getModel()).getRows() != null) {
                    for (SpeciesFrequencyRowModel rowModel : ((SpeciesFrequencyUIModel)SpeciesFrequencyUIHandler.this.getModel()).getRows()) {
                        rowModel.setLengthStepCaracteristic(newValue);
                        Float precision = null;
                        if (newValue != null) {
                            precision = newValue.getPrecision();
                        }
                        if (precision == null) {
                            precision = Float.valueOf(0.5f);
                        }
                        ((SpeciesFrequencyUIModel)SpeciesFrequencyUIHandler.this.getModel()).setStep(precision.floatValue());
                        SpeciesFrequencyUIHandler.this.recomputeRowValidState(rowModel);
                    }
                }
                ((SpeciesFrequencyUI)SpeciesFrequencyUIHandler.this.ui).getValidator().doValidate();
            }
        });
        model.addPropertyChangeListener("configurationMode", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                final FrequencyConfigurationMode newValue = (FrequencyConfigurationMode)((Object)evt.getNewValue());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JComponent componentToFocus = SpeciesFrequencyUIHandler.this.getComponentToFocus(newValue);
                        if (componentToFocus != null) {
                            componentToFocus.grabFocus();
                        }
                    }
                });
            }
        });
        JXTable table = this.getTable();
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        this.addFloatColumnToModel((TableColumnModel)columnModel, SpeciesFrequencyTableModel.LENGTH_STEP, TuttiUI.DECIMAL1_PATTERN, (JTable)table);
        this.addIntegerColumnToModel((TableColumnModel)columnModel, SpeciesFrequencyTableModel.NUMBER, "\\d{0,6}", (JTable)table);
        this.addFloatColumnToModel((TableColumnModel)columnModel, SpeciesFrequencyTableModel.WEIGHT, this.weightUnit, (JTable)table);
        SpeciesFrequencyTableModel tableModel = new SpeciesFrequencyTableModel(this.weightUnit, (TableColumnModelExt)columnModel, model);
        table.setModel((TableModel)((Object)tableModel));
        table.setColumnModel((TableColumnModel)columnModel);
        this.initTable(table);
        this.installTableKeyListener((TableColumnModel)columnModel, (JTable)table);
        this.listenValidatorValid((SimpleBeanValidator)((SpeciesFrequencyUI)this.ui).getValidator(), model);
    }

    protected JComponent getComponentToFocus() {
        FrequencyConfigurationMode configurationMode = ((SpeciesFrequencyUIModel)this.getModel()).getConfigurationMode();
        BeanFilterableComboBox<Caracteristic> componentToFocus = this.getComponentToFocus(configurationMode);
        if (componentToFocus == null) {
            componentToFocus = ((SpeciesFrequencyUI)this.getUI()).getLengthStepCaracteristicComboBox();
        }
        return componentToFocus;
    }

    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        this.frequencyEditor = null;
        ((SpeciesFrequencyUI)this.ui).getValidator().setBean(null);
        ((SpeciesFrequencyUIModel)this.getModel()).setValid(false);
        ((SpeciesFrequencyUIModel)this.getModel()).setSimpleCount(null);
        EditCatchesUI parent = (EditCatchesUI)this.getParentContainer(EditCatchesUI.class);
        parent.getHandler().setSpeciesSelectedCard("main");
        if (this.getContext().isIchtyometerConnected()) {
            this.getContext().getIchtyometerReader().removeFeedModeReaderListener(this.feedReaderListener);
        }
    }

    public void cancel() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cancel UI " + this.ui));
        }
        this.closeUI((TuttiUI)this.ui);
    }

    public void addLengthStepCaracteristic() {
        List allNumericCaracteristic = this.getPersistenceService().getAllNumericCaracteristic();
        ArrayList toSelect = Lists.newArrayList((Iterable)allNumericCaracteristic);
        List knownCaracteristics = ((SpeciesFrequencyUI)this.getUI()).getLengthStepCaracteristicComboBox().getData();
        toSelect.removeAll(knownCaracteristics);
        BeanFilterableComboBox editor = new BeanFilterableComboBox();
        editor.setBeanType(Caracteristic.class);
        editor.setShowReset(Boolean.valueOf(true));
        this.initBeanFilterableComboBox(editor, toSelect, null);
        int response = JOptionPane.showConfirmDialog(this.getTopestUI(), editor, I18n._((String)"tutti.editSpeciesFrequencies.title.addLengthStepCaracteristic", (Object[])new Object[0]), 2);
        Caracteristic selectedItem = response == 0 ? (Caracteristic)editor.getSelectedItem() : null;
        ((SpeciesFrequencyUIModel)this.getModel()).setLengthStepCaracteristic(selectedItem);
    }

    public void generateLengthSteps() {
        SpeciesFrequencyUIModel model = (SpeciesFrequencyUIModel)this.getModel();
        SpeciesFrequencyTableModel tableModel = this.getTableModel();
        Map<Float, SpeciesFrequencyRowModel> rowsByStep = this.getTableModel().getRowCache();
        Float minStep = Float.valueOf(model.getLengthStep(model.getMinStep().floatValue()));
        Float maxStep = Float.valueOf(model.getLengthStep(model.getMaxStep().floatValue()));
        Caracteristic lengthStepCaracteristic = model.getLengthStepCaracteristic();
        HashSet existingKeys = Sets.newHashSet(rowsByStep.keySet());
        ArrayList rows = Lists.newArrayList(rowsByStep.values());
        float i = minStep.floatValue();
        float step = model.getStep();
        while (i <= maxStep.floatValue()) {
            if (!existingKeys.contains(Float.valueOf(i))) {
                SpeciesFrequencyRowModel newRow = tableModel.createNewRow();
                newRow.setLengthStep(Float.valueOf(i));
                newRow.setLengthStepCaracteristic(lengthStepCaracteristic);
                rows.add(newRow);
            }
            i = TuttiEntities.getRoundedLengthStep((float)(i + step), (boolean)true);
        }
        Collections.sort(rows);
        model.setRows(rows);
        TuttiUIUtil.doSelectCell((JTable)((SpeciesFrequencyUI)this.getUI()).getTable(), (int)0, (int)1);
    }

    public void applyRafaleStep(Float step, boolean fromIchtyometer) {
        int rowIndex;
        float aroundLengthStep;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will apply rafale step: " + step));
        }
        SpeciesFrequencyUIModel model = (SpeciesFrequencyUIModel)this.getModel();
        SpeciesFrequencyTableModel tableModel = this.getTableModel();
        Map<Float, SpeciesFrequencyRowModel> rowsByStep = tableModel.getRowCache();
        SpeciesFrequencyRowModel row = rowsByStep.get(Float.valueOf(aroundLengthStep = model.getLengthStep(step.floatValue())));
        if (row != null) {
            Integer number = row.getNumber();
            row.setNumber((number == null ? 0 : number) + 1);
            rowIndex = tableModel.updateRow(row);
        } else {
            row = tableModel.createNewRow();
            row.setLengthStep(Float.valueOf(aroundLengthStep));
            row.setNumber(1);
            row.setValid(this.isRowValid(row));
            ArrayList steps = Lists.newArrayList(rowsByStep.keySet());
            steps.add(Float.valueOf(aroundLengthStep));
            Collections.sort(steps);
            rowIndex = steps.indexOf(Float.valueOf(aroundLengthStep));
            tableModel.addNewRow(rowIndex, row);
        }
        Integer totalNumber = model.getTotalNumber();
        if (totalNumber == null) {
            totalNumber = 0;
        }
        model.setTotalNumber(totalNumber + 1);
        this.getTable().scrollRowToVisible(rowIndex);
        if (fromIchtyometer) {
            this.showInformationMessage(I18n._((String)"tutti.editSpeciesFrequencies.addMeasure", (Object[])new Object[]{step, Float.valueOf(aroundLengthStep)}));
        }
    }

    public void editBatch(SpeciesFrequencyCellComponent.FrequencyCellEditor editor) {
        Integer number;
        Integer taxonId;
        SpeciesProtocol speciesProtocol;
        SpeciesBatchRowModel speciesBatch = editor.getEditRow();
        SpeciesFrequencyUIModel model = (SpeciesFrequencyUIModel)this.getModel();
        model.clearWithWeightRows();
        model.setNextEditableRowIndex(editor.getNextEditableRowIndex());
        model.setTotalNumber(null);
        model.setTotalWeight(null);
        model.setSimpleCount(null);
        model.setMinStep(null);
        model.setMaxStep(null);
        this.frequencyEditor = editor;
        Caracteristic lengthStepCaracteristic = null;
        ArrayList editFrequency = Lists.newArrayList();
        if (speciesBatch != null) {
            Species species;
            SpeciesProtocol sProtocol;
            List<SpeciesFrequencyRowModel> previousFrequency;
            Float lengthStep;
            List<SpeciesFrequencyRowModel> frequency = speciesBatch.getFrequency();
            if (CollectionUtils.isNotEmpty(frequency)) {
                SpeciesFrequencyTableModel tableModel = this.getTableModel();
                for (SpeciesFrequencyRowModel rowModel : frequency) {
                    SpeciesFrequencyRowModel newRow = tableModel.createNewRow();
                    newRow.setLengthStepCaracteristic(rowModel.getLengthStepCaracteristic());
                    newRow.setLengthStep(rowModel.getLengthStep());
                    newRow.setNumber(rowModel.getNumber());
                    newRow.setWeight(rowModel.getWeight());
                    editFrequency.add(newRow);
                }
                SpeciesFrequencyRowModel rowModel = frequency.get(0);
                lengthStepCaracteristic = rowModel.getLengthStepCaracteristic();
                lengthStep = rowModel.getLengthStep();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Use existing lengthStep caracteristic / step " + this.decorate(lengthStepCaracteristic) + " / " + lengthStep));
                }
            }
            SpeciesBatchRowModel previousSiblingRow = this.frequencyEditor.getPreviousSiblingRow();
            if (lengthStepCaracteristic == null && previousSiblingRow != null && CollectionUtils.isNotEmpty(previousFrequency = previousSiblingRow.getFrequency())) {
                SpeciesFrequencyRowModel rowModel;
                rowModel = previousFrequency.get(0);
                lengthStepCaracteristic = rowModel.getLengthStepCaracteristic();
                lengthStep = rowModel.getLengthStep();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Use previous sibling existing lengthStep caracteristic / step " + this.decorate(lengthStepCaracteristic) + " / " + lengthStep));
                }
            }
            if (lengthStepCaracteristic == null && (sProtocol = this.speciesProtocol.get((species = speciesBatch.getSpecies()).getReferenceTaxonId())) != null) {
                String lengthStepPmfmId = sProtocol.getLengthStepPmfmId();
                lengthStepCaracteristic = this.lengthStepCaracteristics.get(lengthStepPmfmId);
                lengthStep = sProtocol.getLengthStep();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Use existing from protocol lengthStep caracteristic / step " + this.decorate(lengthStepCaracteristic) + " / " + lengthStep));
                }
            }
            if (this.getContext().isIchtyometerConnected()) {
                this.listenItchtyometer();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will edit batch row: " + speciesBatch + " with " + editFrequency.size() + " frequency"));
        }
        FrequencyConfigurationMode mode = FrequencyConfigurationMode.AUTO_GEN;
        if (lengthStepCaracteristic == null && ((speciesProtocol = this.speciesProtocol.get(taxonId = speciesBatch.getSpecies().getReferenceTaxonId())) == null || speciesProtocol.getLengthStepPmfmId() == null)) {
            mode = FrequencyConfigurationMode.SIMPLE_COUNTING;
        }
        if ((number = speciesBatch.getNumber()) != null && editFrequency.isEmpty()) {
            mode = FrequencyConfigurationMode.SIMPLE_COUNTING;
            model.setSimpleCount(number);
        }
        model.setConfigurationMode(null);
        model.setConfigurationMode(mode);
        ((SpeciesFrequencyUI)this.ui).getValidator().setBean((Object)model);
        Collections.sort(editFrequency);
        model.setLengthStepCaracteristic(lengthStepCaracteristic);
        model.setRows(editFrequency);
        model.setBatch(speciesBatch);
    }

    public void reset() {
        ((SpeciesFrequencyUIModel)this.getModel()).setRows(Lists.newArrayList());
    }

    public void saveAndClose() {
        boolean doSave;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Save And Close UI " + this.ui));
        }
        if (doSave = this.canSaveFrequencies()) {
            this.frequencyEditor.save((SpeciesFrequencyUIModel)this.getModel(), true);
            this.closeUI((TuttiUI)this.ui);
        }
    }

    public void saveAndContinue() {
        boolean doSave;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Save And Continue UI " + this.ui));
        }
        if (doSave = this.canSaveFrequencies()) {
            this.frequencyEditor.save((SpeciesFrequencyUIModel)this.getModel(), false);
        }
    }

    protected void consumeFeedRecord(FeedReaderRecord record) {
        if (!record.isValid()) {
            throw new ApplicationBusinessException(I18n._((String)"tutti.editSpeciesFrequencies.error.itchyometer.bad.record", (Object[])new Object[]{record.getRecord(), record.getCrc(), record.getComputedCrc()}));
        }
        float length = record.getLength().floatValue() / 10.0f;
        this.applyRafaleStep(Float.valueOf(length), true);
    }

    protected void listenItchtyometer() {
        this.getContext().getIchtyometerReader().removeFeedModeReaderListener(this.feedReaderListener);
        if (log.isInfoEnabled()) {
            log.info((Object)"Start listen ichtyometer");
        }
        this.getContext().getIchtyometerReader().addFeedModeReaderListener(this.feedReaderListener);
    }

    protected void recomputeTotalNumberAndWeight() {
        SpeciesFrequencyUIModel model = (SpeciesFrequencyUIModel)this.getModel();
        List rows = model.getRows();
        Integer totalNumber = 0;
        Float totalWeight = Float.valueOf(0.0f);
        for (SpeciesFrequencyRowModel r : rows) {
            Float weight;
            if (!r.isValid()) continue;
            Integer number = r.getNumber();
            if (number != null) {
                totalNumber = totalNumber + number;
            }
            if ((weight = r.getWeight()) == null) continue;
            totalWeight = Float.valueOf(totalWeight.floatValue() + weight.floatValue());
        }
        model.setTotalNumber(totalNumber);
        model.setTotalWeight(totalWeight);
    }

    protected JComponent getComponentToFocus(FrequencyConfigurationMode mode) {
        BeanFilterableComboBox<Caracteristic> componentToFocus = null;
        if (mode != null) {
            boolean withLengthStepCaracteristic = ((SpeciesFrequencyUIModel)this.getModel()).getLengthStepCaracteristic() != null;
            switch (mode) {
                case AUTO_GEN: {
                    if (withLengthStepCaracteristic) {
                        componentToFocus = ((SpeciesFrequencyUI)this.ui).getMinStepField();
                        break;
                    }
                    componentToFocus = ((SpeciesFrequencyUI)this.ui).getLengthStepCaracteristicComboBox();
                    break;
                }
                case RAFALE: {
                    if (withLengthStepCaracteristic) {
                        componentToFocus = ((SpeciesFrequencyUI)this.ui).getRafaleStepField();
                        break;
                    }
                    componentToFocus = ((SpeciesFrequencyUI)this.ui).getLengthStepCaracteristicComboBox();
                    break;
                }
                case SIMPLE_COUNTING: {
                    componentToFocus = ((SpeciesFrequencyUI)this.ui).getSimpleCountingField();
                    break;
                }
                default: {
                    componentToFocus = null;
                }
            }
        }
        return componentToFocus;
    }

    protected boolean canSaveFrequencies() {
        boolean doSave = true;
        HashSet lengths = Sets.newHashSet();
        Float doublon = null;
        int index = 0;
        List rows = ((SpeciesFrequencyUIModel)this.getModel()).getRows();
        for (SpeciesFrequencyRowModel row : rows) {
            Float lengthStep = row.getLengthStep();
            if (!lengths.add(lengthStep)) {
                doublon = lengthStep;
                break;
            }
            ++index;
        }
        if (doublon != null) {
            String message = I18n._((String)"tutti.editSpeciesFrequencies.error.length.doublon", (Object[])new Object[]{doublon, index + 1});
            this.getContext().getErrorHelper().showErrorDialog(message);
            TuttiUIUtil.selectFirstCellOnRow((JXTable)this.getTable(), (int)index, (boolean)false);
            doSave = false;
        }
        if (doSave && ((SpeciesFrequencyUIModel)this.getModel()).isSomeRowsWithWeightAndOtherWithout()) {
            String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n._((String)"tutti.editSpeciesFrequencies.askBeforeSave.message", (Object[])new Object[0]), I18n._((String)"tutti.editSpeciesFrequencies.askBeforeSave.help", (Object[])new Object[0]));
            int answer = JOptionPane.showConfirmDialog(this.getTopestUI(), htmlMessage, I18n._((String)"tutti.editSpeciesFrequencies.askBeforeSave.title", (Object[])new Object[0]), 0, 3);
            switch (answer) {
                case 0: {
                    break;
                }
                default: {
                    doSave = false;
                }
            }
        }
        return doSave;
    }
}

