/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import fr.ifremer.adagio.core.service.technical.synchro.ReferentialSynchroResult;
import fr.ifremer.shared.application.ApplicationTechnicalException;
import fr.ifremer.shared.application.swing.action.AbstractApplicationAction;
import fr.ifremer.shared.application.swing.action.ApplicationActionException;
import fr.ifremer.shared.application.swing.action.ApplicationActionUI;
import fr.ifremer.shared.application.type.ApplicationProgressionModel;
import fr.ifremer.tutti.TuttiConfiguration;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.referential.TuttiReferentialSynchronizeService;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.auth.AuthenticationInfo;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.updater.ApplicationInfo;
import org.nuiton.updater.ApplicationUpdater;
import org.nuiton.updater.ApplicationUpdaterCallback;

public class TuttiDbUpdaterCallBack
implements ApplicationUpdaterCallback {
    private static final Log log = LogFactory.getLog(TuttiDbUpdaterCallBack.class);
    public static final String DB_UPDATE_NAME = "db";
    protected final TuttiUIContext context;
    protected ProgressionModel progressionModel;
    protected boolean dbInstalled;
    protected boolean dbUpdated;
    protected final AbstractTuttiAction action;

    public TuttiDbUpdaterCallBack(AbstractTuttiAction action, ProgressionModel progressionModel) {
        this.action = action;
        this.context = action.getContext();
        this.progressionModel = progressionModel;
    }

    public boolean isDbUpdated() {
        return this.dbUpdated;
    }

    public boolean isDbInstalled() {
        return this.dbInstalled;
    }

    public Map<String, ApplicationInfo> updateToDo(Map<String, ApplicationInfo> appToUpdate) {
        HashMap result = Maps.newHashMap();
        ApplicationInfo info = appToUpdate.get(DB_UPDATE_NAME);
        if (info == null) {
            this.dbInstalled = false;
            this.dbUpdated = false;
        } else {
            AuthenticationInfo authenticationInfo;
            result.put(info.name, info);
            if (info.needAuthentication && (authenticationInfo = this.context.getAuthenticationInfo(info.url)) != null) {
                info.setAuthentication(authenticationInfo.getLogin(), authenticationInfo.getPassword());
            }
            if (this.context.isDbExist()) {
                this.dbUpdated = true;
            } else {
                this.dbInstalled = true;
            }
        }
        return result;
    }

    public void startUpdate(ApplicationInfo info) {
        if (this.dbInstalled) {
            this.progressionModel.setMessage(I18n._((String)"tutti.applicationUpdater.startUpdate.db.installation", (Object[])new Object[]{info.newVersion}));
        } else if (this.dbUpdated) {
            this.progressionModel.setMessage(I18n._((String)"tutti.applicationUpdater.startUpdate.db.update", (Object[])new Object[]{info.newVersion}));
        }
    }

    public void updateDone(Map<String, ApplicationInfo> appToUpdate, Map<String, Exception> appUpdateError) {
        ApplicationInfo info = appToUpdate.get(DB_UPDATE_NAME);
        Exception error = appUpdateError.get(DB_UPDATE_NAME);
        if (error != null) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Could not update db", (Throwable)error);
            }
            String errorMessage = info != null && info.needAuthentication ? I18n._((String)"tutti.updateDb.error.with.auth", (Object[])new Object[0]) : I18n._((String)"tutti.updateDb.error.with.noauth", (Object[])new Object[0]);
            throw ApplicationActionException.propagateError((AbstractApplicationAction)this.action, (Throwable)new ApplicationTechnicalException(errorMessage, (Throwable)error));
        }
        if (info != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("A db update was downloaded (oldVersion: %s, newVersion: %s), will process it.", info.oldVersion, info.newVersion));
            }
            TuttiConfiguration configuration = this.regenerateDbConf();
            configuration.generateExternalDbFiles(true);
            if (this.dbInstalled) {
                this.prepareFirstDatabase(info);
            } else if (this.dbUpdated) {
                this.synchronizetDatabase(info);
            }
        }
    }

    public void aborted(String propertiesURL, Exception eee) {
        if (log.isErrorEnabled()) {
            log.error((Object)("Could not update from " + propertiesURL), (Throwable)eee);
        }
        throw ApplicationActionException.propagateError((AbstractApplicationAction)this.action, (Throwable)eee);
    }

    protected TuttiConfiguration regenerateDbConf() {
        TuttiConfiguration config = this.context.getConfig();
        this.context.showInformationMessage("Reg\u00e9n\u00e9rer les fichiers de configuration de la base");
        return config;
    }

    protected File getDbDirectory(ApplicationInfo info) {
        File[] sources = info.destDir.listFiles();
        Preconditions.checkState((sources != null && sources.length == 1 ? 1 : 0) != 0, (Object)("Downloaded db should contains one directory at " + info.destDir));
        File result = sources[0];
        return result;
    }

    protected void prepareFirstDatabase(ApplicationInfo info) {
        if (log.isInfoEnabled()) {
            log.info((Object)("First time database was downloaded at version: " + info.newVersion));
        }
        File source = this.getDbDirectory(info);
        File target = this.context.getConfig().getDbDirectory();
        if (log.isInfoEnabled()) {
            log.info((Object)("Copy from " + source + " to " + target));
        }
        try {
            FileUtils.copyDirectory((File)source, (File)target);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException(I18n._((String)"tutti.applicationUpdater.prepareFirstDB.copyDirectory.error", (Object[])new Object[]{source, target}), (Throwable)e);
        }
        try {
            FileUtils.deleteDirectory((File)source.getParentFile());
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException(I18n._((String)"tutti.applicationUpdater.prepareFirstDB.deleteDirectory.error", (Object[])new Object[]{target}), (Throwable)e);
        }
    }

    protected void synchronizetDatabase(ApplicationInfo info) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("A database update was downloaded (oldVersion: %s, newVersion: %s), will launch a referential synchronize operation ", info.oldVersion, info.newVersion));
        }
        TuttiReferentialSynchronizeService service = this.context.getTuttiReferentialSynchronizeService();
        ReferentialSynchroResult result = new ReferentialSynchroResult();
        File dbDirectory = this.getDbDirectory(info);
        ApplicationActionUI actionUI = this.context.getActionUI();
        actionUI.getModel().setProgressionModel((ApplicationProgressionModel)result.getProgressionModel());
        service.prepare(dbDirectory, result);
        if (!result.isSuccess()) {
            throw new ApplicationTechnicalException(I18n._((String)"tutti.applicationUpdater.synchroDB.prepare.error", (Object[])new Object[0]), (Throwable)result.getError());
        }
        service.synchronize(dbDirectory, result);
        if (!result.isSuccess()) {
            throw new ApplicationTechnicalException(I18n._((String)"tutti.applicationUpdater.synchroDB.synchro.error", (Object[])new Object[0]), (Throwable)result.getError());
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"Reset all caches.");
        }
        PersistenceService persistence = this.context.getPersistenceService();
        persistence.clearAllCaches();
        if (log.isInfoEnabled()) {
            log.info((Object)"Clean data context.");
        }
        SampleCategoryModel sampleCategoryModel = this.context.getDataContext().getSampleCategoryModel();
        this.context.getDataContext().clearContext();
        this.context.getDataContext().loadSampleCategoryModel(sampleCategoryModel);
        File target = this.context.getConfig().getDbDirectory();
        File versionFile = ApplicationUpdater.getVersionFile((File)target);
        if (log.isInfoEnabled()) {
            log.info((Object)("Replace content of file " + versionFile + " with " + info.newVersion));
        }
        try {
            ApplicationUpdater.storeVersionFile((File)target, (String)info.newVersion);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException(I18n._((String)"tutti.applicationUpdater.synchroDB.writeVersion.error", (Object[])new Object[]{versionFile}));
        }
    }

    static {
        I18n.n_((String)"tutti.update.db", (Object[])new Object[0]);
    }
}

