/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.catches;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModelEntry;
import fr.ifremer.tutti.persistence.entities.data.SpeciesAbleBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.ValidationService;
import fr.ifremer.tutti.service.catches.TuttiWeightComputingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationBusinessException;
import org.nuiton.validator.NuitonValidatorResult;

public class WeightComputingService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(WeightComputingService.class);
    protected PersistenceService persistenceService;
    protected ValidationService validationService;
    protected DecoratorService decoratorService;
    protected SampleCategoryModel sampleCategoryModel;
    private int currentSpeciesRowIndex;
    private int currentBenthosRowIndex;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.validationService = this.getService(ValidationService.class);
        this.decoratorService = this.getService(DecoratorService.class);
        this.sampleCategoryModel = context.getSampleCategoryModel();
    }

    public Map<String, String> checkCruise(String cruiseId, String uniqueFishingOperationId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will check cruise: " + cruiseId));
        }
        TreeMap result = Maps.newTreeMap();
        ArrayList allFishingOperation = StringUtils.isNotBlank((CharSequence)uniqueFishingOperationId) ? Lists.newArrayList((Object[])new String[]{uniqueFishingOperationId}) : this.persistenceService.getAllFishingOperationIds(cruiseId);
        for (String fishingOperationId : allFishingOperation) {
            BatchContainer<MarineLitterBatch> rootMarineLitterBatch;
            BatchContainer<BenthosBatch> rootBenthosBatch;
            BatchContainer<SpeciesBatch> rootSpeciesBatch;
            boolean withCatchBatch = this.persistenceService.isFishingOperationWithCatchBatch(fishingOperationId);
            if (!withCatchBatch) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Skip fishing operation " + fishingOperationId + " since no catchBatch associated."));
                continue;
            }
            CatchBatch catchBatch = this.persistenceService.getCatchBatchFromFishingOperation(fishingOperationId);
            try {
                rootSpeciesBatch = this.getComputedSpeciesBatches(fishingOperationId);
            }
            catch (ApplicationBusinessException e) {
                result.put(fishingOperationId, e.getMessage());
                rootSpeciesBatch = this.persistenceService.getRootSpeciesBatch(fishingOperationId, null);
            }
            try {
                rootBenthosBatch = this.getComputedBenthosBatches(fishingOperationId);
            }
            catch (ApplicationBusinessException e) {
                result.put(fishingOperationId, e.getMessage());
                rootBenthosBatch = this.persistenceService.getRootBenthosBatch(fishingOperationId, null);
            }
            try {
                Float weight = catchBatch == null ? null : catchBatch.getMarineLitterTotalWeight();
                rootMarineLitterBatch = this.getComputedMarineLitterBatches(fishingOperationId, weight);
            }
            catch (ApplicationBusinessException e) {
                result.put(fishingOperationId, e.getMessage());
                rootMarineLitterBatch = this.persistenceService.getRootMarineLitterBatch(fishingOperationId);
            }
            try {
                if (catchBatch == null) continue;
                this.computeCatchBatchWeights(catchBatch, rootSpeciesBatch, rootBenthosBatch, rootMarineLitterBatch);
            }
            catch (ApplicationBusinessException e) {
                result.put(fishingOperationId, e.getMessage());
            }
        }
        return result;
    }

    public void computeCatchBatchWeights(CatchBatch catchBatch, BatchContainer<SpeciesBatch> rootSpeciesBatch, BatchContainer<BenthosBatch> rootBenthosBatch, BatchContainer<MarineLitterBatch> rootMarineLitterBatch) {
        Float marineLitterTotalWeight;
        Float inertWeight;
        Float speciesTotalComputedSortedWeight = Float.valueOf(0.0f);
        Float speciesTotalComputedUnsortedWeight = Float.valueOf(0.0f);
        if (rootSpeciesBatch != null) {
            SpeciesBatch row;
            Float weight;
            for (int i = 0; i < rootSpeciesBatch.getChildren().size() && (weight = (Float)TuttiEntities.getValueOrComputedValue((Number)(row = (SpeciesBatch)rootSpeciesBatch.getChildren().get(i)).getSampleCategoryWeight(), (Number)row.getSampleCategoryComputedWeight())) != null; ++i) {
                if (this.persistenceService.isVracBatch((SpeciesAbleBatch)row)) {
                    speciesTotalComputedSortedWeight = Float.valueOf(speciesTotalComputedSortedWeight.floatValue() + weight.floatValue());
                    continue;
                }
                speciesTotalComputedUnsortedWeight = Float.valueOf(speciesTotalComputedUnsortedWeight.floatValue() + weight.floatValue());
            }
        }
        if ((inertWeight = catchBatch.getSpeciesTotalInertWeight()) != null) {
            speciesTotalComputedSortedWeight = Float.valueOf(speciesTotalComputedSortedWeight.floatValue() + ((Number)inertWeight).floatValue());
        } else {
            catchBatch.setSpeciesTotalInertComputedWeight(Float.valueOf(0.0f));
        }
        Float livingNotItemizedWeight = catchBatch.getSpeciesTotalLivingNotItemizedWeight();
        if (livingNotItemizedWeight != null) {
            speciesTotalComputedSortedWeight = Float.valueOf(speciesTotalComputedSortedWeight.floatValue() + ((Number)livingNotItemizedWeight).floatValue());
        } else {
            catchBatch.setSpeciesTotalLivingNotItemizedComputedWeight(Float.valueOf(0.0f));
        }
        catchBatch.setSpeciesTotalSampleSortedComputedWeight(speciesTotalComputedSortedWeight);
        Float speciesTotalSortedWeight = catchBatch.getSpeciesTotalSortedWeight();
        if (speciesTotalSortedWeight == null) {
            speciesTotalSortedWeight = speciesTotalComputedSortedWeight;
            catchBatch.setSpeciesTotalSortedComputedWeight(Float.valueOf(TuttiEntities.roundKiloGram((float)speciesTotalSortedWeight.floatValue())));
        } else if (speciesTotalSortedWeight.floatValue() < speciesTotalComputedSortedWeight.floatValue()) {
            throw new ApplicationBusinessException(I18n.t((String)"tutti.service.operations.computeWeights.error.species.incoherentTotalSorted", (Object[])new Object[0]));
        }
        catchBatch.setSpeciesTotalUnsortedComputedWeight(Float.valueOf(TuttiEntities.roundKiloGram((float)speciesTotalComputedUnsortedWeight.floatValue())));
        if (speciesTotalSortedWeight == null) {
            speciesTotalSortedWeight = catchBatch.getSpeciesTotalSortedComputedWeight();
        }
        Float speciesTotalWeight = Float.valueOf(speciesTotalComputedUnsortedWeight.floatValue() + speciesTotalSortedWeight.floatValue());
        catchBatch.setSpeciesTotalComputedWeight(Float.valueOf(TuttiEntities.roundKiloGram((float)speciesTotalWeight.floatValue())));
        Float benthosTotalComputedSortedWeight = Float.valueOf(0.0f);
        Float benthosTotalComputedUnsortedWeight = Float.valueOf(0.0f);
        if (rootBenthosBatch != null) {
            BenthosBatch row;
            Float weight;
            for (int i = 0; i < rootBenthosBatch.getChildren().size() && (weight = (Float)TuttiEntities.getValueOrComputedValue((Number)(row = (BenthosBatch)rootBenthosBatch.getChildren().get(i)).getSampleCategoryWeight(), (Number)row.getSampleCategoryComputedWeight())) != null; ++i) {
                if (this.persistenceService.isVracBatch((SpeciesAbleBatch)row)) {
                    benthosTotalComputedSortedWeight = Float.valueOf(benthosTotalComputedSortedWeight.floatValue() + weight.floatValue());
                    continue;
                }
                benthosTotalComputedUnsortedWeight = Float.valueOf(benthosTotalComputedUnsortedWeight.floatValue() + weight.floatValue());
            }
        }
        if ((inertWeight = catchBatch.getBenthosTotalInertWeight()) != null) {
            benthosTotalComputedSortedWeight = Float.valueOf(benthosTotalComputedSortedWeight.floatValue() + ((Number)inertWeight).floatValue());
        } else {
            catchBatch.setBenthosTotalInertComputedWeight(Float.valueOf(0.0f));
        }
        livingNotItemizedWeight = catchBatch.getBenthosTotalLivingNotItemizedWeight();
        if (livingNotItemizedWeight != null) {
            benthosTotalComputedSortedWeight = Float.valueOf(benthosTotalComputedSortedWeight.floatValue() + ((Number)livingNotItemizedWeight).floatValue());
        } else {
            catchBatch.setBenthosTotalLivingNotItemizedComputedWeight(Float.valueOf(0.0f));
        }
        catchBatch.setBenthosTotalSampleSortedComputedWeight(Float.valueOf(TuttiEntities.roundKiloGram((float)benthosTotalComputedSortedWeight.floatValue())));
        Float benthosTotalSortedWeight = catchBatch.getBenthosTotalSortedWeight();
        if (benthosTotalSortedWeight == null) {
            benthosTotalSortedWeight = benthosTotalComputedSortedWeight;
            catchBatch.setBenthosTotalSortedComputedWeight(Float.valueOf(TuttiEntities.roundKiloGram((float)benthosTotalSortedWeight.floatValue())));
        } else if (benthosTotalSortedWeight.floatValue() < benthosTotalComputedSortedWeight.floatValue()) {
            throw new ApplicationBusinessException(I18n.t((String)"tutti.service.operations.computeWeights.error.benthos.incoherentTotalSorted", (Object[])new Object[0]));
        }
        catchBatch.setBenthosTotalUnsortedComputedWeight(Float.valueOf(TuttiEntities.roundKiloGram((float)benthosTotalComputedUnsortedWeight.floatValue())));
        if (benthosTotalSortedWeight == null) {
            benthosTotalSortedWeight = catchBatch.getBenthosTotalSortedComputedWeight();
        }
        Float benthosTotalWeight = Float.valueOf(benthosTotalComputedUnsortedWeight.floatValue() + benthosTotalSortedWeight.floatValue());
        catchBatch.setBenthosTotalComputedWeight(Float.valueOf(TuttiEntities.roundKiloGram((float)benthosTotalWeight.floatValue())));
        Float marineLitterTotalComputedWeight = Float.valueOf(0.0f);
        if (rootMarineLitterBatch != null) {
            for (int i = 0; i < rootMarineLitterBatch.getChildren().size(); ++i) {
                MarineLitterBatch row = (MarineLitterBatch)rootMarineLitterBatch.getChildren().get(i);
                Float rowWeight = row.getWeight();
                if (rowWeight == null) {
                    marineLitterTotalComputedWeight = null;
                    break;
                }
                marineLitterTotalComputedWeight = Float.valueOf(marineLitterTotalComputedWeight.floatValue() + rowWeight.floatValue());
            }
        }
        if (marineLitterTotalComputedWeight != null) {
            catchBatch.setMarineLitterTotalComputedWeight(Float.valueOf(TuttiEntities.roundKiloGram((float)marineLitterTotalComputedWeight.floatValue())));
        }
        if ((marineLitterTotalWeight = catchBatch.getMarineLitterTotalWeight()) == null) {
            marineLitterTotalWeight = marineLitterTotalComputedWeight;
        } else if (marineLitterTotalComputedWeight != null && marineLitterTotalWeight.floatValue() < marineLitterTotalComputedWeight.floatValue()) {
            throw new ApplicationBusinessException(I18n.t((String)"tutti.service.operations.computeWeights.error.marineLitter.incoherentTotal", (Object[])new Object[0]));
        }
        Float totalUnsortedWeight = Float.valueOf(catchBatch.getSpeciesTotalUnsortedComputedWeight().floatValue() + catchBatch.getBenthosTotalUnsortedComputedWeight().floatValue());
        Float totalSortedWeight = Float.valueOf(speciesTotalSortedWeight.floatValue() + benthosTotalSortedWeight.floatValue());
        catchBatch.setCatchTotalSortedComputedWeight(Float.valueOf(TuttiEntities.roundKiloGram((float)totalSortedWeight.floatValue())));
        catchBatch.setCatchTotalUnsortedComputedWeight(Float.valueOf(TuttiEntities.roundKiloGram((float)totalUnsortedWeight.floatValue())));
        Float totalWeight = catchBatch.getCatchTotalWeight();
        Float rejectedWeight = catchBatch.getCatchTotalRejectedWeight();
        if (rejectedWeight == null && totalWeight != null) {
            if (!totalWeight.equals(Float.valueOf(totalUnsortedWeight.floatValue() + totalSortedWeight.floatValue()))) {
                throw new ApplicationBusinessException(I18n.t((String)"tutti.service.operations.computeWeights.error.incoherentTotal", (Object[])new Object[0]));
            }
            catchBatch.setCatchTotalRejectedComputedWeight(Float.valueOf(TuttiEntities.roundKiloGram((float)(totalWeight.floatValue() - totalUnsortedWeight.floatValue() - totalSortedWeight.floatValue()))));
        } else if (totalWeight == null) {
            if (rejectedWeight == null) {
                rejectedWeight = Float.valueOf(0.0f);
                catchBatch.setCatchTotalRejectedComputedWeight(Float.valueOf(0.0f));
            }
            catchBatch.setCatchTotalComputedWeight(Float.valueOf(TuttiEntities.roundKiloGram((float)(totalUnsortedWeight.floatValue() + totalSortedWeight.floatValue() + rejectedWeight.floatValue()))));
        } else if (!totalWeight.equals(Float.valueOf(totalUnsortedWeight.floatValue() + totalSortedWeight.floatValue() + rejectedWeight.floatValue()))) {
            throw new ApplicationBusinessException(I18n.t((String)"tutti.service.operations.computeWeights.error.incoherentTotal", (Object[])new Object[0]));
        }
    }

    public BatchContainer<SpeciesBatch> getComputedSpeciesBatches(String operationId) {
        BatchContainer<SpeciesBatch> rootSpeciesBatch = null;
        if (this.persistenceService.isFishingOperationWithCatchBatch(operationId)) {
            rootSpeciesBatch = this.persistenceService.getRootSpeciesBatch(operationId, null);
            this.currentSpeciesRowIndex = 0;
            if (rootSpeciesBatch != null) {
                List roots = rootSpeciesBatch.getChildren();
                for (SpeciesBatch batch : roots) {
                    this.computeSpeciesBatch(batch);
                }
            }
        }
        return rootSpeciesBatch;
    }

    protected String getCategoryLabel(Integer sampleCategoryId) {
        SampleCategoryModelEntry category = this.sampleCategoryModel.getCategoryById(sampleCategoryId);
        String result = category.getLabel();
        return result;
    }

    public Float computeSpeciesBatch(SpeciesBatch batch) {
        Float result = null;
        int thisIndex = this.currentSpeciesRowIndex++;
        Float categoryWeight = batch.getSampleCategoryWeight();
        Float rowWeight = batch.getWeight();
        String species = this.decoratorService.getDecoratorByType(Species.class).toString((Object)batch.getSpecies());
        String categoryValue = this.decoratorService.getDecorator(batch.getSampleCategoryValue()).toString((Object)batch.getSampleCategoryValue());
        NuitonValidatorResult validation = this.validationService.validateSpeciesBatch(batch);
        if (!validation.isValid()) {
            List messages = validation.getErrorMessages("weight");
            String categoryLabel = this.getCategoryLabel(batch.getSampleCategoryId());
            throw new TuttiWeightComputingException(I18n.t((String)((String)messages.get(0)), (Object[])new Object[]{species, categoryLabel, categoryValue, batch.getWeight(), batch.getSampleCategoryWeight()}), "weight", thisIndex);
        }
        List children = batch.getChildBatchs();
        if (batch.sizeChildBatchs() > 0) {
            Float sum = Float.valueOf(0.0f);
            for (SpeciesBatch child : children) {
                Float weight = this.computeSpeciesBatch(child);
                if (weight == null) {
                    sum = null;
                    break;
                }
                sum = Float.valueOf(sum.floatValue() + weight.floatValue());
            }
            if (sum != null) {
                if (categoryWeight == null) {
                    batch.setSampleCategoryComputedWeight(Float.valueOf(TuttiEntities.roundKiloGram((float)sum.floatValue())));
                } else {
                    if (categoryWeight.floatValue() < sum.floatValue()) {
                        String categoryLabel = this.getCategoryLabel(batch.getSampleCategoryId());
                        throw new TuttiWeightComputingException(I18n.t((String)"tutti.service.operations.computeWeights.error.species.incoherentParentCategoryWeight", (Object[])new Object[]{species, categoryLabel, categoryValue, categoryWeight, sum}), "sampleCategoryWeight", thisIndex);
                    }
                    sum = categoryWeight;
                }
                result = sum;
            }
        } else {
            batch.setComputedWeight(null);
            List<SpeciesBatchFrequency> frequencies = this.persistenceService.getAllSpeciesBatchFrequency(batch.getId());
            if (CollectionUtils.isNotEmpty(frequencies)) {
                Float frequencyWeight = Float.valueOf(0.0f);
                for (SpeciesBatchFrequency frequency : frequencies) {
                    Float w = frequency.getWeight();
                    if (w == null) {
                        frequencyWeight = null;
                        break;
                    }
                    if (frequencyWeight == null) continue;
                    frequencyWeight = Float.valueOf(frequencyWeight.floatValue() + w.floatValue());
                }
                if (categoryWeight != null || rowWeight == null) {
                    String categoryLabel;
                    if (rowWeight != null && frequencyWeight != null && !rowWeight.equals(frequencyWeight)) {
                        categoryLabel = this.getCategoryLabel(batch.getSampleCategoryId());
                        throw new TuttiWeightComputingException(I18n.t((String)"tutti.service.operations.computeWeights.error.species.incoherentRowWeightFrequency", (Object[])new Object[]{species, categoryLabel, categoryValue, frequencyWeight, rowWeight}), "weight", thisIndex);
                    }
                    if (categoryWeight == null && frequencyWeight != null) {
                        batch.setSampleCategoryComputedWeight(Float.valueOf(TuttiEntities.roundKiloGram((float)frequencyWeight.floatValue())));
                        result = frequencyWeight;
                    } else if (frequencyWeight != null && !frequencyWeight.equals(categoryWeight)) {
                        if (frequencyWeight.floatValue() > categoryWeight.floatValue()) {
                            categoryLabel = this.getCategoryLabel(batch.getSampleCategoryId());
                            throw new TuttiWeightComputingException(I18n.t((String)"tutti.service.operations.computeWeights.error.species.incoherentCategoryWeight", (Object[])new Object[]{species, categoryLabel, categoryValue, frequencyWeight, categoryWeight}), "sampleCategoryWeight", thisIndex);
                        }
                        if (rowWeight == null) {
                            batch.setComputedWeight(Float.valueOf(TuttiEntities.roundKiloGram((float)frequencyWeight.floatValue())));
                        }
                        result = categoryWeight;
                    } else {
                        result = categoryWeight;
                    }
                }
                Integer frequencyNumber = 0;
                for (SpeciesBatchFrequency frequency : frequencies) {
                    Integer c = frequency.getNumber();
                    frequencyNumber = frequencyNumber + c;
                }
                batch.setComputedNumber(frequencyNumber);
            } else {
                result = categoryWeight;
            }
        }
        if (result == null) {
            String categoryLabel = this.getCategoryLabel(batch.getSampleCategoryId());
            throw new TuttiWeightComputingException(I18n.t((String)"tutti.service.operations.computeWeights.error.species.noWeight", (Object[])new Object[]{species, categoryLabel, categoryValue}), "sampleCategoryWeight", thisIndex);
        }
        return Float.valueOf(TuttiEntities.roundKiloGram((float)result.floatValue()));
    }

    public BatchContainer<BenthosBatch> getComputedBenthosBatches(String operationId) {
        BatchContainer<BenthosBatch> rootBenthosBatch = null;
        if (this.persistenceService.isFishingOperationWithCatchBatch(operationId)) {
            rootBenthosBatch = this.persistenceService.getRootBenthosBatch(operationId, null);
            this.currentBenthosRowIndex = 0;
            if (rootBenthosBatch != null) {
                List roots = rootBenthosBatch.getChildren();
                for (BenthosBatch batch : roots) {
                    this.computeBenthosBatch(batch);
                }
            }
        }
        return rootBenthosBatch;
    }

    public Float computeBenthosBatch(BenthosBatch batch) {
        Float result = null;
        int thisIndex = this.currentBenthosRowIndex++;
        Float categoryWeight = batch.getSampleCategoryWeight();
        Float rowWeight = batch.getWeight();
        String species = this.decoratorService.getDecoratorByType(Species.class).toString((Object)batch.getSpecies());
        String categoryValue = this.decoratorService.getDecorator(batch.getSampleCategoryValue()).toString((Object)batch.getSampleCategoryValue());
        NuitonValidatorResult validation = this.validationService.validateBenthosBatch(batch);
        if (!validation.isValid()) {
            List messages = validation.getErrorMessages("weight");
            String categoryLabel = this.getCategoryLabel(batch.getSampleCategoryId());
            throw new TuttiWeightComputingException(I18n.t((String)((String)messages.get(0)), (Object[])new Object[]{species, categoryLabel, categoryValue, batch.getWeight(), batch.getSampleCategoryWeight()}), "weight", thisIndex);
        }
        List children = batch.getChildBatchs();
        if (!batch.isChildBatchsEmpty()) {
            Float sum = Float.valueOf(0.0f);
            for (BenthosBatch child : children) {
                Float weight = this.computeBenthosBatch(child);
                if (weight == null) {
                    sum = null;
                    break;
                }
                sum = Float.valueOf(sum.floatValue() + weight.floatValue());
            }
            if (sum != null) {
                if (categoryWeight == null) {
                    batch.setSampleCategoryComputedWeight(Float.valueOf(TuttiEntities.roundKiloGram((float)sum.floatValue())));
                } else {
                    if (categoryWeight.floatValue() < sum.floatValue()) {
                        String categoryLabel = this.getCategoryLabel(batch.getSampleCategoryId());
                        throw new TuttiWeightComputingException(I18n.t((String)"tutti.service.operations.computeWeights.error.benthos.incoherentParentCategoryWeight", (Object[])new Object[]{species, categoryLabel, categoryValue, categoryWeight, sum}), "sampleCategoryWeight", thisIndex);
                    }
                    sum = categoryWeight;
                }
                result = sum;
            }
        } else {
            batch.setComputedWeight(null);
            List<BenthosBatchFrequency> frequencies = this.persistenceService.getAllBenthosBatchFrequency(batch.getId());
            if (CollectionUtils.isNotEmpty(frequencies)) {
                Float frequencyWeight = Float.valueOf(0.0f);
                for (BenthosBatchFrequency frequency : frequencies) {
                    Float w = frequency.getWeight();
                    if (w == null) {
                        frequencyWeight = null;
                        break;
                    }
                    if (frequencyWeight == null) continue;
                    frequencyWeight = Float.valueOf(frequencyWeight.floatValue() + w.floatValue());
                }
                if (categoryWeight != null || rowWeight == null) {
                    String categoryLabel;
                    if (rowWeight != null && frequencyWeight != null && !rowWeight.equals(frequencyWeight)) {
                        categoryLabel = this.getCategoryLabel(batch.getSampleCategoryId());
                        throw new TuttiWeightComputingException(I18n.t((String)"tutti.service.operations.computeWeights.error.benthos.incoherentRowWeightFrequency", (Object[])new Object[]{species, categoryLabel, categoryValue, rowWeight, categoryWeight}), "weight", thisIndex);
                    }
                    if (categoryWeight == null && frequencyWeight != null) {
                        batch.setSampleCategoryComputedWeight(Float.valueOf(TuttiEntities.roundKiloGram((float)frequencyWeight.floatValue())));
                        result = frequencyWeight;
                    } else if (frequencyWeight != null && !frequencyWeight.equals(categoryWeight)) {
                        if (frequencyWeight.floatValue() > categoryWeight.floatValue()) {
                            categoryLabel = this.getCategoryLabel(batch.getSampleCategoryId());
                            throw new TuttiWeightComputingException(I18n.t((String)"tutti.service.operations.computeWeights.error.benthos.incoherentCategoryWeight", (Object[])new Object[]{species, categoryLabel, categoryValue, frequencyWeight, categoryWeight}), "sampleCategoryWeight", thisIndex);
                        }
                        if (rowWeight == null) {
                            batch.setComputedWeight(Float.valueOf(TuttiEntities.roundKiloGram((float)frequencyWeight.floatValue())));
                        }
                        result = categoryWeight;
                    } else {
                        result = categoryWeight;
                    }
                }
                Integer frequencyNumber = 0;
                for (BenthosBatchFrequency frequency : frequencies) {
                    Integer c = frequency.getNumber();
                    frequencyNumber = frequencyNumber + c;
                }
                batch.setComputedNumber(frequencyNumber);
            } else {
                result = categoryWeight;
            }
        }
        if (result == null) {
            String categoryLabel = this.getCategoryLabel(batch.getSampleCategoryId());
            throw new TuttiWeightComputingException(I18n.t((String)"tutti.service.operations.computeWeights.error.benthos.noWeight", (Object[])new Object[]{species, categoryLabel, categoryValue}), "sampleCategoryWeight", thisIndex);
        }
        return Float.valueOf(TuttiEntities.roundKiloGram((float)result.floatValue()));
    }

    public BatchContainer<MarineLitterBatch> getComputedMarineLitterBatches(String fishingOperationId, Float marineLitterweight) {
        BatchContainer<MarineLitterBatch> rootMarineLitterBatch = this.persistenceService.getRootMarineLitterBatch(fishingOperationId);
        if (rootMarineLitterBatch != null) {
            boolean checkWeight = marineLitterweight == null;
            List children = rootMarineLitterBatch.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                MarineLitterBatch batch = (MarineLitterBatch)children.get(i);
                if (!checkWeight || batch.getWeight() != null) continue;
                throw new TuttiWeightComputingException(I18n.t((String)"tutti.validator.warning.marineLitter.weight.required", (Object[])new Object[0]), "weight", i);
            }
        }
        return rootMarineLitterBatch;
    }
}

