/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.test;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import fr.ifremer.tutti.TuttiConfiguration;
import fr.ifremer.tutti.TuttiConfigurationOption;
import fr.ifremer.tutti.persistence.RessourceClassLoader;
import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.service.TuttiPersistenceServiceLocator;
import fr.ifremer.tutti.persistence.test.DatabaseFixtures;
import fr.ifremer.tutti.persistence.test.TuttiRunListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assume;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runners.model.Statement;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.ConfigOptionDef;
import org.nuiton.util.FileUtil;
import org.nuiton.util.converter.ConverterUtil;

public class DatabaseResource
implements TestRule {
    private static final Log log = LogFactory.getLog(DatabaseResource.class);
    public static long BUILD_TIMESTAMP = System.nanoTime();
    private static ClassLoader oldClassLoader;
    protected RessourceClassLoader loader;
    private File resourceDirectory;
    private TuttiConfiguration config;
    private DatabaseFixtures fixtures;
    protected final String beanFactoryReferenceLocation;
    private final String beanRefFactoryReferenceId;
    private final boolean writeDb;
    private String dbName;
    private boolean destroyResources;
    Class<?> testClass;
    protected final Set<File> toDetroy = Sets.newHashSet();

    public static DatabaseResource readDb() {
        return new DatabaseResource("");
    }

    public static DatabaseResource writeDb() {
        return new DatabaseResource("", true);
    }

    public static DatabaseResource readDb(String dbName) {
        return new DatabaseResource(dbName);
    }

    public static DatabaseResource writeDb(String dbName) {
        return new DatabaseResource(dbName, true);
    }

    public static DatabaseResource noDb() {
        return new DatabaseResource("", "beanRefFactoryWitNoDb.xml", "TuttiBeanRefFactoryWithNoDb");
    }

    protected DatabaseResource(String dbName) {
        this(dbName, null, null, false);
    }

    protected DatabaseResource(String dbName, boolean writeDb) {
        this(dbName, null, null, writeDb);
    }

    protected DatabaseResource(String dbName, String beanFactoryReferenceLocation, String beanRefFactoryReferenceId) {
        this(dbName, beanFactoryReferenceLocation, beanRefFactoryReferenceId, false);
    }

    protected DatabaseResource(String dbName, String beanFactoryReferenceLocation, String beanRefFactoryReferenceId, boolean writeDb) {
        this.dbName = dbName;
        this.beanFactoryReferenceLocation = beanFactoryReferenceLocation;
        this.beanRefFactoryReferenceId = beanRefFactoryReferenceId;
        this.writeDb = writeDb;
    }

    public TuttiConfiguration getConfig() {
        return this.config;
    }

    public DatabaseFixtures getFixtures() {
        return this.fixtures;
    }

    public File getResourceDirectory(String name) {
        return new File(this.resourceDirectory, name);
    }

    public void setDestroyResources(boolean destroyResources) {
        this.destroyResources = destroyResources;
    }

    public void updateSchema(TuttiPersistence persistenceService) {
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                DatabaseResource.this.before(description);
                try {
                    base.evaluate();
                }
                finally {
                    DatabaseResource.this.after(description);
                }
            }
        };
    }

    public void prepareConfig(ApplicationConfig applicationConfig, File resourceDirectory) {
        applicationConfig.loadDefaultOptions((ConfigOptionDef[])TuttiConfigurationOption.values());
        applicationConfig.setDefaultOption("tutti.data.directory", new File(resourceDirectory, "data").getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File copyClassPathResource(String path, String destinationName) throws IOException {
        InputStream inputStream = this.getClass().getResourceAsStream("/" + path);
        Preconditions.checkNotNull((Object)inputStream, (Object)("Could not find " + path + " in test class-path"));
        File output = new File(this.resourceDirectory, destinationName);
        FileOutputStream outputStream = FileUtils.openOutputStream((File)output);
        try {
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            inputStream.close();
            ((OutputStream)outputStream).close();
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
        return output;
    }

    protected void before(Description description) throws Throwable {
        ApplicationConfig applicationConfig;
        String configFilename;
        TuttiRunListener.beforeClass(description);
        this.testClass = description.getTestClass();
        boolean defaultDbName = StringUtils.isEmpty((CharSequence)this.dbName);
        if (defaultDbName) {
            this.dbName = "db";
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Prepare test " + this.testClass));
        }
        this.fixtures = new DatabaseFixtures();
        this.resourceDirectory = FileUtil.getTestSpecificDirectory(this.testClass, (String)"", null, (long)BUILD_TIMESTAMP);
        this.loader = new RessourceClassLoader(this.testClass.getClassLoader());
        oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.loader);
        ConverterUtil.deregister();
        ConverterUtil.initConverters();
        String string = configFilename = this.writeDb ? "tutti-test-write" : "tutti-test-read";
        if (!defaultDbName) {
            configFilename = configFilename + "-" + this.dbName;
        }
        configFilename = configFilename + ".properties";
        InputStream resourceAsStream = this.getClass().getResourceAsStream("/" + configFilename);
        if (resourceAsStream == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("No configuration file found in classpath at " + configFilename));
            }
            applicationConfig = new ApplicationConfig();
        } else {
            applicationConfig = new ApplicationConfig(configFilename);
        }
        this.prepareConfig(applicationConfig, this.resourceDirectory);
        applicationConfig.parse(new String[0]);
        this.config = new TuttiConfiguration(applicationConfig);
        TuttiConfiguration.setInstance(this.config);
        File db = this.writeDb ? FileUtil.getFileFromPaths((File)new File("src"), (String[])new String[]{"test", this.dbName}) : this.config.getDbDirectory();
        if (!db.exists()) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Could not find db at " + db + ", test [" + this.testClass + "] is skipped."));
            }
            Assume.assumeTrue((boolean)false);
        }
        if (this.writeDb) {
            this.copyDb(this.config.getDbDirectory(), false, null);
        }
        this.toDetroy.add(this.config.getDbAttachmentDirectory());
        File dbConfig = new File(this.config.getDbDirectory(), this.config.getDbName() + ".properties");
        Properties p = new Properties();
        BufferedReader reader = Files.newReader((File)dbConfig, (Charset)Charsets.UTF_8);
        p.load(reader);
        reader.close();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Db config: " + dbConfig + "\n" + p));
        }
        if (this.writeDb) {
            String readonly = p.getProperty("readonly");
            Preconditions.checkNotNull((Object)readonly, (Object)("Could not find readonly property on db confg: " + dbConfig));
            Preconditions.checkState((boolean)"false".equals(readonly), (Object)("readonly property must be at false value in write mode test in  db confg: " + dbConfig));
        } else {
            String readonly = p.getProperty("readonly");
            Preconditions.checkNotNull((Object)readonly, (Object)("Could not find readonly property on db confg: " + dbConfig));
            Preconditions.checkState((boolean)"true".equals(readonly), (Object)("readonly property must be at true value in read mode test in  db confg: " + dbConfig));
        }
        this.config.initConfig(this.loader);
        if (log.isInfoEnabled()) {
            log.info((Object)("Use db: " + this.config.getJdbcUrl()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Use conf.properties at " + this.config.getDbConfigurationPath()));
        }
        if (this.beanFactoryReferenceLocation != null) {
            TuttiPersistenceServiceLocator.initTutti(this.beanFactoryReferenceLocation, this.beanRefFactoryReferenceId);
        }
    }

    public void addToDestroy(File dir) {
        this.toDetroy.add(dir);
    }

    public void copyDb(String dbDirectory, boolean readonly, Properties p) throws IOException {
        File externalDbFile = this.getResourceDirectory(dbDirectory);
        this.copyDb(externalDbFile, readonly, p);
    }

    public void copyDb(File target, boolean readonly, Properties p) throws IOException {
        File db = FileUtil.getFileFromPaths((File)new File("src"), (String[])new String[]{"test", this.dbName});
        if (!db.exists()) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Could not find db at " + db + ", test [" + this.testClass + "] is skipped."));
            }
            Assume.assumeTrue((boolean)false);
        }
        this.toDetroy.add(target);
        FileUtils.copyDirectory((File)db, (File)target);
        if (p != null) {
            TuttiEntities.fillConnectionProperties(p, TuttiEntities.getJdbcUrl(target, this.config.getDbName()), this.config.getJdbcUsername(), this.config.getJdbcPassword());
        }
        File dbConfig = new File(target, this.config.getDbName() + ".properties");
        Properties dbconf = new Properties();
        BufferedReader reader = Files.newReader((File)dbConfig, (Charset)Charsets.UTF_8);
        dbconf.load(reader);
        reader.close();
        dbconf.setProperty("readonly", String.valueOf(readonly));
        BufferedWriter writer = Files.newWriter((File)dbConfig, (Charset)Charsets.UTF_8);
        dbconf.store(writer, "");
        writer.close();
    }

    protected void after(Description description) throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)("After test " + this.testClass));
        }
        this.closeSpring();
        TuttiConfiguration.setInstance(null);
        Set<Failure> failures = TuttiRunListener.getFailuresForClass(description.getClassName());
        if (this.destroyResources && failures.isEmpty()) {
            for (File file : this.toDetroy) {
                if (!file.exists()) continue;
                if (log.isInfoEnabled()) {
                    log.info((Object)("Destroy directory: " + file));
                }
                try {
                    FileUtils.deleteDirectory((File)file);
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) continue;
                    log.error((Object)("Could not delete directory: " + file), (Throwable)e);
                }
            }
        } else if (!this.destroyResources) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Won't destroy directories (destroyResources flag was false).");
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"Won't destroy directories cause of failures in test.");
        }
        if (oldClassLoader != null) {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    protected void closeSpring() {
        TuttiPersistenceServiceLocator.close();
        if (this.beanFactoryReferenceLocation != null) {
            TuttiPersistenceServiceLocator.initTuttiDefault();
        }
    }

    public Connection createEmptyDb(String dbDirectory, String scriptDbname, String dbName, Properties p) throws IOException, SQLException {
        File directory = this.getResourceDirectory(dbDirectory);
        if (log.isInfoEnabled()) {
            log.info((Object)("Create new db at " + directory));
        }
        this.addToDestroy(directory);
        String jdbcUrl = TuttiEntities.getJdbcUrl(directory, dbName);
        String user = "SA";
        String password = "";
        if (p != null) {
            TuttiEntities.fillConnectionProperties(p, jdbcUrl, user, password);
        }
        File scriptFile = FileUtil.getFileFromPaths((File)new File("src"), (String[])new String[]{"test", scriptDbname, "allegro.script"});
        Preconditions.checkNotNull((Object)("Could not find db script in configuration at " + scriptFile));
        Preconditions.checkState((boolean)scriptFile.exists(), (Object)("Could not find db script at " + scriptFile));
        if (log.isInfoEnabled()) {
            log.info((Object)("Will use create script: " + scriptFile));
        }
        Connection connection = TuttiEntities.createConnection(jdbcUrl, user, password);
        if (log.isInfoEnabled()) {
            log.info((Object)("Created connection at " + connection.getMetaData().getURL()));
        }
        List<String> importScriptSql = this.getImportScriptSql(scriptFile);
        for (String sql : importScriptSql) {
            PreparedStatement statement = connection.prepareStatement(sql);
            statement.execute();
        }
        connection.commit();
        return connection;
    }

    protected List<String> getImportScriptSql(File scriptFile) throws IOException {
        List lines = Files.readLines((File)scriptFile, (Charset)Charsets.UTF_8);
        ArrayList result = Lists.newArrayListWithCapacity((int)lines.size());
        Predicate<String> predicate = new Predicate<String>(){
            Set<String> forbiddenStarts = Sets.newHashSet((Object[])new String[]{"SET ", "CREATE USER ", "CREATE SCHEMA ", "GRANT DBA TO "});

            public boolean apply(String input) {
                boolean accept = true;
                for (String forbiddenStart : this.forbiddenStarts) {
                    if (!input.startsWith(forbiddenStart)) continue;
                    accept = false;
                    break;
                }
                return accept;
            }
        };
        for (String line : lines) {
            if (!predicate.apply((Object)line.trim().toUpperCase())) continue;
            result.add(line);
        }
        return result;
    }
}

