/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.entities;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.TuttiEntity;
import fr.ifremer.tutti.persistence.entities.data.SpeciesAbleBatch;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicType;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import java.io.File;
import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.application.ApplicationDataUtil;

public class TuttiEntities
extends ApplicationDataUtil {
    public static final Comparator<Species> SPECIES_BY_NAME_COMPARATOR = new Comparator<Species>(){

        @Override
        public int compare(Species o1, Species o2) {
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.getName().compareTo(o2.getName());
        }
    };
    public static final Predicate<Gear> IS_FISHING_GEAR = new Predicate<Gear>(){

        public boolean apply(Gear input) {
            return !input.isScientificGear();
        }
    };
    public static final Predicate<Gear> IS_SCIENTIFIC_GEAR = new Predicate<Gear>(){

        public boolean apply(Gear input) {
            return input.isScientificGear();
        }
    };
    private static final Log log = LogFactory.getLog(TuttiEntities.class);
    public static final Function<Species, String> GET_TAXON_ID = new Function<Species, String>(){

        public String apply(Species input) {
            return String.valueOf(input.getReferenceTaxonId());
        }
    };
    public static final Function<Species, String> GET_REF_TAX_CODE = new Function<Species, String>(){

        public String apply(Species input) {
            return String.valueOf(input.getRefTaxCode());
        }
    };
    public static final Function<TuttiEntity, String> GET_ID = new Function<TuttiEntity, String>(){

        public String apply(TuttiEntity input) {
            return input.getId();
        }
    };
    public static final Function<TuttiEntity, Integer> GET_ID_AS_INT = new Function<TuttiEntity, Integer>(){

        public Integer apply(TuttiEntity input) {
            return input.getIdAsInt();
        }
    };
    private static final double EARTH_RADIUS = 6378288.0;
    private static final MathContext MATH_CONTEXT_4_DIGIT = new MathContext(4);
    private static DecimalFormatSymbols symbols;
    private static DecimalFormat decimalFormat;

    protected TuttiEntities() {
    }

    public static <B extends TuttiEntity> List<String> toIds(List<B> list) {
        List result = list == null ? Collections.emptyList() : Lists.transform(list, GET_ID);
        return result;
    }

    public static <B extends TuttiEntity> List<Integer> toIntegerIds(Collection<B> list) {
        List result = list == null ? Collections.emptyList() : Lists.transform((List)Lists.newArrayList(list), GET_ID_AS_INT);
        return result;
    }

    public static Set<String> toTaxonIds(List<Species> list) {
        HashSet result = list == null ? Collections.emptySet() : Sets.newHashSet((Iterable)Lists.transform(list, GET_TAXON_ID));
        return result;
    }

    public static <B extends TuttiEntity> Map<String, B> splitById(Iterable<B> list) {
        return Maps.uniqueIndex(list, GET_ID);
    }

    public static <B extends TuttiEntity> Map<Integer, B> splitByIdAsInt(Iterable<B> list) {
        return Maps.uniqueIndex(list, GET_ID_AS_INT);
    }

    public static Map<String, Species> splitByTaxonId(Iterable<Species> list) {
        return Maps.uniqueIndex(list, GET_TAXON_ID);
    }

    public static Multimap<String, Species> splitByReferenceTaxonId(Iterable<Species> list) {
        return Multimaps.index(list, GET_TAXON_ID);
    }

    public static Multimap<String, Species> splitByRefTaxCode(Iterable<Species> list) {
        return Multimaps.index(list, GET_REF_TAX_CODE);
    }

    public static <B extends TuttiEntity> boolean isNew(B bean) {
        return bean.getId() == null;
    }

    public static <B extends TuttiEntity> Predicate<B> newIdPredicate(String id) {
        return new IdPredicate(id);
    }

    public static Predicate<Caracteristic> newSampleCategoryModelPredicate() {
        return new SampleCategoryCaracteristicPredicate();
    }

    public static Predicate<SpeciesAbleBatch> newSpeciesAbleBatchCategoryPredicate(Integer cateogryId, Integer value) {
        return new SpeciesAbleBatchCategoryPredicate(cateogryId, value);
    }

    public static <B extends TuttiEntity> B findById(Iterable<B> beans, String id) {
        TuttiEntity result = (TuttiEntity)Iterables.tryFind(beans, TuttiEntities.newIdPredicate(id)).orNull();
        return (B)result;
    }

    public static void closeSilently(Statement statement) {
        block7: {
            try {
                if (statement != null && !statement.isClosed()) {
                    statement.close();
                }
            }
            catch (AbstractMethodError e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Fix this linkage error, damned hsqlsb 1.8.0.7:(");
                }
            }
            catch (IllegalAccessError e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Fix this IllegalAccessError error, damned hsqlsb 1.8.0.7:(");
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block7;
                log.error((Object)"Could not close statement, but do not care", (Throwable)e);
            }
        }
    }

    public static void closeSilently(ResultSet statement) {
        block7: {
            try {
                if (statement != null && !statement.isClosed()) {
                    statement.close();
                }
            }
            catch (AbstractMethodError e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Fix this linkage error, damned hsqlsb 1.8.0.7:(");
                }
            }
            catch (IllegalAccessError e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Fix this IllegalAccessError error, damned hsqlsb 1.8.0.7:(");
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block7;
                log.error((Object)"Could not close statement, but do not care", (Throwable)e);
            }
        }
    }

    public static Connection createConnection(Properties connectionProperties) throws SQLException {
        return TuttiEntities.createConnection(connectionProperties.getProperty("hibernate.connection.url"), connectionProperties.getProperty("hibernate.connection.username"), connectionProperties.getProperty("hibernate.connection.password"));
    }

    public static String getUrl(Properties connectionProperties) {
        return connectionProperties.getProperty("hibernate.connection.url");
    }

    public static Connection createConnection(String jdbcUrl, String user, String password) throws SQLException {
        Connection connection = DriverManager.getConnection(jdbcUrl, user, password);
        connection.setAutoCommit(false);
        return connection;
    }

    public static <B extends TuttiEntity> List<String> collecIds(List<B> list) {
        List result = Lists.transform(list, GET_ID);
        return result;
    }

    public static void fillConnectionProperties(Properties p, String url, String username, String password) {
        p.put("hibernate.connection.url", url);
        p.put("hibernate.connection.username", username);
        p.put("hibernate.connection.password", password);
    }

    public static String getJdbcUrl(File directory, String dbName) {
        return "jdbc:hsqldb:file:" + directory.getAbsolutePath() + "/" + dbName;
    }

    public static CaracteristicQualitativeValue getQualitativeValue(Caracteristic caracteristic, Integer qualitativeValueId) {
        CaracteristicQualitativeValue value = null;
        for (CaracteristicQualitativeValue qv : caracteristic.getQualitativeValue()) {
            if (!qualitativeValueId.equals(qv.getIdAsInt())) continue;
            value = qv;
            break;
        }
        return value;
    }

    public static void removeQualitativeValue(Collection<CaracteristicQualitativeValue> values, int id) {
        Iterator<CaracteristicQualitativeValue> iterator = values.iterator();
        while (iterator.hasNext()) {
            CaracteristicQualitativeValue next = iterator.next();
            if (id != next.getIdAsInt()) continue;
            iterator.remove();
            break;
        }
    }

    public static <K, V> void fillEntries(Map<K, V> map, Collection<K> keys, Function<K, V> function) {
        for (K key : keys) {
            Object value = function.apply(key);
            map.put(key, value);
        }
    }

    public static <K, V> Function<K, V> newConstantFunction(final V value) {
        return new Function<K, V>(){

            public V apply(K input) {
                return value;
            }
        };
    }

    public static CaracteristicType getType(boolean isAlpha, boolean isQualitative) {
        CaracteristicType result = isAlpha ? CaracteristicType.TEXT : (isQualitative ? CaracteristicType.QUALITATIVE : CaracteristicType.NUMBER);
        return result;
    }

    public static boolean isNumberCaracteristic(Caracteristic c) {
        return CaracteristicType.NUMBER == c.getCaracteristicType();
    }

    public static boolean isTextCaracteristic(Caracteristic c) {
        return CaracteristicType.TEXT == c.getCaracteristicType();
    }

    public static boolean isQualitativeCaracteristic(Caracteristic c) {
        return CaracteristicType.QUALITATIVE == c.getCaracteristicType();
    }

    public static <E> List<E> getList(List<E> list) {
        ArrayList result = CollectionUtils.isEmpty(list) ? Lists.newArrayList() : Lists.newArrayList(list);
        return result;
    }

    public static int computeDistanceInMeters(Float startLatitude, Float startLongitude, Float endLatitude, Float endLongitude) {
        double sLat = (double)startLatitude.floatValue() * Math.PI / 180.0;
        double sLong = (double)startLongitude.floatValue() * Math.PI / 180.0;
        double eLat = (double)endLatitude.floatValue() * Math.PI / 180.0;
        double eLong = (double)endLongitude.floatValue() * Math.PI / 180.0;
        Double d = 6378288.0 * (1.5707963267948966 - Math.asin(Math.sin(eLat) * Math.sin(sLat) + Math.cos(eLong - sLong) * Math.cos(eLat) * Math.cos(sLat)));
        return d.intValue();
    }

    public static String getDistanceInMilles(Float distance) {
        String distanceText;
        if (distance != null) {
            Float distanceInMilles = Float.valueOf(distance.floatValue() / 1852.0f);
            distanceText = String.format("%.3f", distanceInMilles);
        } else {
            distanceText = "";
        }
        return distanceText;
    }

    public static float getRoundedLengthStep(float lengthStep, boolean aroundUp) {
        int intValue = (int)((lengthStep + (aroundUp ? 0.001f : 0.0f)) * 10.0f);
        float result = (float)intValue / 10.0f;
        return result;
    }

    public static DecimalFormatSymbols getDecimalFormatSymbols() {
        if (symbols == null) {
            symbols = new DecimalFormatSymbols();
            symbols.setDecimalSeparator('.');
            symbols.setGroupingSeparator(' ');
        }
        return symbols;
    }

    public static DecimalFormat getDecimalFormat(int minDecimal, int maxDecimal) {
        if (decimalFormat == null) {
            decimalFormat = new DecimalFormat();
            decimalFormat.setDecimalFormatSymbols(TuttiEntities.getDecimalFormatSymbols());
            decimalFormat.setGroupingUsed(false);
        }
        decimalFormat.setMinimumFractionDigits(minDecimal);
        decimalFormat.setMaximumFractionDigits(maxDecimal);
        return decimalFormat;
    }

    public static String getWeightStringValue(Float weight) {
        String textValue;
        if (weight != null) {
            DecimalFormat weightDecimalFormat = TuttiEntities.getDecimalFormat(1, 3);
            textValue = weightDecimalFormat.format(weight);
        } else {
            textValue = "";
        }
        return textValue;
    }

    public static <N extends Number> N getValueOrComputedValue(N value, N computedValue) {
        return value == null ? computedValue : value;
    }

    public static <N extends Number> Boolean getValueOrComputedValueComputed(N value, N computedValue) {
        Boolean result = value == null ? (computedValue == null ? null : Boolean.valueOf(true)) : Boolean.valueOf(false);
        return result;
    }

    public static float roundKiloGram(float value) {
        BigDecimal sumB = new BigDecimal(value);
        float result = sumB.abs(MATH_CONTEXT_4_DIGIT).floatValue();
        return result;
    }

    protected static class SpeciesAbleBatchCategoryPredicate
    implements Predicate<SpeciesAbleBatch> {
        private final Integer id;
        private final Integer qualitativeValue;

        public SpeciesAbleBatchCategoryPredicate(Integer id, Integer qualitativeValue) {
            this.id = id;
            this.qualitativeValue = qualitativeValue;
        }

        public boolean apply(SpeciesAbleBatch input) {
            return this.id.equals(input.getSampleCategoryId()) && input.getSampleCategoryValue() instanceof CaracteristicQualitativeValue && this.qualitativeValue.equals(((CaracteristicQualitativeValue)input.getSampleCategoryValue()).getIdAsInt());
        }
    }

    protected static class CaracteristicQualitativeValuePredicate
    implements Predicate<CaracteristicQualitativeValue> {
        private final Integer id;

        public CaracteristicQualitativeValuePredicate(Integer id) {
            this.id = id;
        }

        public boolean apply(CaracteristicQualitativeValue input) {
            return this.id.equals(input.getIdAsInt());
        }
    }

    protected static class SampleCategoryCaracteristicPredicate
    implements Predicate<Caracteristic> {
        protected SampleCategoryCaracteristicPredicate() {
        }

        public boolean apply(Caracteristic input) {
            return !CaracteristicType.TEXT.equals((Object)input.getCaracteristicType());
        }
    }

    protected static class IdPredicate<B extends TuttiEntity>
    implements Predicate<B> {
        private final String id;

        public IdPredicate(String id) {
            this.id = id;
        }

        public boolean apply(B input) {
            return this.id.equals(input.getId());
        }
    }
}

