/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.ArithmeticEngine;
import freemarker.core.Environment;
import freemarker.core.EvaluationUtil;
import freemarker.core.Expression;
import freemarker.core.NonNumericalException;
import freemarker.template.SimpleNumber;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateNumberModel;

final class ArithmeticExpression
extends Expression {
    static final int SUBSTRACTION = 0;
    static final int MULTIPLICATION = 1;
    static final int DIVISION = 2;
    static final int MODULUS = 3;
    private static final char[] OPERATORS = new char[]{'-', '*', '/', '%'};
    private final Expression left;
    private final Expression right;
    private final int operation;

    ArithmeticExpression(Expression left, Expression right, int operation) {
        this.left = left;
        this.right = right;
        this.operation = operation;
    }

    TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
        boolean bothNumbers;
        TemplateModel leftModel = this.left.getAsTemplateModel(env);
        TemplateModel rightModel = this.right.getAsTemplateModel(env);
        boolean leftIsNumber = leftModel instanceof TemplateNumberModel;
        boolean rightIsNumber = rightModel instanceof TemplateNumberModel;
        boolean bl = bothNumbers = leftIsNumber && rightIsNumber;
        if (!bothNumbers) {
            String msg = "Error " + this.getStartLocation();
            if (!leftIsNumber) {
                msg = msg + "\nExpression " + this.left + " is not numerical";
            }
            if (!rightIsNumber) {
                msg = msg + "\nExpression " + this.right + " is not numerical";
            }
            throw new NonNumericalException(msg, env);
        }
        Number first = EvaluationUtil.getNumber(leftModel, this.left, env);
        Number second = EvaluationUtil.getNumber(rightModel, this.right, env);
        ArithmeticEngine ae = env != null ? env.getArithmeticEngine() : this.getTemplate().getArithmeticEngine();
        switch (this.operation) {
            case 0: {
                return new SimpleNumber(ae.subtract(first, second));
            }
            case 1: {
                return new SimpleNumber(ae.multiply(first, second));
            }
            case 2: {
                return new SimpleNumber(ae.divide(first, second));
            }
            case 3: {
                return new SimpleNumber(ae.modulus(first, second));
            }
        }
        throw new TemplateException("unknown operation : " + this.operation, env);
    }

    public String getCanonicalForm() {
        return this.left.getCanonicalForm() + ' ' + OPERATORS[this.operation] + ' ' + this.right.getCanonicalForm();
    }

    boolean isLiteral() {
        return this.constantValue != null || this.left.isLiteral() && this.right.isLiteral();
    }

    Expression _deepClone(String name, Expression subst) {
        return new ArithmeticExpression(this.left.deepClone(name, subst), this.right.deepClone(name, subst), this.operation);
    }
}

