/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import fr.ifremer.shared.application.swing.action.AbstractApplicationAction;
import fr.ifremer.shared.application.type.ApplicationProgressionModel;
import fr.ifremer.tutti.TuttiConfiguration;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.ui.swing.TuttiApplicationUpdaterCallBack;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.action.CloseApplicationAction;
import fr.ifremer.tutti.ui.swing.content.MainUI;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.updater.ApplicationUpdater;
import org.nuiton.updater.ApplicationUpdaterCallback;
import org.nuiton.updater.DownloadMonitor;

public class UpdateApplicationAction
extends AbstractTuttiAction<TuttiUIContext, MainUI, MainUIHandler> {
    private static final Log log = LogFactory.getLog(UpdateApplicationAction.class);
    protected TuttiApplicationUpdaterCallBack.UpdateType[] types;
    protected boolean reload;

    public UpdateApplicationAction(MainUIHandler handler) {
        super(handler, true);
        this.setActionDescription(I18n._((String)"tutti.main.action.updateApplication.tip", (Object[])new Object[0]));
        this.types = TuttiApplicationUpdaterCallBack.UpdateType.values();
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            TuttiUIContext context = this.getContext();
            doAction = context.checkUpdateApplicationReachable(true);
        }
        return doAction;
    }

    public void releaseAction() {
        super.releaseAction();
        this.types = TuttiApplicationUpdaterCallBack.UpdateType.values();
    }

    @Override
    public void doAction() throws Exception {
        this.reload = false;
        TuttiUIContext context = this.getContext();
        TuttiConfiguration config = this.getConfig();
        File current = config.getBasedir();
        if (current == null || !current.exists()) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"No application base directory defined, skip updates.");
            }
        } else {
            String url = config.getUpdateApplicationUrl();
            File dest = new File(config.getBasedir(), "NEW");
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Try to update jre, i18N, help or tutti (current application location: %s), using update url: %s", current, url));
            }
            ProgressionModel progressionModel = new ProgressionModel();
            context.getActionUI().getModel().setProgressionModel((ApplicationProgressionModel)progressionModel);
            progressionModel.setMessage(I18n._((String)"tutti.updateApplication.checkUpdates", (Object[])new Object[0]));
            TuttiApplicationUpdaterCallBack callback = new TuttiApplicationUpdaterCallBack(this, progressionModel);
            callback.setTypes(this.types);
            ApplicationUpdater up = new ApplicationUpdater();
            up.update(url, current, dest, false, (ApplicationUpdaterCallback)callback, (DownloadMonitor)progressionModel);
            if (callback.isApplicationUpdated()) {
                this.reload = true;
            } else {
                this.sendMessage(I18n._((String)"tutti.updateApplication.noUpdate", (Object[])new Object[0]));
            }
        }
    }

    public void setTypes(TuttiApplicationUpdaterCallBack.UpdateType ... types) {
        this.types = types;
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        if (this.reload) {
            block3: {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)"Could not wait 1 second...", (Throwable)e);
                }
            }
            ((MainUIHandler)this.getHandler()).showSuccessMessage(I18n._((String)"tutti.updateApplication.title.success", (Object[])new Object[0]), I18n._((String)"tutti.updateApplication.message.success", (Object[])new Object[0]));
            CloseApplicationAction action = (CloseApplicationAction)this.getContext().getActionFactory().createLogicAction(this.getHandler(), CloseApplicationAction.class);
            action.setExitCode(88);
            this.getActionEngine().runAction((AbstractApplicationAction)action);
        }
    }

    public boolean isReload() {
        return this.reload;
    }
}

