/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.protocol.ProtocolImportExportService;
import fr.ifremer.tutti.ui.swing.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUI;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUIHandler;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUIModel;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ExportProtocolAction
extends AbstractTuttiAction<SelectCruiseUIModel, SelectCruiseUI, SelectCruiseUIHandler> {
    private static final Log log = LogFactory.getLog(ExportProtocolAction.class);
    protected File file;

    public ExportProtocolAction(SelectCruiseUIHandler handler) {
        super(handler, true);
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            TuttiProtocol protocol = ((SelectCruiseUIModel)this.getModel()).getProtocol();
            this.file = this.saveFile("protocol-" + protocol.getName().replaceAll(" ", "_"), "tuttiProtocol", I18n._((String)"tutti.selectCruise.title.choose.exportFile", (Object[])new Object[0]), I18n._((String)"tutti.selectCruise.action.exportProtocol", (Object[])new Object[0]), new String[]{"^.+\\.tuttiProtocol$", I18n._((String)"tutti.common.file.protocol", (Object[])new Object[0])});
            doAction = this.file != null;
        }
        return doAction;
    }

    public void releaseAction() {
        this.file = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        TuttiProtocol protocol = ((SelectCruiseUIModel)this.getModel()).getProtocol();
        Preconditions.checkNotNull((Object)protocol);
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will save protocol " + protocol.getId() + " to file: " + this.file));
        }
        ProtocolImportExportService service = this.getContext().getTuttiProtocolImportExportService();
        service.exportProtocol(protocol, this.file);
        ((SelectCruiseUIHandler)this.getHandler()).resetEditProtolAction();
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        TuttiProtocol protocol = ((SelectCruiseUIModel)this.getModel()).getProtocol();
        this.sendMessage(I18n._((String)"tutti.exportProtocol.action.success", (Object[])new Object[]{protocol.getName(), this.file.getName()}));
    }
}

