/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import com.google.common.collect.Lists;
import fr.ifremer.adagio.core.dao.data.vessel.feature.physical.VesselFeaturesImpl;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.DatabaseCheckPersistenceService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FlushMode;
import org.hibernate.Query;
import org.hibernate.classic.Session;
import org.springframework.stereotype.Service;

@Service(value="databaseCheckPersistenceService")
public class DatabaseCheckPersistenceServiceImpl
extends AbstractPersistenceService
implements DatabaseCheckPersistenceService {
    private static final Log log = LogFactory.getLog(DatabaseCheckPersistenceServiceImpl.class);

    @Override
    public void check() {
        this.checkVesselFeatures();
    }

    public void checkVesselFeatures() {
        Session currentSession = this.getCurrentSession();
        Query query = currentSession.createQuery("SELECT vessel.code FROM " + VesselFeaturesImpl.class.getName() + " WHERE endDateTime IS NULL GROUP BY vessel.code HAVING COUNT(id)>1");
        List vesselCodes = query.list();
        if (CollectionUtils.isEmpty((Collection)vesselCodes)) {
            if (log.isInfoEnabled()) {
                log.info((Object)"vesselFeatures are sane");
            }
            return;
        }
        for (String vesselCode : vesselCodes) {
            Query query1 = currentSession.createQuery("SELECT id FROM " + VesselFeaturesImpl.class.getName() + " WHERE endDateTime IS NULL AND vessel.code = :vesselCode ORDER BY startDateTime DESC");
            query1.setString("vesselCode", vesselCode);
            ArrayList vesselFeaturesIds = Lists.newArrayList((Iterable)query1.list());
            vesselFeaturesIds.remove(0);
            if (log.isInfoEnabled()) {
                log.info((Object)("Remove vesselFeature with id: " + vesselFeaturesIds));
            }
            currentSession.createQuery("DELETE FROM " + VesselFeaturesImpl.class.getName() + " WHERE id in :id").setParameterList("id", (Collection)vesselFeaturesIds).executeUpdate();
        }
        this.getCurrentSession().setFlushMode(FlushMode.COMMIT);
        this.getCurrentSession().flush();
    }
}

