/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.shared.application;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import fr.ifremer.shared.application.ApplicationTechnicalException;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.VFS;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ZipUtil;

public class ApplicationIOUtil {
    protected ApplicationIOUtil() {
    }

    public static void close(Closeable toClose, String errorMessage) {
        try {
            toClose.close();
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException(errorMessage, e);
        }
    }

    public static void zip(File source, File archiveFile, String errorMessage) {
        try {
            ZipUtil.compress((File)archiveFile, (File)source);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException(errorMessage, e);
        }
    }

    public static void zip(File source, File archiveFile, List<File> files, String errorMessage) {
        try {
            ZipUtil.compressFiles((File)archiveFile, (File)source, files);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException(I18n._((String)errorMessage, (Object[])new Object[]{archiveFile}), e);
        }
    }

    public static FileObject resolveFile(String file, String errorMessage) {
        try {
            FileSystemManager manager = VFS.getManager();
            FileObject targetObject = manager.resolveFile(file);
            return targetObject;
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException(errorMessage, e);
        }
    }

    public static FileObject[] getChildren(FileObject objectFile, String errorMessage) {
        try {
            return objectFile.getChildren();
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException(errorMessage, e);
        }
    }

    public static FileObject getChild(FileObject objectFile, String name, String errorMessage) {
        try {
            return objectFile.getChild(name);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException(errorMessage, e);
        }
    }

    public static FileType getType(FileObject objectFile, String errorMessage) {
        try {
            return objectFile.getType();
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException(errorMessage, e);
        }
    }

    public static void explode(FileObject archiveFile, File target, FileSelector fileSelector, String errorMessage) {
        try {
            FileSystemManager manager = VFS.getManager();
            FileObject targetObject = manager.toFileObject(target);
            targetObject.copyFrom(archiveFile, fileSelector);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException(errorMessage, e);
        }
    }

    public static void forceMkdir(File dir, String errorMessage) {
        try {
            FileUtils.forceMkdir((File)dir);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException(errorMessage, e);
        }
    }

    public static void cleanDirectory(File dir, String errorMessage) {
        try {
            FileUtils.cleanDirectory((File)dir);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException(errorMessage, e);
        }
    }

    public static void deleteDirectory(File dir, String errorMessage) {
        try {
            FileUtils.deleteDirectory((File)dir);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException(errorMessage, e);
        }
    }

    public static void forceDeleteOnExit(File dir, String errorMessage) {
        try {
            FileUtils.forceDeleteOnExit((File)dir);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException(errorMessage, e);
        }
    }

    public static void copyDirectory(File source, File target, String errorMessage) {
        try {
            FileUtils.copyDirectory((File)source, (File)target);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException(errorMessage, e);
        }
    }

    public static void copyFileToDirectory(File source, File target, String errorMessage) {
        try {
            FileUtils.copyFileToDirectory((File)source, (File)target);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException(errorMessage, e);
        }
    }

    public static void copyFile(File source, File target, String errorMessage) {
        try {
            FileUtils.copyFile((File)source, (File)target);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException(errorMessage, e);
        }
    }

    public static void deleteFile(File file, String errorMessage) {
        try {
            FileUtils.forceDelete((File)file);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException(errorMessage, e);
        }
    }

    public static String getBaseName(String file) {
        return FilenameUtils.getBaseName((String)file);
    }

    public static String getExtension(String file) {
        return FilenameUtils.getExtension((String)file);
    }

    public static Reader newReader(File file, String errorMessage) {
        try {
            return Files.newReader((File)file, (Charset)Charsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            throw new ApplicationTechnicalException(I18n._((String)errorMessage, (Object[])new Object[]{file}), e);
        }
    }

    public static Writer newWriter(File file, String errorMessage) {
        try {
            return Files.newWriter((File)file, (Charset)Charsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            throw new ApplicationTechnicalException(I18n._((String)errorMessage, (Object[])new Object[]{file}), e);
        }
    }

    public static File explodeZip(File rootDirectory, File file, String errorMessage) {
        File tempDir = new File(rootDirectory, UUID.randomUUID().toString());
        try {
            ZipUtil.uncompress((File)file, (File)tempDir);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException(I18n._((String)errorMessage, (Object[])new Object[]{file}), e);
        }
        return tempDir;
    }

    public static String readContent(File file, String errorMessage) {
        try {
            return Files.readFirstLine((File)file, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException(errorMessage, e);
        }
    }

    public static void writeContent(File file, String content, String errorMessage) {
        try {
            FileUtils.write((File)file, (CharSequence)content, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException(errorMessage, e);
        }
    }
}

