/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.updater;

import com.google.common.collect.Maps;
import java.io.BufferedInputStream;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.provider.http.HttpFileSystemConfigBuilder;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.updater.ApplicationInfo;
import org.nuiton.updater.ApplicationUpdater;
import org.nuiton.util.VersionUtil;

public abstract class AbstractApplicationUpdaterAction
implements Runnable {
    private static final Log log = LogFactory.getLog(AbstractApplicationUpdaterAction.class);
    public static final String HTTP_PROXY = "http_proxy";
    public static final String URL_KEY = "url";
    public static final String AUTHENTICATION_KEY = "auth";
    public static final String VERSION_KEY = "version";
    protected ApplicationConfig config;
    protected String vfsPropertiesUrl;
    protected File currentDir;

    public AbstractApplicationUpdaterAction(ApplicationConfig config, String vfsPropertiesUrl, File currentDir) {
        this.config = config;
        this.vfsPropertiesUrl = vfsPropertiesUrl;
        this.currentDir = currentDir;
    }

    protected Map<String, ApplicationInfo> getVersions(ApplicationConfig releaseConfig, boolean allVersion, File destDir) {
        List<String> appNames = this.getApplicationName(releaseConfig);
        Map<String, String> appVersions = this.getCurrentVersion(appNames, this.currentDir);
        log.debug((Object)("application current version: " + appVersions));
        HashMap<String, ApplicationInfo> appToUpdate = new HashMap<String, ApplicationInfo>();
        for (String app : appNames) {
            String currentVersion = appVersions.get(app);
            String newVersion = releaseConfig.getOption(app + "." + VERSION_KEY);
            boolean greater = VersionUtil.greaterThan((String)newVersion, (String)currentVersion);
            log.debug((Object)String.format("for %s Current(%s) < newVersion(%s) ? %s", app, currentVersion, newVersion, greater));
            boolean add = allVersion || greater;
            if (!add) continue;
            String urlString = releaseConfig.getOption(app + "." + URL_KEY);
            boolean needAuthentication = releaseConfig.getOptionAsBoolean(app + "." + AUTHENTICATION_KEY);
            if (allVersion && !greater) {
                newVersion = null;
            }
            appToUpdate.put(app, new ApplicationInfo(app, currentVersion, newVersion, urlString, destDir, needAuthentication));
        }
        return appToUpdate;
    }

    protected String toVfsURL(String path) {
        String result = path;
        Pattern p = Pattern.compile("(.*?file:)([^/][^!]*)(.*)");
        Matcher m = p.matcher(path);
        if (m.matches()) {
            String filepath = m.group(2);
            File f = new File(filepath);
            result = path.replaceAll("(.*?file:)([^/][^!]*)(.*)", "$1" + f.getAbsolutePath() + "$3");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ApplicationConfig getUpdaterConfig(FileSystemOptions vfsConfig, String vfsPropertiesUrl) throws Exception {
        String osName = StringUtils.lowerCase((String)this.config.getOsName());
        String osArch = StringUtils.lowerCase((String)this.config.getOsArch());
        osName = StringUtils.substringBefore((String)osName, (String)" ");
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Try to load properties from '%s'", vfsPropertiesUrl));
        }
        Properties prop = new Properties();
        FileSystemManager fsManager = VFS.getManager();
        FileObject properties = fsManager.resolveFile(this.toVfsURL(vfsPropertiesUrl), vfsConfig);
        try {
            BufferedInputStream in = new BufferedInputStream(properties.getContent().getInputStream());
            prop.load(in);
        }
        finally {
            try {
                properties.close();
            }
            catch (Exception doNothing) {
                log.debug((Object)"Can't close vfs file", (Throwable)doNothing);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Properties loaded from '%s'\n%s", vfsPropertiesUrl, prop));
        }
        ApplicationConfig result = new ApplicationConfig(prop);
        result = result.getSubConfig(ApplicationUpdater.class.getSimpleName() + ".");
        result = result.getSubConfig(osName + ".");
        result = result.getSubConfig(osArch + ".");
        return result;
    }

    protected FileSystemOptions getVFSConfig(ApplicationConfig config) {
        FileSystemOptions result = new FileSystemOptions();
        String proxyHost = config.getOption(HTTP_PROXY);
        try {
            proxyHost = StringUtils.substringAfter((String)proxyHost, (String)"://");
            if (StringUtils.isNotBlank((CharSequence)proxyHost)) {
                String hostname = StringUtils.substringBefore((String)proxyHost, (String)":");
                String port = StringUtils.substringAfter((String)proxyHost, (String)":");
                if (StringUtils.isNumeric((CharSequence)port)) {
                    int portNumber = Integer.parseInt(port);
                    HttpFileSystemConfigBuilder.getInstance().setProxyHost(result, hostname);
                    HttpFileSystemConfigBuilder.getInstance().setProxyPort(result, portNumber);
                } else {
                    log.warn((Object)String.format("Invalide proxy port number '%s', not used proxy", port));
                }
            }
        }
        catch (Exception eee) {
            log.warn((Object)String.format("Can't use proxy '%s'", proxyHost), (Throwable)eee);
        }
        return result;
    }

    protected Map<String, String> getCurrentVersion(List<String> apps, File dir) {
        TreeMap result = Maps.newTreeMap();
        for (String app : apps) {
            File applicationDirectory = new File(dir, app);
            String version = ApplicationUpdater.loadVersionFile(app, applicationDirectory);
            result.put(app, version);
        }
        return result;
    }

    protected List<String> getApplicationName(ApplicationConfig config) {
        Pattern p = Pattern.compile("([^.]+)\\.version");
        LinkedList<String> result = new LinkedList<String>();
        for (String v : config.getFlatOptions().stringPropertyNames()) {
            Matcher match = p.matcher(v);
            if (match.matches()) {
                result.add(match.group(1));
                continue;
            }
            if (!StringUtils.endsWith((CharSequence)v, (CharSequence)".version")) continue;
            log.debug((Object)String.format("value is not valid application version '%s'", v));
        }
        return result;
    }
}

