/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches;

import fr.ifremer.tutti.persistence.entities.data.SpeciesAbleBatch;
import fr.ifremer.tutti.service.TuttiDecorator;
import java.util.List;
import javax.swing.SortOrder;
import org.jdesktop.swingx.JXTable;
import org.nuiton.decorator.JXPathDecorator;

public class SpeciesBatchDecoratorComparator<R extends SpeciesAbleBatch>
extends TuttiDecorator.TuttiDecoratorComparator<R> {
    private static final long serialVersionUID = 1L;
    JXTable table;

    public SpeciesBatchDecoratorComparator(String expression, JXTable table) {
        super(expression);
        this.table = table;
    }

    public void init(JXPathDecorator<R> decorator, List<R> datas) {
        this.clear();
        int index = 0;
        for (SpeciesAbleBatch data : datas) {
            String speciesText = decorator.toString((Object)data);
            RowComparatorContext value = new RowComparatorContext(this.table, speciesText, index++);
            this.valueCache.put(data, value);
        }
    }

    static class RowComparatorContext
    implements Comparable<RowComparatorContext> {
        private final String speciesText;
        private final int rowIndex;
        private final JXTable table;

        RowComparatorContext(JXTable table, String speciesText, int rowIndex) {
            this.table = table;
            this.speciesText = speciesText;
            this.rowIndex = rowIndex;
        }

        @Override
        public int compareTo(RowComparatorContext o) {
            int result = this.speciesText.compareTo(o.speciesText);
            if (result == 0) {
                int sortedColumnIndex = this.table.getSortedColumnIndex();
                SortOrder sortOrder = this.table.getSortOrder(sortedColumnIndex);
                switch (sortOrder) {
                    case UNSORTED: 
                    case ASCENDING: {
                        result = this.rowIndex - o.rowIndex;
                        break;
                    }
                    case DESCENDING: {
                        result = o.rowIndex - this.rowIndex;
                    }
                }
            }
            return result;
        }
    }
}

