/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.catches;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.tutti.TuttiBusinessException;
import fr.ifremer.tutti.TuttiTechnicalException;
import fr.ifremer.tutti.persistence.InvalidBatchModelException;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocols;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiDataContext;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.ValidationService;
import fr.ifremer.tutti.service.catches.WeightComputingService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.validator.NuitonValidatorResult;
import org.nuiton.validator.NuitonValidatorScope;

public class ValidateCruiseOperationsService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(ValidateCruiseOperationsService.class);
    protected PersistenceService persistenceService;
    protected ValidationService validationService;
    protected WeightComputingService weightComputingService;
    protected DecoratorService decoratorService;
    protected SampleCategoryModel sampleCategoryModel;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.validationService = this.getService(ValidationService.class);
        this.weightComputingService = this.getService(WeightComputingService.class);
        this.decoratorService = this.getService(DecoratorService.class);
        this.sampleCategoryModel = context.getSampleCategoryModel();
    }

    public Map<FishingOperation, NuitonValidatorResult> validateCruiseOperations(ProgressionModel progressionModel) {
        HashMap result = Maps.newHashMap();
        TuttiDataContext dataContext = this.context.getDataContext();
        List<FishingOperation> operations = this.persistenceService.getAllFishingOperation(dataContext.getCruiseId());
        progressionModel.setTotal(operations.size());
        Decorator<FishingOperation> decorator = this.decoratorService.getDecoratorByType(FishingOperation.class);
        for (FishingOperation operation : operations) {
            operation = this.persistenceService.getFishingOperation(operation.getId());
            progressionModel.setMessage(I18n._((String)"tutti.service.validateCruise.operations.progress", (Object[])new Object[]{decorator.toString((Object)operation)}));
            NuitonValidatorResult validator = this.validationService.validateFishingOperation(operation, "validate");
            this.checkOperation(operation, validator);
            result.put(operation, validator);
            progressionModel.increments(1);
        }
        return result;
    }

    public NuitonValidatorResult validateCruiseOperation(FishingOperation operation) {
        NuitonValidatorResult validator = this.validationService.validateFishingOperation(operation, "validate");
        this.checkOperation(operation, validator);
        return validator;
    }

    public NuitonValidatorResult validateCruiseOperation(CatchBatch catches) {
        FishingOperation operation = this.persistenceService.getFishingOperation(catches.getFishingOperation().getId());
        NuitonValidatorResult validator = this.validationService.validateFishingOperation(operation, "validate");
        this.checkOperation(operation, catches, validator);
        return validator;
    }

    public void exportValidationResults(File file, Map<FishingOperation, NuitonValidatorResult> validationResults) {
        try {
            ArrayList lines = Lists.newArrayList();
            for (FishingOperation operation : validationResults.keySet()) {
                lines.addAll(this.getExportLines(operation, validationResults.get(operation)));
                lines.add("");
            }
            FileUtils.writeLines((File)file, (Collection)lines);
        }
        catch (IOException e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.validateCruise.exportResult.error", (Object[])new Object[]{file}));
        }
    }

    public void exportValidationResult(File file, FishingOperation operation, NuitonValidatorResult validationResult) {
        try {
            List<String> lines = this.getExportLines(operation, validationResult);
            FileUtils.writeLines((File)file, lines);
        }
        catch (IOException e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.validateCruise.exportResult.error", (Object[])new Object[]{file}));
        }
    }

    protected void checkOperation(FishingOperation fishingOperation, NuitonValidatorResult validator) {
        String fishingOperationId = fishingOperation.getId();
        boolean withCatchBatch = this.persistenceService.isFishingOperationWithCatchBatch(fishingOperationId);
        if (!withCatchBatch) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Skip fishing operation " + fishingOperation + " since no catchBatch associated."));
            }
            HashMap errorMap = Maps.newHashMap();
            errorMap.put("catches", Lists.newArrayList((Object[])new String[]{I18n._((String)"tutti.validator.warning.fishingOperation.batch.notFound", (Object[])new Object[0])}));
            validator.addMessagesForScope(NuitonValidatorScope.WARNING, (Map)errorMap);
        } else {
            try {
                CatchBatch catchBatch = this.persistenceService.getCatchBatchFromFishingOperation(fishingOperationId);
                this.checkOperation(fishingOperation, catchBatch, validator);
            }
            catch (InvalidBatchModelException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Invalid batch model", (Throwable)e);
                }
                HashMap errorMap = Maps.newHashMap();
                errorMap.put("catches", Lists.newArrayList((Object[])new String[]{I18n._((String)"tutti.validator.warning.fishingOperation.invalid.batch.model", (Object[])new Object[0])}));
                validator.addMessagesForScope(NuitonValidatorScope.WARNING, (Map)errorMap);
            }
        }
    }

    protected void checkOperation(FishingOperation fishingOperation, CatchBatch catchBatch, NuitonValidatorResult validator) {
        BatchContainer<MarineLitterBatch> rootMarineLitterBatch;
        boolean error;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will check fishingOperation: " + fishingOperation));
        }
        ArrayList errors = Lists.newArrayList();
        String fishingOperationId = fishingOperation.getId();
        BatchContainer<SpeciesBatch> rootSpeciesBatch = null;
        boolean isCatchBatch = this.persistenceService.isFishingOperationWithCatchBatch(fishingOperationId);
        boolean bl = error = !isCatchBatch;
        if (isCatchBatch && (rootSpeciesBatch = this.persistenceService.getRootSpeciesBatch(fishingOperationId, this.sampleCategoryModel)) != null) {
            List roots = rootSpeciesBatch.getChildren();
            for (SpeciesBatch batch : roots) {
                try {
                    this.weightComputingService.computeSpeciesBatch(batch);
                }
                catch (TuttiBusinessException e) {
                    errors.add(e.getMessage());
                    error = true;
                }
            }
        }
        if (error) {
            rootSpeciesBatch = this.persistenceService.getRootSpeciesBatch(fishingOperationId, this.sampleCategoryModel);
        }
        BatchContainer<BenthosBatch> rootBenthosBatch = null;
        error = false;
        if (isCatchBatch && (rootBenthosBatch = this.persistenceService.getRootBenthosBatch(fishingOperationId, this.sampleCategoryModel)) != null) {
            List roots = rootBenthosBatch.getChildren();
            for (BenthosBatch batch : roots) {
                try {
                    this.weightComputingService.computeBenthosBatch(batch);
                }
                catch (TuttiBusinessException e) {
                    errors.add(e.getMessage());
                    error = true;
                }
            }
        }
        if (error) {
            rootBenthosBatch = this.persistenceService.getRootBenthosBatch(fishingOperationId, this.sampleCategoryModel);
        }
        try {
            Float weight = catchBatch == null ? null : catchBatch.getMarineLitterTotalWeight();
            rootMarineLitterBatch = this.weightComputingService.getComputedMarineLitterBatches(fishingOperationId, weight);
        }
        catch (TuttiBusinessException e) {
            errors.add(e.getMessage());
            rootMarineLitterBatch = this.persistenceService.getRootMarineLitterBatch(fishingOperationId);
        }
        try {
            if (catchBatch != null) {
                this.weightComputingService.computeCatchBatchWeights(catchBatch, rootSpeciesBatch, rootBenthosBatch, rootMarineLitterBatch);
            }
        }
        catch (TuttiBusinessException e) {
            errors.add(e.getMessage());
        }
        HashMap errorMap = Maps.newHashMap();
        errorMap.put("catches", errors);
        validator.addMessagesForScope(NuitonValidatorScope.ERROR, (Map)errorMap);
        TuttiDataContext dataContext = this.context.getDataContext();
        if (dataContext.isProtocolFilled()) {
            String categoryValue;
            String species;
            HashMap warningMap = Maps.newHashMap();
            Decorator<Species> speciesDecorator = this.decoratorService.getDecoratorByType(Species.class);
            if (rootSpeciesBatch != null) {
                for (SpeciesBatch batch : rootSpeciesBatch.getChildren()) {
                    if (!this.isSpeciesBatchInvalid(batch)) continue;
                    species = speciesDecorator.toString((Object)batch.getSpecies());
                    categoryValue = this.decoratorService.getDecorator(batch.getSampleCategoryValue()).toString((Object)batch.getSampleCategoryValue());
                    warningMap.put("species", Lists.newArrayList((Object[])new String[]{I18n._((String)"tutti.validator.warning.species.protocolNotRespected", (Object[])new Object[]{species, categoryValue})}));
                    break;
                }
            }
            if (rootBenthosBatch != null) {
                for (SpeciesBatch batch : rootBenthosBatch.getChildren()) {
                    if (!this.isBenthosBatchInvalid((BenthosBatch)batch)) continue;
                    species = speciesDecorator.toString((Object)batch.getSpecies());
                    categoryValue = this.decoratorService.getDecorator(batch.getSampleCategoryValue()).toString((Object)batch.getSampleCategoryValue());
                    warningMap.put("benthos", Lists.newArrayList((Object[])new String[]{I18n._((String)"tutti.validator.warning.benthos.protocolNotRespected", (Object[])new Object[]{species, categoryValue})}));
                    break;
                }
            }
            validator.addMessagesForScope(NuitonValidatorScope.WARNING, (Map)warningMap);
        }
    }

    public boolean isSpeciesBatchValid(SpeciesBatch batch, List<SpeciesBatchFrequency> frequencies) {
        List speciesProtocols;
        Species species;
        SpeciesProtocol speciesProtocol;
        boolean result = true;
        TuttiProtocol protocol = this.persistenceService.getProtocol();
        if (protocol != null && (speciesProtocol = TuttiProtocols.getSpeciesProtocol((Species)(species = batch.getSpecies()), (List)(speciesProtocols = protocol.getSpecies()))) != null) {
            List mandatoryCategories = speciesProtocol.getMandatorySampleCategoryId();
            SpeciesBatch browsingBatch = batch;
            while (browsingBatch.getParentBatch() != null) {
                mandatoryCategories.remove(browsingBatch.getSampleCategoryId());
                browsingBatch = browsingBatch.getParentBatch();
            }
            result = mandatoryCategories.isEmpty() && (!speciesProtocol.isCountIfNoFrequencyEnabled() || CollectionUtils.isNotEmpty(frequencies) || batch.getNumber() != null);
        }
        return result;
    }

    protected boolean isSpeciesBatchInvalid(SpeciesBatch batch) {
        if (batch.isChildBatchsEmpty()) {
            List<SpeciesBatchFrequency> frequencies = this.persistenceService.getAllSpeciesBatchFrequency(batch.getId());
            return !this.isSpeciesBatchValid(batch, frequencies);
        }
        for (SpeciesBatch child : batch.getChildBatchs()) {
            boolean invalid = this.isSpeciesBatchInvalid(child);
            if (!invalid) continue;
            return true;
        }
        return false;
    }

    protected boolean isBenthosBatchInvalid(BenthosBatch batch) {
        if (batch.isChildBatchsEmpty()) {
            List<BenthosBatchFrequency> frequencies = this.persistenceService.getAllBenthosBatchFrequency(batch.getId());
            return !this.isBenthosBatchValid(batch, frequencies);
        }
        for (BenthosBatch child : batch.getChildBatchs()) {
            boolean invalid = this.isBenthosBatchInvalid(child);
            if (!invalid) continue;
            return true;
        }
        return false;
    }

    protected List<String> getExportLines(FishingOperation operation, NuitonValidatorResult validationResult) {
        ArrayList lines = Lists.newArrayList();
        lines.add(I18n._((String)"tutti.validator.export.operation", (Object[])new Object[]{this.decoratorService.getDecoratorByType(FishingOperation.class).toString((Object)operation)}));
        List messages = validationResult.getMessagesForScope(NuitonValidatorScope.ERROR);
        for (String message : messages) {
            lines.add(I18n._((String)"tutti.validator.export.message.error", (Object[])new Object[]{I18n._((String)message, (Object[])new Object[0])}));
        }
        messages = validationResult.getMessagesForScope(NuitonValidatorScope.WARNING);
        for (String message : messages) {
            lines.add(I18n._((String)"tutti.validator.export.message.warning", (Object[])new Object[]{I18n._((String)message, (Object[])new Object[0])}));
        }
        return lines;
    }

    public boolean isBenthosBatchValid(BenthosBatch batch, List<BenthosBatchFrequency> frequencies) {
        List speciesProtocols;
        Species species;
        SpeciesProtocol speciesProtocol;
        TuttiProtocol protocol = this.persistenceService.getProtocol();
        boolean result = true;
        if (protocol != null && (speciesProtocol = TuttiProtocols.getSpeciesProtocol((Species)(species = batch.getSpecies()), (List)(speciesProtocols = protocol.getBenthos()))) != null) {
            List mandatoryCategories = speciesProtocol.getMandatorySampleCategoryId();
            BenthosBatch browsingBatch = batch;
            while (browsingBatch.getParentBatch() != null) {
                mandatoryCategories.remove(browsingBatch.getSampleCategoryId());
                browsingBatch = browsingBatch.getParentBatch();
            }
            result = mandatoryCategories.isEmpty() && (!speciesProtocol.isCountIfNoFrequencyEnabled() || CollectionUtils.isNotEmpty(frequencies) || batch.getNumber() != null);
        }
        return result;
    }
}

