package fr.ifremer.tutti.ui.swing.content;

/*
 * #%L
 * Tutti :: UI
 * $Id: ShowAboutAction.java 1223 2013-09-25 13:31:19Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.8.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/ShowAboutAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.tutti.ui.swing.TuttiApplicationUpdaterCallBack;
import fr.ifremer.tutti.ui.swing.TuttiDbUpdaterCallBack;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfig;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionHelper;
import jaxx.runtime.swing.AboutPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.updater.ApplicationInfo;
import org.nuiton.updater.ApplicationUpdater;

import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import java.io.File;
import java.net.URL;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

import static org.nuiton.i18n.I18n._;

/**
 * To show about panel.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.2
 */
public class ShowAboutAction extends AbstractMainUITuttiAction {

    /** Logger. */
    private static final Log log = LogFactory.getLog(ShowAboutAction.class);

    protected AboutPanel about;

    public ShowAboutAction(MainUIHandler handler) {
        super(handler, false);
    }

    protected boolean canUpdate;

    @Override
    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();

        if (doAction) {
            // check db url is reachable
            TuttiUIContext context = getContext();
            canUpdate = context.checkUpdateApplicationReachable();
        }
//        TuttiApplicationConfig config = context.getConfig();
//        String url = config.getUpdateApplicationUrl();
//
//        try {
//            TuttiUIUtil.tryToConnectToUpdateUrl(
//                    url,
//                    n_("tutti.error.about.could.not.reach.url"));
//            canUpdate = true;
//        } catch (TuttiBusinessException e) {
//            TuttiUIContext.getErrorHelper().showWarningDialog(e.getMessage());
//            canUpdate = false;
//        }

        return doAction;
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();

        about.showInDialog(getUI(), true);

        // register on swing session
        getContext().getSwingSession().add(about);
    }

    @Override
    public void doAction() throws Exception {

        about = null;

        String iconPath = "/icons/allegro_about.png";
        String name = "tutti";
        String licensePath = "META-INF/" + name + "-LICENSE.txt";
        String thirdPartyPath = "META-INF/" + name + "-THIRD-PARTY.txt";

        about = new AboutPanel();
        about.setTitle(_("tutti.about.title"));
        about.setAboutText(_("tutti.about.message"));

        TuttiApplicationConfig config = getContext().getConfig();
        int currentYear = Calendar.getInstance().get(Calendar.YEAR);
        int inceptionYear = config.getInceptionYear();
        String years;
        if (currentYear != inceptionYear) {
            years = inceptionYear + "-" + currentYear;
        } else {
            years = inceptionYear + "";
        }

        about.setBottomText(_("tutti.about.bottomText",
                              config.getOrganizationName(),
                              years,
                              config.getVersion()));
        about.setIconPath(iconPath);
        about.setLicenseFile(licensePath);
        about.setThirdpartyFile(thirdPartyPath);
        about.buildTopPanel();

        //
        // translate tab
        //

        JScrollPane translatePane = new JScrollPane();
        JEditorPane translateArea = new JEditorPane();
        translateArea.setContentType("text/html");
        translateArea.setEditable(false);
        if (translateArea.getFont() != null) {
            translateArea.setFont(translateArea.getFont().deriveFont((float) 11));
        }

        translateArea.setBorder(null);
        File csvFile = new File(config.getI18nDirectory(), "tutti-i18n.csv");
        String translateText = _("tutti.about.translate.content", csvFile.toURI().toURL());
        translateArea.setText(translateText);
        translatePane.getViewport().add(translateArea);
        translateArea.addHyperlinkListener(new HyperlinkListener() {
            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (HyperlinkEvent.EventType.ACTIVATED == e.getEventType()) {
                    URL url = e.getURL();
                    if (log.isInfoEnabled()) {
                        log.info("edit url: " + url);
                    }
                    TuttiUIUtil.openLink(url);
                }
            }
        });

        about.getTabs().add(_("tutti.about.translate.title"), translatePane);

        if (canUpdate) {

            //
            // update tab
            //

            addUpdateTab(config);

        }
        about.init();
    }

    protected void addUpdate(Map<String, ApplicationInfo> source,
                             Map<String, ApplicationInfo> target,
                             String type) {
        ApplicationInfo info = source.get(type.toLowerCase());
        target.put(type, info);
    }

    protected void addUpdateTab(TuttiApplicationConfig config) {
        File current = config.getTuttiBasedir();
        String urlApplication = config.getUpdateApplicationUrl();
        String urlDb = config.getUpdateDbUrl();

        ApplicationUpdater up = new ApplicationUpdater();

        // get application updates
        Map<String, ApplicationInfo> applicationVersions = up.getVersions(urlApplication, current);

        // get db updates
        Map<String, ApplicationInfo> dbVersions = up.getVersions(urlDb, config.getDataDirectory());

        // create final update map
        final Map<String, ApplicationInfo> versions = Maps.newTreeMap();

        addUpdate(applicationVersions, versions, TuttiApplicationUpdaterCallBack.UpdateType.JRE.name());
        addUpdate(applicationVersions, versions, TuttiApplicationUpdaterCallBack.UpdateType.TUTTI.name());
        addUpdate(applicationVersions, versions, TuttiApplicationUpdaterCallBack.UpdateType.I18N.name());
        addUpdate(applicationVersions, versions, TuttiApplicationUpdaterCallBack.UpdateType.HELP.name());

        addUpdate(dbVersions, versions, TuttiDbUpdaterCallBack.DB_UPDATE_NAME);

        JScrollPane updatePane = new JScrollPane();
        JEditorPane updateArea = new JEditorPane();
        updateArea.setContentType("text/html");
        updateArea.setEditable(false);
        if (updateArea.getFont() != null) {
            updateArea.setFont(updateArea.getFont().deriveFont((float) 11));
        }
        updateArea.setBorder(null);

        List<String> params = Lists.newArrayList();
        for (Map.Entry<String, ApplicationInfo> entry : versions.entrySet()) {
            String appName = entry.getKey();
            ApplicationInfo info = entry.getValue();
            String oldVersion = info.oldVersion;
            String newVersion = info.newVersion;
            String i18nKey = "tutti.update." + appName.toLowerCase();
            String appLabel = _(i18nKey);

            if (log.isInfoEnabled()) {
                log.info(String.format(
                        "Module %s, version courante %s, nouvelle version %s",
                        appLabel, oldVersion, newVersion));
            }
            if (newVersion == null) {

                // no update
                params.add(_("tutti.about.update.app.noup.detail", appLabel, oldVersion));
            } else {
                // update exists
                params.add(_("tutti.about.update.app.up.detail", appLabel, oldVersion, newVersion, appName));
            }
        }

        String updateText = _("tutti.about.update.content", urlApplication, urlDb, Joiner.on("\n").join(params));
        updateArea.setText(updateText);
        updatePane.getViewport().add(updateArea);
        updateArea.addHyperlinkListener(new HyperlinkListener() {
            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (HyperlinkEvent.EventType.ACTIVATED == e.getEventType()) {
                    URL url = e.getURL();
                    if (url != null) {
                        TuttiUIUtil.openLink(url);
                    } else {
                        String appType = e.getDescription();


                        if (log.isInfoEnabled()) {
                            log.info("Open url: " + appType);
                        }
                        AbstractTuttiAction action;

                        if (TuttiDbUpdaterCallBack.DB_UPDATE_NAME.equals(appType)) {
                            UpdateDbAction logicAction = TuttiActionHelper.createLogicAction(getHandler(), UpdateDbAction.class);
                            action = logicAction;
                            if (!getContext().isDbExist()) {

                                // install db
                                action.setActionDescription(
                                        _("tutti.dbManager.action.installDb.tip"));
                            }
                        } else {

                            TuttiApplicationUpdaterCallBack.UpdateType updateType =
                                    TuttiApplicationUpdaterCallBack.UpdateType.valueOf(appType.toUpperCase());

                            UpdateApplicationAction logicAction = TuttiActionHelper.createLogicAction(getHandler(), UpdateApplicationAction.class);
                            logicAction.setTypes(updateType);
                            logicAction.setActionDescription(_("tutti.main.action.updateSpecificApplication.tip", updateType.getLabel()));
                            action = logicAction;
                        }

                        // close this dialog
                        TuttiActionHelper.runAction(about.getClose());

                        // do update
                        TuttiActionHelper.runAction(action);
                    }

                }
            }
        });
        about.getTabs().add(_("tutti.about.update.title"), updatePane);
    }

}
