/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.create;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.create.CreateIndividualObservationBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.create.CreateIndividualObservationBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.Cancelable;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.species.SelectSpeciesUI;
import fr.ifremer.tutti.ui.swing.util.species.SelectSpeciesUIModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class CreateIndividualObservationBatchUIHandler
extends AbstractTuttiUIHandler<CreateIndividualObservationBatchUIModel, CreateIndividualObservationBatchUI>
implements Cancelable {
    private static final Log log = LogFactory.getLog(CreateIndividualObservationBatchUIHandler.class);

    public CreateIndividualObservationBatchUIHandler(TuttiUI parentUi, CreateIndividualObservationBatchUI ui) {
        super(((AbstractTuttiUIHandler)parentUi.getHandler()).getContext(), ui);
    }

    @Override
    public void beforeInitUI() {
        List defaultCaracteristic = this.getDataContext().getDefaultIndividualObservationCaracteristics();
        CreateIndividualObservationBatchUIModel model = new CreateIndividualObservationBatchUIModel(defaultCaracteristic);
        ((CreateIndividualObservationBatchUI)this.ui).setContextValue(model);
        this.listModelIsModify(model);
    }

    @Override
    public void afterInitUI() {
        this.initUI(this.ui);
        this.initBeanFilterableComboBox(((CreateIndividualObservationBatchUI)this.ui).getIndividualObservationSpeciesComboBox(), Lists.newArrayList((Iterable)this.getDataContext().getReferentSpeciesWithSurveyCode()), null, "fromProtocol");
        List lengthStepCaracteristics = this.getDataContext().getLengthStepCaracteristics();
        this.initBeanFilterableComboBox(((CreateIndividualObservationBatchUI)this.ui).getIndividualObservationLengthStepCaracteristicComboBox(), Lists.newArrayList((Iterable)lengthStepCaracteristics), null);
        if (this.getDataContext().isProtocolFilled()) {
            final Map speciesProtocolMap = this.getContext().getPersistenceService().toSpeciesProtocolMap();
            final Map lengthStepCaracteristicMap = TuttiEntities.splitById(lengthStepCaracteristics);
            ((CreateIndividualObservationBatchUIModel)this.getModel()).addPropertyChangeListener("species", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    SpeciesProtocol speciesProtocol;
                    Species species = (Species)evt.getNewValue();
                    if (species != null && (speciesProtocol = (SpeciesProtocol)speciesProtocolMap.get(species.getReferenceTaxonId())) != null) {
                        String lengthStepPmfmId = speciesProtocol.getLengthStepPmfmId();
                        Caracteristic lengthStepCaracteristic = (Caracteristic)lengthStepCaracteristicMap.get(lengthStepPmfmId);
                        ((CreateIndividualObservationBatchUIModel)CreateIndividualObservationBatchUIHandler.this.getModel()).setLengthStepCaracteristic(lengthStepCaracteristic);
                    }
                }
            });
            List caracteristics = this.getDataContext().getDefaultIndividualObservationCaracteristics();
            Table configurationPanel = ((CreateIndividualObservationBatchUI)this.ui).getConfigurationPanel();
            Decorator<Caracteristic> caracteristicDecorator = this.getDecorator(Caracteristic.class, "parameterOnlyWithUnit");
            Decorator<Caracteristic> caracteristicTipDecorator = this.getDecorator(Caracteristic.class, "withUnit");
            int index = 4;
            for (Caracteristic caracteristic : caracteristics) {
                final CreateIndividualObservationBatchUIModel.CaracteristicMapPropertyEditor editorModel = ((CreateIndividualObservationBatchUIModel)this.getModel()).newCaracteristicEditor(caracteristic);
                JTextField editor = null;
                switch (caracteristic.getCaracteristicType()) {
                    case NUMBER: {
                        final NumberEditor numberEditor = new NumberEditor((JAXXContext)this.ui);
                        String name = caracteristic.getId() + "CaracteristicField";
                        numberEditor.setName(name);
                        numberEditor.setProperty("property");
                        numberEditor.setUseFloat(Boolean.valueOf(true));
                        numberEditor.setShowReset(Boolean.valueOf(true));
                        numberEditor.setBean((Object)editorModel);
                        numberEditor.setAutoPopup(Boolean.valueOf(this.getConfig().isAutoPopupNumberEditor()));
                        numberEditor.setShowPopupButton(Boolean.valueOf(this.getConfig().isShowNumberEditorButton()));
                        numberEditor.setNumberPattern("\\d{0,6}(\\.\\d{0,3})?");
                        editorModel.addPropertyChangeListener("property", new PropertyChangeListener(){

                            @Override
                            public void propertyChange(PropertyChangeEvent evt) {
                                numberEditor.setModel((Number)evt.getNewValue());
                            }
                        });
                        editor = numberEditor;
                        ((CreateIndividualObservationBatchUI)this.ui).get$objectMap().put(name, editor);
                        this.initNumberEditor(numberEditor);
                        break;
                    }
                    case QUALITATIVE: {
                        final BeanFilterableComboBox qualitativeValuesEditor = new BeanFilterableComboBox((JAXXContext)this.ui);
                        String name = caracteristic.getId() + "CaracteristicComboBox";
                        qualitativeValuesEditor.setName(name);
                        qualitativeValuesEditor.setI18nPrefix("tutti.property.");
                        qualitativeValuesEditor.setProperty("property");
                        qualitativeValuesEditor.setShowReset(Boolean.valueOf(true));
                        qualitativeValuesEditor.setBeanType(CaracteristicQualitativeValue.class);
                        qualitativeValuesEditor.setBean((Object)editorModel);
                        editorModel.addPropertyChangeListener("property", new PropertyChangeListener(){

                            @Override
                            public void propertyChange(PropertyChangeEvent evt) {
                                qualitativeValuesEditor.setSelectedItem(evt.getNewValue());
                            }
                        });
                        editor = qualitativeValuesEditor;
                        ((CreateIndividualObservationBatchUI)this.ui).get$objectMap().put(name, editor);
                        this.initBeanFilterableComboBox(qualitativeValuesEditor, Lists.newArrayList(caracteristic.getQualitativeValue()), null);
                        break;
                    }
                    case TEXT: {
                        final JTextField textField = new JTextField();
                        String name = caracteristic.getId() + "TextField";
                        editorModel.addPropertyChangeListener("property", new PropertyChangeListener(){

                            @Override
                            public void propertyChange(PropertyChangeEvent evt) {
                                textField.setText((String)evt.getNewValue());
                            }
                        });
                        textField.addKeyListener(new KeyAdapter(){

                            @Override
                            public void keyReleased(KeyEvent e) {
                                String value = textField.getText();
                                TuttiUIUtil.setProperty((Object)editorModel, "property", value);
                            }
                        });
                        editor = textField;
                        ((CreateIndividualObservationBatchUI)this.ui).get$objectMap().put(name, editor);
                        this.initTextField(textField);
                    }
                }
                JLabel jLabel = new JLabel();
                jLabel.setText(caracteristicDecorator.toString((Object)caracteristic));
                jLabel.setToolTipText(caracteristicTipDecorator.toString((Object)caracteristic));
                jLabel.setLabelFor(editor);
                jLabel.putClientProperty("help", "tutti.createIndividualObservationBatch.field.defaultCaracteristic.help");
                ((CreateIndividualObservationBatchUI)this.ui).registerHelpId(((CreateIndividualObservationBatchUI)this.ui).getBroker(), (Component)jLabel, "tutti.createIndividualObservationBatch.field.defaultCaracteristic.help");
                configurationPanel.add((Component)jLabel, (Object)new GridBagConstraints(0, index, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
                configurationPanel.add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)editor), (Object)new GridBagConstraints(1, index, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
                ++index;
            }
        }
        this.listenValidatorValid((SimpleBeanValidator)this.getValidator(), (AbstractTuttiBeanUIModel)this.getModel());
    }

    @Override
    protected JComponent getComponentToFocus() {
        return ((CreateIndividualObservationBatchUI)this.getUI()).getIndividualObservationSpeciesComboBox();
    }

    @Override
    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        this.getValidator().setBean(null);
        ((CreateIndividualObservationBatchUIModel)this.getModel()).setValid(false);
        EditCatchesUI parent = (EditCatchesUI)SwingUtil.getParentContainer((Object)this.ui, EditCatchesUI.class);
        parent.getHandler().setIndividualObservationSelectedCard("main");
    }

    @Override
    public SwingValidator<CreateIndividualObservationBatchUIModel> getValidator() {
        return ((CreateIndividualObservationBatchUI)this.ui).getValidator();
    }

    @Override
    public void cancel() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cancel UI " + this.ui));
        }
        this.closeUI(this.ui);
    }

    public void openUI(IndividualObservationBatchUIModel batchModel) {
        List speciesList;
        CreateIndividualObservationBatchUIModel model = (CreateIndividualObservationBatchUIModel)this.getModel();
        this.getValidator().setBean((Object)model);
        model.reset();
        List speciesListWithSurveyCode = this.getDataContext().getReferentSpeciesWithSurveyCode();
        EditCatchesUI parent = (EditCatchesUI)SwingUtil.getParentContainer((Object)this.ui, EditCatchesUI.class);
        List speciesRows = parent.getSpeciesTabContent().getModel().getRows();
        if (CollectionUtils.isNotEmpty(speciesRows)) {
            HashSet speciesSet = Sets.newHashSet();
            for (SpeciesBatchRowModel row : speciesRows) {
                if (!row.isBatchRoot()) continue;
                Species species = row.getSpecies();
                speciesSet.add(species);
            }
            List rows = batchModel.getRows();
            if (CollectionUtils.isNotEmpty(rows)) {
                for (IndividualObservationBatchRowModel row : rows) {
                    Species species = row.getSpecies();
                    speciesSet.add(species);
                }
            }
            speciesList = Lists.newArrayList((Iterable)speciesSet);
            if (log.isInfoEnabled()) {
                log.info((Object)("Use speciesBatch + individualObservation species : " + speciesList.size()));
            }
        } else if (this.getDataContext().isProtocolFilled()) {
            speciesList = Lists.newArrayList((Iterable)speciesListWithSurveyCode);
            List rows = batchModel.getRows();
            if (CollectionUtils.isNotEmpty(rows)) {
                for (IndividualObservationBatchRowModel row : rows) {
                    Species species = row.getSpecies();
                    if (speciesList.contains(species)) continue;
                    speciesList.add(species);
                }
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Use protocol + individualObservation species : " + speciesList.size()));
            }
        } else {
            speciesList = speciesListWithSurveyCode;
            if (log.isInfoEnabled()) {
                log.info((Object)("Use all species : " + speciesList.size()));
            }
        }
        model.setAvailableSpecies(speciesList);
        Species lastSpeciesUsed = batchModel.getLastSpeciesUsed();
        model.setSpecies(lastSpeciesUsed);
        model.setLengthStepCaracteristic(batchModel.getLastLengthStepCaracteristicUsed());
    }

    public void saveAndContinue() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Save And Continue UI " + this.ui));
        }
        EditCatchesUI parent = (EditCatchesUI)SwingUtil.getParentContainer((Object)this.ui, EditCatchesUI.class);
        IndividualObservationBatchUI individualObservationTabContent = parent.getIndividualObservationTabContent();
        individualObservationTabContent.getHandler().addBatch((CreateIndividualObservationBatchUIModel)this.getModel());
        this.openUI(individualObservationTabContent.getModel());
        ((CreateIndividualObservationBatchUI)this.ui).getIndividualObservationWeightField().grabFocus();
    }

    public void saveAndClose() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Save And Close UI " + this.ui));
        }
        EditCatchesUI parent = (EditCatchesUI)SwingUtil.getParentContainer((Object)this.ui, EditCatchesUI.class);
        parent.getIndividualObservationTabContent().getHandler().addBatch((CreateIndividualObservationBatchUIModel)this.getModel());
        this.closeUI(this.ui);
    }

    public Species openAddSpeciesDialog(String title, List<Species> species) {
        SelectSpeciesUI dialogContent = new SelectSpeciesUI(this.ui);
        SelectSpeciesUIModel model = dialogContent.getModel();
        model.setSelectedSpecies(null);
        model.setSpecies(species);
        this.openDialog(dialogContent, title, new Dimension(400, 130));
        Species result = model.getSelectedSpecies();
        return result;
    }
}

