/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util;

import org.nuiton.i18n.I18n;

public enum WeightUnit {
    G(I18n.n_((String)"tutti.common.unit.g", (Object[])new Object[0]), I18n.n_((String)"tutti.common.unit.short.g", (Object[])new Object[0])){

        @Override
        public Float fromEntity(Float weight) {
            return weight == null ? null : Float.valueOf(weight.floatValue() * 1000.0f);
        }

        @Override
        public Float toEntity(Float weight) {
            return weight == null ? null : Float.valueOf(weight.floatValue() / 1000.0f);
        }
    }
    ,
    KG(I18n.n_((String)"tutti.common.unit.kg", (Object[])new Object[0]), I18n.n_((String)"tutti.common.unit.short.kg", (Object[])new Object[0])){

        @Override
        public Float fromEntity(Float weight) {
            return weight;
        }

        @Override
        public Float toEntity(Float weight) {
            return weight;
        }
    };

    private final String i18nShortKey;
    private final String i18nKey;

    private WeightUnit(String i18nKey, String i18nShortKey) {
        this.i18nKey = i18nKey;
        this.i18nShortKey = i18nShortKey;
    }

    public String getLabel() {
        return I18n._((String)this.i18nKey, (Object[])new Object[0]);
    }

    public String getShortLabel() {
        return I18n._((String)this.i18nShortKey, (Object[])new Object[0]);
    }

    public abstract Float fromEntity(Float var1);

    public abstract Float toEntity(Float var1);

    public String decorateLabel(String label) {
        return String.format("%s (%s)", label, this.getShortLabel());
    }

    public String decorateTip(String tip) {
        String unit = I18n._((String)"tutti.common.unit", (Object[])new Object[0]);
        return String.format("%s (%s %s)", tip, unit, this.getLabel());
    }
}

