/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service.batch;

import com.google.common.collect.Lists;
import fr.ifremer.adagio.core.dao.data.batch.Batch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatchExtendDao;
import fr.ifremer.adagio.core.dao.data.batch.SortingBatch;
import fr.ifremer.adagio.core.dao.data.batch.validator.CatchBatchValidationError;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModelEntry;
import fr.ifremer.tutti.persistence.entities.data.SpeciesAbleBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.service.CatchBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.TuttiEnumerationFile;
import fr.ifremer.tutti.persistence.service.batch.BatchPersistenceHelper;
import fr.ifremer.tutti.persistence.service.batch.TuttiCatchBatchValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="scientificCruiseCatchBatchValidator")
public class ScientificCruiseCatchBatchValidator
implements TuttiCatchBatchValidator {
    private static final Log log = LogFactory.getLog(ScientificCruiseCatchBatchValidator.class);
    @Autowired
    protected CatchBatchPersistenceService batchService;
    @Autowired
    protected CatchBatchExtendDao catchBatchDao;
    @Autowired
    protected TuttiEnumerationFile enumeration;
    @Autowired
    protected BatchPersistenceHelper batchHelper;

    public boolean isEnable(CatchBatch catchBatch) {
        return catchBatch.getFishingOperation() != null;
    }

    public List<CatchBatchValidationError> validate(CatchBatch catchBatch) {
        ArrayList errors = Lists.newArrayList();
        this.validateCatchBatch(catchBatch.getChildBatchs(), errors);
        return errors;
    }

    @Override
    public List<CatchBatchValidationError> validateSpecies(SampleCategoryModel sampleCategoryModel, BatchContainer<SpeciesBatch> species) {
        ArrayList errors = Lists.newArrayList();
        Map<Integer, SampleCategoryModelEntry> categoriesById = sampleCategoryModel.getCategoryMap();
        for (SpeciesBatch speciesBatch : species.getChildren()) {
            this.validateSampleCategoriesUniverse(sampleCategoryModel, errors, speciesBatch, I18n.n_((String)"tutti.persistence.batch.validation.invalid.species.sampleCategoryId", (Object[])new Object[0]));
            if (!errors.isEmpty()) continue;
            this.validateSampleCategoriesOrder(categoriesById, errors, speciesBatch, null, I18n.n_((String)"tutti.persistence.batch.validation.invalid.species.sampleCategoryId.order", (Object[])new Object[0]));
        }
        return errors;
    }

    @Override
    public List<CatchBatchValidationError> validateBenthos(SampleCategoryModel sampleCategoryModel, BatchContainer<BenthosBatch> benthos) {
        ArrayList errors = Lists.newArrayList();
        Map<Integer, SampleCategoryModelEntry> categoriesById = sampleCategoryModel.getCategoryMap();
        for (BenthosBatch benthosBatch : benthos.getChildren()) {
            this.validateSampleCategoriesUniverse(sampleCategoryModel, errors, benthosBatch, I18n.n_((String)"tutti.persistence.batch.validation.invalid.benthos.sampleCategoryId", (Object[])new Object[0]));
            if (!errors.isEmpty()) continue;
            this.validateSampleCategoriesOrder(categoriesById, errors, benthosBatch, null, I18n.n_((String)"tutti.persistence.batch.validation.invalid.benthos.sampleCategoryId.order", (Object[])new Object[0]));
        }
        return errors;
    }

    protected void validateCatchBatch(Collection<Batch> batchs, List<CatchBatchValidationError> errors) {
        SortingBatch vracBatch = this.batchHelper.getSortingBatch(batchs, "Vrac", this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_VRAC_ID);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Try to validate Vrac batch model " + vracBatch));
        }
        if (vracBatch == null) {
            this.addError(errors, I18n.n_((String)"tutti.persistence.batch.validation.vracNotFound", (Object[])new Object[0]));
        } else {
            SortingBatch aliveItemizedBatch;
            SortingBatch inertBatch;
            SortingBatch livingNotItemizedBatch;
            SortingBatch speciesBatch = this.batchHelper.getSortingBatch((Batch)vracBatch, "Vrac > Species", this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_SPECIES);
            SortingBatch benthosBatch = this.batchHelper.getSortingBatch((Batch)vracBatch, "Vrac > Benthos", this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_BENTHOS);
            if (speciesBatch == null) {
                if (benthosBatch == null) {
                    this.addError(errors, I18n.n_((String)"tutti.persistence.batch.validation.vracSpeciesNotFound", (Object[])new Object[0]));
                } else {
                    this.addWarning(errors, I18n.n_((String)"tutti.persistence.batch.validation.vracSpeciesNotFound", (Object[])new Object[0]));
                }
            } else {
                livingNotItemizedBatch = this.batchHelper.getSortingBatch((Batch)speciesBatch, "Vrac > Species > Alive not itemized", this.enumeration.PMFM_ID_SORTING_TYPE_2, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_2_ALIVE_NOT_ITEMIZED);
                if (livingNotItemizedBatch == null) {
                    this.addWarning(errors, I18n.n_((String)"tutti.persistence.batch.validation.vracSpeciesLifeNotFound", (Object[])new Object[0]));
                }
                if ((inertBatch = this.batchHelper.getSortingBatch((Batch)speciesBatch, "Vrac > Species > Inert", this.enumeration.PMFM_ID_SORTING_TYPE_2, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_2_INERT)) == null) {
                    this.addWarning(errors, I18n.n_((String)"tutti.persistence.batch.validation.vracSpeciesInertNotFound", (Object[])new Object[0]));
                }
                if ((aliveItemizedBatch = this.batchHelper.getSortingBatch((Batch)speciesBatch, "Vrac > Species > Alive itemized", this.enumeration.PMFM_ID_SORTING_TYPE_2, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_2_ALIVE_ITEMIZED)) == null) {
                    this.addWarning(errors, I18n.n_((String)"tutti.persistence.batch.validation.vracSpeciesAliveItemizedNotFound", (Object[])new Object[0]));
                }
            }
            if (benthosBatch == null) {
                if (speciesBatch == null) {
                    this.addError(errors, I18n.n_((String)"tutti.persistence.batch.validation.vracBenthosNotFound", (Object[])new Object[0]));
                } else {
                    this.addWarning(errors, I18n.n_((String)"tutti.persistence.batch.validation.vracBenthosNotFound", (Object[])new Object[0]));
                }
            } else {
                livingNotItemizedBatch = this.batchHelper.getSortingBatch((Batch)benthosBatch, "Vrac > Benthos > Alive not itemized", this.enumeration.PMFM_ID_SORTING_TYPE_2, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_2_ALIVE_NOT_ITEMIZED);
                if (livingNotItemizedBatch == null) {
                    this.addWarning(errors, I18n.n_((String)"tutti.persistence.batch.validation.vracBenthosLifeNotFound", (Object[])new Object[0]));
                }
                if ((inertBatch = this.batchHelper.getSortingBatch((Batch)benthosBatch, "Vrac > Benthos > Inert", this.enumeration.PMFM_ID_SORTING_TYPE_2, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_2_INERT)) == null) {
                    this.addWarning(errors, I18n.n_((String)"tutti.persistence.batch.validation.vracBenthosInertNotFound", (Object[])new Object[0]));
                }
                if ((aliveItemizedBatch = this.batchHelper.getSortingBatch((Batch)benthosBatch, "Vrac > Benthos > Alive itermized", this.enumeration.PMFM_ID_SORTING_TYPE_2, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_2_ALIVE_ITEMIZED)) == null) {
                    this.addWarning(errors, I18n.n_((String)"tutti.persistence.batch.validation.vracBenthosAliveItemizedNotFound", (Object[])new Object[0]));
                }
            }
        }
        SortingBatch horsVracBatch = this.batchHelper.getSortingBatch(batchs, "Hors Vrac", this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_HORS_VRAC_ID);
        if (horsVracBatch == null) {
            this.addWarning(errors, I18n.n_((String)"tutti.persistence.batch.validation.horsVracNotFound", (Object[])new Object[0]));
        } else {
            SortingBatch marineLitterBatch;
            SortingBatch benthosBatch;
            SortingBatch speciesBatch = this.batchHelper.getSortingBatch((Batch)horsVracBatch, "Hors Vrac > Species", this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_SPECIES);
            if (speciesBatch == null) {
                this.addWarning(errors, I18n.n_((String)"tutti.persistence.batch.validation.horsVracSpeciesNotFound", (Object[])new Object[0]));
            }
            if ((benthosBatch = this.batchHelper.getSortingBatch((Batch)horsVracBatch, "Hors Vrac > Benthos", this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_BENTHOS)) == null) {
                this.addWarning(errors, I18n.n_((String)"tutti.persistence.batch.validation.horsVracBenthosNotFound", (Object[])new Object[0]));
            }
            if ((marineLitterBatch = this.batchHelper.getSortingBatch((Batch)horsVracBatch, "Hors Vrac > Marine Litter", this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_MARINE_LITTER)) == null) {
                this.addWarning(errors, I18n.n_((String)"tutti.persistence.batch.validation.horsVracMarineLitterNotFound", (Object[])new Object[0]));
            }
        }
        SortingBatch unsortedBatch = this.batchHelper.getSortingBatch(batchs, "Unsorted", this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_UNSORTED_ID);
        if (unsortedBatch == null) {
            this.addWarning(errors, I18n.n_((String)"tutti.persistence.batch.validation.unsortedNotFound", (Object[])new Object[0]));
        }
    }

    protected void validateSampleCategoriesUniverse(SampleCategoryModel sampleCategoryModel, List<CatchBatchValidationError> errors, SpeciesAbleBatch aBatch, String messageKey) {
        Integer sampleCategoryId = aBatch.getSampleCategoryId();
        if (!sampleCategoryModel.containsCategoryId(sampleCategoryId)) {
            this.addError(errors, messageKey, aBatch.getId(), aBatch.getSpecies().getName(), sampleCategoryId);
        }
        if (!aBatch.isChildBatchsEmpty()) {
            for (SpeciesAbleBatch speciesAbleBatch : aBatch.getChildBatchs()) {
                this.validateSampleCategoriesUniverse(sampleCategoryModel, errors, speciesAbleBatch, messageKey);
            }
        }
    }

    protected void validateSampleCategoriesOrder(Map<Integer, SampleCategoryModelEntry> categoriesById, List<CatchBatchValidationError> errors, SpeciesAbleBatch aBatch, SampleCategoryModelEntry lastSampleCategory, String messageKey) {
        Integer sampleCategoryId = aBatch.getSampleCategoryId();
        SampleCategoryModelEntry actualCategory = categoriesById.get(sampleCategoryId);
        if (lastSampleCategory != null && actualCategory.getOrder() < lastSampleCategory.getOrder()) {
            this.addError(errors, messageKey, aBatch.getId(), aBatch.getSpecies().getName(), actualCategory.getLabel(), lastSampleCategory.getLabel());
            return;
        }
        lastSampleCategory = actualCategory;
        if (!aBatch.isChildBatchsEmpty()) {
            for (SpeciesAbleBatch speciesAbleBatch : aBatch.getChildBatchs()) {
                this.validateSampleCategoriesOrder(categoriesById, errors, speciesAbleBatch, lastSampleCategory, messageKey);
            }
        }
    }

    protected void addError(List<CatchBatchValidationError> errors, String messageKey) {
        CatchBatchValidationError error = new CatchBatchValidationError(messageKey, I18n._((String)messageKey, (Object[])new Object[0]), 2);
        errors.add(error);
    }

    protected void addError(List<CatchBatchValidationError> errors, String messageKey, Object ... params) {
        CatchBatchValidationError error = new CatchBatchValidationError(messageKey, I18n._((String)messageKey, (Object[])params), 2);
        errors.add(error);
    }

    protected void addWarning(List<CatchBatchValidationError> errors, String messageKey) {
        CatchBatchValidationError error = new CatchBatchValidationError(messageKey, I18n._((String)messageKey, (Object[])new Object[0]), 1);
        errors.add(error);
    }
}

