/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.config;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.awt.Frame;
import java.io.File;
import javax.swing.Icon;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.config.ConfigUI;
import jaxx.runtime.swing.config.model.CallBackFinalizer;
import jaxx.runtime.swing.config.model.CategoryModel;
import jaxx.runtime.swing.config.model.ConfigUIModel;
import jaxx.runtime.swing.config.model.ConfigUIModelBuilder;
import jaxx.runtime.swing.config.model.OptionModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.config.ApplicationConfig;
import org.nuiton.util.config.ConfigOptionDef;

public class ConfigUIHelper {
    public static final Log log = LogFactory.getLog(ConfigUIHelper.class);
    protected final ConfigUIModelBuilder modelBuilder = new ConfigUIModelBuilder();
    protected ConfigUIModel model;
    protected ConfigUI ui;

    public ConfigUIHelper(Supplier<ApplicationConfig> config) {
        this.modelBuilder.createModel(config);
    }

    public ConfigUIHelper(Supplier<ApplicationConfig> config, File configFile) {
        this.modelBuilder.createModel(config, configFile);
    }

    public ConfigUIHelper(ApplicationConfig config, File configFile) {
        this.modelBuilder.createModel(config, configFile);
    }

    public ConfigUIHelper(ApplicationConfig config) {
        this.modelBuilder.createModel(config);
    }

    public ConfigUIModel getModel() {
        if (this.model == null) {
            this.model = this.modelBuilder.flushModel();
        }
        return this.model;
    }

    public ConfigUIModelBuilder addCategory(String categoryName, String categoryLabel) throws IllegalStateException, NullPointerException {
        this.modelBuilder.addCategory(categoryName, categoryLabel);
        return this.modelBuilder;
    }

    public ConfigUIModelBuilder addCategory(String categoryName, String categoryLabel, String categoryCallback) throws IllegalStateException, NullPointerException {
        this.modelBuilder.addCategory(categoryName, categoryLabel, categoryCallback);
        return this.modelBuilder;
    }

    public ConfigUIModelBuilder addOption(ConfigOptionDef def) throws IllegalStateException, NullPointerException {
        this.modelBuilder.addOption(def);
        return this.modelBuilder;
    }

    public ConfigUIModelBuilder addOption(ConfigOptionDef def, String propertyName) throws IllegalStateException, NullPointerException {
        this.modelBuilder.addOption(def, propertyName);
        return this.modelBuilder;
    }

    public ConfigUIModelBuilder setOptionPropertyName(String propertyName) throws IllegalStateException, NullPointerException {
        this.modelBuilder.setOptionPropertyName(propertyName);
        return this.modelBuilder;
    }

    public ConfigUIModelBuilder setOptionEditor(TableCellEditor editor) throws IllegalStateException, NullPointerException {
        this.modelBuilder.setOptionEditor(editor);
        return this.modelBuilder;
    }

    public ConfigUIModelBuilder setOptionRenderer(TableCellRenderer renderer) throws IllegalStateException, NullPointerException {
        this.modelBuilder.setOptionRenderer(renderer);
        return this.modelBuilder;
    }

    public ConfigUIModelBuilder registerCallBack(String name, String description, Icon icon, Runnable action) {
        this.modelBuilder.registerCallBack(name, description, icon, action);
        return this.modelBuilder;
    }

    public ConfigUIModelBuilder setOptionCallBack(String name) {
        this.modelBuilder.setOptionCallBack(name);
        return this.modelBuilder;
    }

    public ConfigUIModelBuilder setModel(ConfigUIModel model) throws IllegalStateException {
        this.modelBuilder.setModel(model);
        return this.modelBuilder;
    }

    public ConfigUIModelBuilder setCategory(CategoryModel categoryModel) throws IllegalStateException {
        this.modelBuilder.setCategory(categoryModel);
        return this.modelBuilder;
    }

    public ConfigUIModelBuilder setOption(OptionModel optionModel) throws IllegalStateException {
        this.modelBuilder.setOption(optionModel);
        return this.modelBuilder;
    }

    public ConfigUIModelBuilder setFinalizer(CallBackFinalizer finalizer) {
        this.modelBuilder.setFinalizer(finalizer);
        return this.modelBuilder;
    }

    public ConfigUIModelBuilder setCloseAction(Runnable runnable) {
        this.modelBuilder.setCloseAction(runnable);
        return this.modelBuilder;
    }

    public ConfigUI buildUI(JAXXContext parentContext, String defaultCategory) {
        ConfigUIModel model = this.getModel();
        JAXXInitialContext tx = new JAXXInitialContext().add((Object)parentContext).add((Object)model);
        this.ui = new ConfigUI((JAXXContext)tx);
        this.ui.init(defaultCategory);
        return this.ui;
    }

    public void displayUI(Frame parentUI, boolean undecorated) {
        Preconditions.checkNotNull((Object)this.ui, (Object)"UI was not build, use before the *buildUI* method");
        this.ui.getHandler().displayUI(parentUI, undecorated);
    }
}

