/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.export;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryEnum;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.service.export.ExportSampleCategory;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;

public class CatchExportRow
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FREQUENCY_LENGTH_STEP = "frequency.lengthStep";
    public static final String FREQUENCY_NUMBER = "frequency.number";
    public static final String FREQUENCY_WEIGHT = "frequency.weight";
    public static final String FREQUENCY_LENGTH_STEP_CARACTERISTIC = "frequency.lengthStepCaracteristic";
    public static final String FREQUENCY_RANK_ORDER = "frequency.rankOrder";
    public static final String SORTED_UNSORTED_SAMPLE_CATEGORY = "sortedUnsortedSampleCategory";
    public static final String SIZE_SAMPLE_CATEGORY = "sizeSampleCategory";
    public static final String SEX_SAMPLE_CATEGORY = "sexSampleCategory";
    public static final String MATURITY_SAMPLE_CATEGORY = "maturitySampleCategory";
    public static final String AGE_SAMPLE_CATEGORY = "ageSampleCategory";
    public static final String REFERENCE_WEIGHT = "referenceWeight";
    public static final String RAISING_FACTOR = "raisingFactor";
    public static final String BATCH_NUMBER = "batchNumber";
    protected Cruise cruise;
    protected FishingOperation fishingOperation;
    protected ExportSampleCategory speciesCategory;
    protected final Map<SampleCategoryEnum, ExportSampleCategory> categories = Maps.newEnumMap(SampleCategoryEnum.class);
    protected SpeciesBatchFrequency speciesFrequency;
    protected BenthosBatchFrequency benthosFrequency;
    protected Species species;
    protected float referenceWeight;
    protected float raisingFactor;
    protected Integer batchNumber;

    public void setCruise(Cruise cruise) {
        this.cruise = cruise;
    }

    public void setFishingOperation(FishingOperation fishingOperation) {
        this.fishingOperation = fishingOperation;
    }

    public void setSpeciesCategory(ExportSampleCategory sampleCategory) {
        this.speciesCategory = sampleCategory;
    }

    public void setReferenceWeight(float referenceWeight) {
        this.referenceWeight = referenceWeight;
    }

    public void setRaisingFactor(float raisingFactor) {
        this.raisingFactor = raisingFactor;
    }

    public void setBatchNumber(Integer batchNumber) {
        this.batchNumber = batchNumber;
    }

    public void addCategory(ExportSampleCategory sampleCategory) {
        this.categories.put(sampleCategory.getCategoryType(), sampleCategory);
    }

    public void setSpeciesFrequency(SpeciesBatchFrequency speciesFrequency) {
        Preconditions.checkNotNull((Object)speciesFrequency);
        this.speciesFrequency = speciesFrequency;
        this.batchNumber = speciesFrequency.getNumber();
    }

    public void setBenthosFrequency(BenthosBatchFrequency benthosFrequency) {
        Preconditions.checkNotNull((Object)benthosFrequency);
        this.benthosFrequency = benthosFrequency;
        this.batchNumber = benthosFrequency.getNumber();
    }

    public Date getBeginDate() {
        return this.cruise.getBeginDate();
    }

    public Program getProgram() {
        return this.cruise.getProgram();
    }

    public String getSurveyPart() {
        return this.cruise.getSurveyPart();
    }

    public Vessel getVessel() {
        return this.cruise.getVessel();
    }

    public String getStationNumber() {
        return this.fishingOperation.getStationNumber();
    }

    public Integer getFishingOperationNumber() {
        return this.fishingOperation.getFishingOperationNumber();
    }

    public Gear getGear() {
        return this.fishingOperation.getGear();
    }

    public String getMultirigAggregation() {
        return this.fishingOperation.getMultirigAggregation();
    }

    public Object getFrequency() {
        return this.speciesFrequency == null ? this.benthosFrequency : this.speciesFrequency;
    }

    public ExportSampleCategory getSpeciesSampleCategory() {
        return this.speciesCategory;
    }

    public ExportSampleCategory getSortedUnsortedSampleCategory() {
        return this.categories.get(SampleCategoryEnum.sortedUnsorted);
    }

    public ExportSampleCategory getSizeSampleCategory() {
        return this.categories.get(SampleCategoryEnum.size);
    }

    public ExportSampleCategory getSexSampleCategory() {
        return this.categories.get(SampleCategoryEnum.sex);
    }

    public ExportSampleCategory getMaturitySampleCategory() {
        return this.categories.get(SampleCategoryEnum.maturity);
    }

    public ExportSampleCategory getAgeSampleCategory() {
        return this.categories.get(SampleCategoryEnum.age);
    }

    public Species getSpecies() {
        return this.species;
    }

    public void setSpecies(Species species) {
        this.species = species;
    }

    public float getReferenceWeight() {
        return this.referenceWeight;
    }

    public float getRaisingFactor() {
        return this.raisingFactor;
    }

    public Integer getBatchNumber() {
        return this.batchNumber;
    }

    public CatchExportRow copy() {
        CatchExportRow result = new CatchExportRow();
        result.setCruise(this.cruise);
        result.setFishingOperation(this.fishingOperation);
        result.setSpeciesCategory(this.speciesCategory);
        result.categories.putAll(this.categories);
        if (this.benthosFrequency != null) {
            result.setBenthosFrequency(this.benthosFrequency);
        }
        if (this.speciesFrequency != null) {
            result.setSpeciesFrequency(this.speciesFrequency);
        }
        result.setSpecies(this.species);
        result.setRaisingFactor(this.raisingFactor);
        result.setReferenceWeight(this.referenceWeight);
        result.setBatchNumber(this.batchNumber);
        return result;
    }
}

