/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryEnum;
import fr.ifremer.tutti.persistence.entities.data.SortedUnsortedEnum;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.service.catches.TuttiWeightComputingException;
import fr.ifremer.tutti.service.catches.TuttiWeightComputingService;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.table.AbstractSelectTableAction;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import org.nuiton.i18n.I18n;

public class ComputeWeightsAction
extends AbstractTuttiAction<EditCatchesUIModel, EditCatchesUI, EditCatchesUIHandler> {
    public ComputeWeightsAction(EditCatchesUIHandler handler) {
        super(handler, false);
    }

    @Override
    protected void doAction() throws Exception {
        int answer;
        String htmlMessage;
        BatchContainer computedMarineLitterBatches;
        Float totalBenthosSortedWeight;
        BatchContainer computedBenthosBatches;
        Float totalSpeciesSortedWeight;
        BatchContainer computedSpeciesBatches;
        TuttiWeightComputingService tuttiWeightComputingService = this.getContext().getTuttiWeightComputingService();
        EditCatchesUIModel model = (EditCatchesUIModel)this.getModel();
        model.setLoadingData(true);
        try {
            computedSpeciesBatches = tuttiWeightComputingService.getComputedSpeciesBatches(model.getFishingOperation());
            totalSpeciesSortedWeight = this.computeSpeciesBatches(computedSpeciesBatches);
        }
        catch (TuttiWeightComputingException e) {
            ((EditCatchesUI)this.getUI()).getTabPane().setSelectedIndex(1);
            int index = e.getIndex();
            SpeciesBatchRowModel row = (SpeciesBatchRowModel)((EditCatchesUI)this.getUI()).getSpeciesTabContent().getModel().getRows().get(index);
            int column = "sampleCategoryWeight".equals(e.getProperty()) ? this.getFinestCategoryColumn(row.getFinestCategory().getCategoryType()) : 6;
            AbstractSelectTableAction.doSelectCell((JTable)((EditCatchesUI)this.getUI()).getSpeciesTabContent().getTable(), index, column);
            throw e;
        }
        try {
            computedBenthosBatches = tuttiWeightComputingService.getComputedBenthosBatches(model.getFishingOperation());
            totalBenthosSortedWeight = this.computeBenthosBatches(computedBenthosBatches);
        }
        catch (TuttiWeightComputingException e) {
            ((EditCatchesUI)this.getUI()).getTabPane().setSelectedIndex(2);
            int index = e.getIndex();
            BenthosBatchRowModel row = (BenthosBatchRowModel)((EditCatchesUI)this.getUI()).getBenthosTabContent().getModel().getRows().get(index);
            int column = "sampleCategoryWeight".equals(e.getProperty()) ? this.getFinestCategoryColumn(row.getFinestCategory().getCategoryType()) : 6;
            AbstractSelectTableAction.doSelectCell((JTable)((EditCatchesUI)this.getUI()).getBenthosTabContent().getTable(), index, column);
            throw e;
        }
        try {
            computedMarineLitterBatches = tuttiWeightComputingService.getComputedMarineLitterBatches(model.getFishingOperation(), model.getMarineLitterTotalWeight());
        }
        catch (TuttiWeightComputingException e) {
            ((EditCatchesUI)this.getUI()).getTabPane().setSelectedIndex(3);
            AbstractSelectTableAction.doSelectCell((JTable)((EditCatchesUI)this.getUI()).getMarineLitterTabContent().getTable(), e.getIndex(), 3);
            throw e;
        }
        Float rate = this.getConfig().getDifferenceRateBetweenSortedAndTotalWeights();
        if (model.getSpeciesTotalSortedWeight() != null && model.getSpeciesTotalSortedWeight().floatValue() >= totalSpeciesSortedWeight.floatValue() && model.getSpeciesTotalSortedWeight().floatValue() < (1.0f + rate.floatValue() / 100.0f) * totalSpeciesSortedWeight.floatValue()) {
            ((EditCatchesUI)this.getUI()).getTabPane().setSelectedIndex(1);
            htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n._((String)"tutti.editCatchBatch.action.computeWeights.replaceTotalSortedWeight.message.species", (Object[])new Object[]{rate}), I18n._((String)"tutti.editCatchBatch.action.computeWeights.replaceTotalSortedWeight.help", (Object[])new Object[0]));
            answer = JOptionPane.showConfirmDialog(this.getContext().getActionUI(), htmlMessage, I18n._((String)"tutti.editCatchBatch.action.computeWeights.replaceTotalSortedWeight.title", (Object[])new Object[0]), 0, 3);
            if (answer == 1) {
                model.setSpeciesTotalSortedWeight(null);
                model.setSpeciesTotalSortedComputedWeight(totalSpeciesSortedWeight);
            }
        }
        if (model.getBenthosTotalSortedWeight() != null && model.getBenthosTotalSortedWeight().floatValue() >= totalBenthosSortedWeight.floatValue() && model.getBenthosTotalSortedWeight().floatValue() < (1.0f + rate.floatValue() / 100.0f) * totalSpeciesSortedWeight.floatValue()) {
            ((EditCatchesUI)this.getUI()).getTabPane().setSelectedIndex(2);
            htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n._((String)"tutti.editCatchBatch.action.computeWeights.replaceTotalSortedWeight.message.benthos", (Object[])new Object[]{rate}), I18n._((String)"tutti.editCatchBatch.action.computeWeights.replaceTotalSortedWeight.help", (Object[])new Object[0]));
            answer = JOptionPane.showConfirmDialog(this.getContext().getActionUI(), htmlMessage, I18n._((String)"tutti.editCatchBatch.action.computeWeights.replaceTotalSortedWeight.title", (Object[])new Object[0]), 0, 3);
            if (answer == 1) {
                model.setBenthosTotalSortedWeight(null);
                model.setBenthosTotalSortedComputedWeight(totalBenthosSortedWeight);
            }
        }
        boolean modified = model.isModify();
        CatchBatch catchBatch = (CatchBatch)model.toBean();
        tuttiWeightComputingService.computeCatchBatchWeights(catchBatch, computedSpeciesBatches, computedBenthosBatches, computedMarineLitterBatches);
        model.setCatchBatch(catchBatch);
        model.fromBean(catchBatch);
        model.setLoadingData(false);
        model.setModify(modified);
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        ((EditCatchesUI)this.getUI()).repaint();
    }

    protected Float computeSpeciesBatches(BatchContainer<SpeciesBatch> computedSpeciesBatches) {
        Float totalSortedWeight = Float.valueOf(0.0f);
        if (computedSpeciesBatches != null) {
            ArrayList rows = Lists.newArrayList();
            List<SpeciesBatch> children = computedSpeciesBatches.getChildren();
            for (SpeciesBatch batch : children) {
                SpeciesBatchRowModel row = ((EditCatchesUI)this.getUI()).getSpeciesTabContent().getHandler().loadBatch(batch, null, rows);
                Float weight = row.getSortedUnsortedCategoryWeight();
                if (weight == null) {
                    weight = row.getSortedUnsortedCategoryComputedWeight();
                }
                if (!SortedUnsortedEnum.SORTED.matchValue(row.getSortedUnsortedCategoryValue())) continue;
                totalSortedWeight = Float.valueOf(totalSortedWeight.floatValue() + weight.floatValue());
            }
            ((EditCatchesUI)this.getUI()).getSpeciesTabContent().getModel().setRows(rows);
        }
        return totalSortedWeight;
    }

    protected Float computeBenthosBatches(BatchContainer<BenthosBatch> computedBenthosBatches) {
        Float totalSortedWeight = Float.valueOf(0.0f);
        if (computedBenthosBatches != null) {
            ArrayList rows = Lists.newArrayList();
            List<BenthosBatch> children = computedBenthosBatches.getChildren();
            for (BenthosBatch batch : children) {
                BenthosBatchRowModel row = ((EditCatchesUI)this.getUI()).getBenthosTabContent().getHandler().loadBatch(batch, null, rows);
                Float weight = row.getSortedUnsortedCategoryWeight();
                if (weight == null) {
                    weight = row.getSortedUnsortedCategoryComputedWeight();
                }
                if (!SortedUnsortedEnum.SORTED.matchValue(row.getSortedUnsortedCategoryValue())) continue;
                totalSortedWeight = Float.valueOf(totalSortedWeight.floatValue() + weight.floatValue());
            }
            ((EditCatchesUI)this.getUI()).getBenthosTabContent().getModel().setRows(rows);
        }
        return totalSortedWeight;
    }

    protected int getFinestCategoryColumn(SampleCategoryEnum categoryType) {
        Integer categoryId;
        int column = 1;
        List samplingOrderIds = this.getConfig().getServiceConfig().getSamplingOrderIds();
        int index = samplingOrderIds.indexOf(categoryId = categoryType.getFieldValue());
        if (index > -1) {
            column += index + 1;
        }
        return column;
    }
}

