/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.common;

import org.apache.commons.lang.StringUtils;

public class ExceptionUtils {
    public static void checkNull(String methodExecuteName, String argumentName, Object argument) {
        ExceptionUtils.checkNull(argumentName, argument, 3);
    }

    public static void checkNull(String argumentName, Object argument) {
        ExceptionUtils.checkNull(argumentName, argument, 3);
    }

    private static void checkNull(String argumentName, Object argument, int stackDepth) {
        if (StringUtils.isEmpty((String)argumentName)) {
            throw new IllegalArgumentException("'argumentName' can not be null or an empty String");
        }
        if (argument == null) {
            throw new IllegalArgumentException(ExceptionUtils.getMethodName(stackDepth) + " - '" + argumentName + "' can not be null");
        }
    }

    public static void checkEmpty(String methodExecuteName, String argumentName, String argument) {
        ExceptionUtils.checkEmpty(argumentName, argument, 3);
    }

    public static void checkEmpty(String argumentName, String argument) {
        ExceptionUtils.checkEmpty(argumentName, argument, 3);
    }

    private static void checkEmpty(String argumentName, String argument, int stackDepth) {
        if (StringUtils.isEmpty((String)argumentName)) {
            throw new IllegalArgumentException("'argumentName' can not be null or an empty String");
        }
        if (StringUtils.isEmpty((String)argument)) {
            throw new IllegalArgumentException(ExceptionUtils.getMethodName(stackDepth) + " - '" + argumentName + "' can not be null or an empty String");
        }
    }

    public static void checkAssignable(String methodExecuteName, Class assignableToClass, String argumentName, Class argumentClass) {
        ExceptionUtils.checkAssignable(assignableToClass, argumentName, argumentClass, 3);
    }

    public static void checkAssignable(Class assignableToClass, String argumentName, Class argumentClass) {
        ExceptionUtils.checkAssignable(assignableToClass, argumentName, argumentClass, 3);
    }

    private static void checkAssignable(Class assignableToClass, String argumentName, Class argumentClass, int stackDepth) {
        if (assignableToClass == null) {
            throw new IllegalArgumentException("'assignableToClass' can not be null");
        }
        if (argumentClass == null) {
            throw new IllegalArgumentException("'argumentClass' can not be null");
        }
        if (StringUtils.isEmpty((String)argumentName)) {
            throw new IllegalArgumentException("'argumentName can not be null or an empty String");
        }
        if (!assignableToClass.isAssignableFrom(argumentClass)) {
            throw new IllegalArgumentException(ExceptionUtils.getMethodName(stackDepth) + " - '" + argumentName + "' class --> '" + argumentClass + "' must be assignable to class --> '" + assignableToClass + "'");
        }
    }

    public static Throwable getRootCause(Throwable throwable) {
        Throwable root = org.apache.commons.lang.exception.ExceptionUtils.getRootCause((Throwable)throwable);
        if (root != null) {
            throwable = root;
        }
        return throwable;
    }

    private static String getMethodName(int stackDepth) {
        String methodName = null;
        Throwable throwable = new Throwable();
        StackTraceElement[] stack = throwable.getStackTrace();
        if (stack.length >= stackDepth) {
            StackTraceElement element = stack[stackDepth];
            methodName = element.getClassName() + '.' + element.getMethodName();
        }
        return methodName;
    }
}

