package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

/*
 * #%L
 * Tutti :: UI
 * $Id: ImportMultiPostAction.java 933 2013-05-08 16:06:49Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/species/ImportMultiPostAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationAction;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.ImportPupitriPopupUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionHelper;

import java.io.File;

import static org.nuiton.i18n.I18n._;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since 2.2
 */
public class ImportMultiPostAction extends AbstractTuttiAction<SpeciesBatchUIModel, SpeciesBatchUI, SpeciesBatchUIHandler> {

    protected File file;

    protected EditFishingOperationAction editAction;

    public ImportMultiPostAction(SpeciesBatchUIHandler handler) {
        super(handler, false);
    }

    public EditFishingOperationAction getEditAction() {
        FishingOperationsUI parentUI = getUI().getParentContainer(FishingOperationsUI.class);
        if (editAction == null) {
            editAction = TuttiActionHelper.createLogicAction(parentUI.getHandler(),
                                                             EditFishingOperationAction.class);
        }
        return editAction;
    }

    @Override
    protected boolean prepareAction() throws Exception {

        boolean doAction = super.prepareAction();

        if (doAction) {

            // choose file to import
            file = TuttiUIUtil.chooseFile(
                    getContext().getMainUI(),
                    _("tutti.editSpeciesBatch.action.importMultiPost.sourceFile.title"),
                    _("tutti.editSpeciesBatch.action.importMultiPost.sourceFile.button")
            );

            doAction = file != null;
        }
        return doAction;
    }

    @Override
    protected void releaseAction() {
        file = null;
        super.releaseAction();
    }

    @Override
    protected void doAction() throws Exception {
        EditCatchesUI editCatchesUI = getUI().getParentContainer(EditCatchesUI.class);
        EditCatchesUIModel editCatchesUIModel = editCatchesUI.getModel();

        FishingOperation operation = editCatchesUIModel.getFishingOperation();
        CatchBatch catchBatch = editCatchesUIModel.getCatchBatch();

        String fishingOperationText = getEditAction().getFishingOperationTitle(operation);

        getEditAction().loadCatchBatch(operation, fishingOperationText, true);
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();

        sendMessage(_("tutti.editSpeciesBatch.action.importMultiPost.success", file));
    }
}
