/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.metafacade;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ListIterator;
import org.andromda.core.metafacade.MetafacadeFactory;
import org.andromda.core.metafacade.MetafacadeImpls;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class MetafacadeBase {
    private Object metaObject;
    private boolean initialized = false;
    private String context = null;
    private String namespace = null;
    protected Logger logger;
    protected boolean contextRoot = false;
    private String name = null;
    private Boolean metafacadePropertyCachingEnabled = null;
    private MetafacadeBase THIS = null;

    public MetafacadeBase(Object metaObject, String context) {
        this.metaObject = metaObject;
        this.context = context;
    }

    public Object getValidationOwner() {
        return null;
    }

    public String getValidationName() {
        return null;
    }

    final void setInitialized() {
        this.initialized = true;
    }

    final boolean isInitialized() {
        return this.initialized;
    }

    public final void validate(Collection validationMessages) {
        this.validateInvariants(validationMessages);
    }

    public void validateInvariants(Collection messages) {
    }

    public void initialize() {
    }

    protected MetafacadeBase shieldedElement(Object metaObject) {
        MetafacadeBase metafacade = null;
        if (metaObject != null) {
            String context = this.getContext();
            metafacade = MetafacadeFactory.getInstance().createMetafacade(metaObject, context);
            if (metafacade != null) {
                metafacade.resetMetafacadeContext(context);
            }
        }
        return metafacade;
    }

    protected Collection shieldedElements(Collection metaobjects) {
        ArrayList metafacades = new ArrayList();
        if (metaobjects != null) {
            metafacades.addAll(metaobjects);
            ListIterator<MetafacadeBase> iterator = metafacades.listIterator();
            while (iterator.hasNext()) {
                iterator.set(this.shieldedElement(iterator.next()));
            }
        }
        return metafacades;
    }

    final String getContext() {
        String context = this.context;
        if (StringUtils.isBlank((String)context)) {
            context = this.getName();
        }
        return context;
    }

    public void setMetafacadeContext(String context) {
        this.context = context;
    }

    public void resetMetafacadeContext(String context) {
        throw new IllegalStateException("Method resetMetafacadeContext() must be overridden by concrete metafacade class (" + this.getClass().getName() + ")! Please re-generate your metafacades using the new andromda-meta cartridge.");
    }

    final String getNamespace() {
        return this.namespace;
    }

    final void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    protected boolean isConfiguredProperty(String property) {
        return MetafacadeFactory.getInstance().isPropertyRegistered(this, property);
    }

    protected Object getConfiguredProperty(String property) {
        return MetafacadeFactory.getInstance().getRegisteredProperty(this, property);
    }

    protected void setProperty(String name, Object value) {
        MetafacadeFactory.getInstance().registerProperty(this.getName(), name, value);
    }

    public final Object getMetaObject() {
        return this.metaObject;
    }

    final void setLogger(Logger logger) {
        this.logger = logger;
    }

    final void setContextRoot(boolean contextRoot) {
        this.contextRoot = contextRoot;
    }

    public String getMetafacadeContext() {
        String metafacadeContext = this.getContext();
        if (this.contextRoot) {
            metafacadeContext = this.getName();
        }
        return metafacadeContext;
    }

    final String getName() {
        if (this.name == null) {
            this.name = MetafacadeImpls.instance().getMetafacadeClass(this.getClass().getName()).getName();
        }
        return this.name;
    }

    public boolean equals(Object object) {
        boolean equals = false;
        if (object instanceof MetafacadeBase) {
            MetafacadeBase that = (MetafacadeBase)object;
            equals = this.metaObject.equals(that.metaObject);
        }
        return equals;
    }

    public int hashCode() {
        return this.metaObject.hashCode();
    }

    public final boolean isMetafacadePropertyCachingEnabled() {
        if (this.metafacadePropertyCachingEnabled == null) {
            String enableCache = (String)this.getConfiguredProperty("enableMetafacadePropertyCaching");
            this.metafacadePropertyCachingEnabled = Boolean.valueOf(enableCache);
        }
        return this.metafacadePropertyCachingEnabled;
    }

    protected final MetafacadeBase THIS() {
        return this.THIS == null ? (this.THIS = this.shieldedElement(this.metaObject)) : this.THIS;
    }
}

