/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.configuration;

import java.io.Serializable;
import java.net.URL;
import java.util.List;
import java.util.ListIterator;
import org.andromda.core.common.ResourceUtils;

public class Location
implements Serializable {
    private String path;
    private String patterns;
    private static final String PATTERN_DELIMITER = ",";

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPatterns() {
        return this.patterns;
    }

    public void setPatterns(String patterns) {
        this.patterns = patterns;
    }

    public URL[] getResources() {
        URL[] resources;
        URL url = ResourceUtils.toURL(this.path);
        if (url != null) {
            if (ResourceUtils.isFile(url)) {
                resources = new URL[]{url};
            } else {
                String[] patterns = this.patterns != null ? this.patterns.split(PATTERN_DELIMITER) : new String[]{};
                List paths = ResourceUtils.getDirectoryContents(url, true, patterns);
                ListIterator<URL> iterator = paths.listIterator();
                while (iterator.hasNext()) {
                    URL resource = ResourceUtils.toURL((String)iterator.next());
                    if (resource != null) {
                        iterator.set(resource);
                        continue;
                    }
                    iterator.remove();
                }
                resources = paths.toArray(new URL[0]);
            }
        } else {
            resources = new URL[]{};
        }
        return resources;
    }
}

