package fr.ifremer.tutti.ui.swing.util.action;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.BlockingLayerUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class TuttiActionUI extends JDialog implements TuttiUI<TuttiActionUIModel, TuttiActionUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAMVWzW8bRRQfu7FTx4QmqZqmIhUO5ZCIdl2pQtCmgjYpURO5pWpaqcIXZr1je9rxzjLztlkrasWBP4Aj3ODOBYkbJ8SBMwcuiH8BIQ5cEW9m115/bIhJRGvZo9X7+L2Pee+3/uZ3UtCKrDymUeSo0AfeYc7OzUePPnQfswbcYrqheABSkfiTy5N8nZS9vlwDuVCvGfdq4l7dlJ1A+swf8F6vkRkNXcF0mzEAcn7Yo6F1dbevXo+CUPVQ+0lloX715x/5z71Pv84TEgWYXRlLqRzmlVYyVSN57gFZwEhPaVVQv4VpKO63MN9ZI9sUVOu7tMM+Ic/JdI0UA6oQDMgbk5dsMax/FAApvblzi1MhW5eBXGkqhzcV6zDlQAjAnZA7eg/jOyFw4dAGcOk7D4zqpn1+uB0EFqsIZM4NdXdDyMaTGu0y9XAbsxqqPUayFviQGKX+023qe4IpINeOkMft2DmFK3SkxwSQd48Adse4plAlJSXco76BWzDXECUAO1ZorEp943JLSJeKvuasOc701fOxOo5Uo+44phUa66VRp3tKthTTeoNik5aGE0lVw64loPrJQcmcMsqBVIx42RyVYZMR9NcTE0VeG7pgXBsnXZt0rnN1UlAhijHr+vim3UdVvGNLIztmAK3278XTv3z/23dbvcWax9hnMk0HeAEHPlAywIniJvSpeKvMpVfv0GC9TkqaCSQVSxrLGYntJmpMDuPNG/d4Zm5T3UaIwvSvP/y4+PHPJ0h+i8wISb0tauy3sett7FdbCi8K3r9hM3pl7ySec/g7AWTWTbZgUwqJl3lpPxl+p8VgU/pN3lpdi59RP7Qyq2vPcLitP5DiPqiQoWA61Gy7IX1UNanQLMJuLmd0s1+SW/rpr9O7397odTSHFZ470DztauEjUuS+4D6zZJXwUCY5lQPNQk+mfJPFQCSDOIJk9d6yZ3WsgTks3JXKM1yxsu+zvcoDDoJ5G1a2uhpz5lrFD4VYexaFBuUdW6N5ukqGl/S/RDtvo33QCaCbBHv7YiX5Zkca3/cJ4s1y32PAVIf7FHCTpswt/wv6wH4ehp7HWXnKNXcF683KsbuZcswRauvN6zjsKPX8vxc1yoUvo5Fz3G9K1aEmiRcwm4PhJq15ClgEplv2VZq8PCVS0Uz8HJNQeQA5K/JJmbR6kgLbjLfaGHPhekw8FQrYSTcE9t4Yds6cMxOgmr8H1L7wPjs6SDnEWW5IhYPsHROqsIf//NrHBCkK2pV4MeTV6x4FWnFx13DkDmjT4qGIRvyFOb7MRjh3bIQVRPgHfAyBk/QLAAA=";
    private static final Log log = LogFactory.getLog(TuttiActionUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected BlockingLayerUI busyBlockLayerUI;
    protected JLabel globalActionLabel;
    protected JPanel globalPanel;
    protected JProgressBar globalProgressBar;
    protected TuttiActionUIHandler handler;
    protected TuttiActionUIModel model;
    protected JPanel rootPanel;
    protected JLabel taskActionLabel;
    protected JPanel taskPanel;
    protected JProgressBar taskProgressBar;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private TuttiActionUI $JDialog0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
        public void open(AbstractTuttiAction action) {
          getModel().setAction(action);
        }
    
        public void close() {
          getModel().clear();
        }
    
        protected void $afterCompleteSetup() {
            handler.afterInitUI();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiActionUI(JFrame frame, TuttiUIContext context) {
        super(frame, true);
                TuttiActionUIHandler handler = new TuttiActionUIHandler(context, this);
                setContextValue(handler);
                handler.beforeInitUI();
            $initialize();
    }

    public TuttiActionUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public TuttiActionUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TuttiActionUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public TuttiActionUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TuttiActionUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public TuttiActionUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TuttiActionUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public TuttiActionUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TuttiActionUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public TuttiActionUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TuttiActionUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public TuttiActionUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TuttiActionUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public TuttiActionUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TuttiActionUI() {
        $initialize();
    }

    public TuttiActionUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TuttiActionUI(Window param0) {
        super(param0);
        $initialize();
    }

    public TuttiActionUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TuttiActionUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public TuttiActionUI(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TuttiActionUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public TuttiActionUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TuttiActionUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public TuttiActionUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TuttiActionUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public TuttiActionUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TuttiActionUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public TuttiActionUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TuttiActionUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public TuttiActionUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public TuttiActionUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public TuttiActionUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public BlockingLayerUI getBusyBlockLayerUI() {
        return busyBlockLayerUI;
    }

    public JLabel getGlobalActionLabel() {
        return globalActionLabel;
    }

    public JPanel getGlobalPanel() {
        return globalPanel;
    }

    public JProgressBar getGlobalProgressBar() {
        return globalProgressBar;
    }

    public TuttiActionUIHandler getHandler() {
        return handler;
    }

    public TuttiActionUIModel getModel() {
        return model;
    }

    public JPanel getRootPanel() {
        return rootPanel;
    }

    public JLabel getTaskActionLabel() {
        return taskActionLabel;
    }

    public JPanel getTaskPanel() {
        return taskPanel;
    }

    public JProgressBar getTaskProgressBar() {
        return taskProgressBar;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToGlobalPanel() {
        if (!allComponentsCreated) {
            return;
        }
        globalPanel.add(globalActionLabel, BorderLayout.CENTER);
        globalPanel.add(globalProgressBar, BorderLayout.SOUTH);
    }

    protected void addChildrenToRootPanel() {
        if (!allComponentsCreated) {
            return;
        }
        rootPanel.add(globalPanel, BorderLayout.NORTH);
        rootPanel.add(taskPanel, BorderLayout.CENTER);
    }

    protected void addChildrenToTaskPanel() {
        if (!allComponentsCreated) {
            return;
        }
        taskPanel.add(taskActionLabel, BorderLayout.CENTER);
        taskPanel.add(taskProgressBar, BorderLayout.SOUTH);
    }

    protected void createBusyBlockLayerUI() {
        $objectMap.put("busyBlockLayerUI", busyBlockLayerUI = new BlockingLayerUI());
        
        busyBlockLayerUI.setUseIcon(false);
    }

    protected void createGlobalActionLabel() {
        $objectMap.put("globalActionLabel", globalActionLabel = new JLabel());
        
        globalActionLabel.setName("globalActionLabel");
    }

    protected void createGlobalPanel() {
        $objectMap.put("globalPanel", globalPanel = new JPanel());
        
        globalPanel.setName("globalPanel");
        globalPanel.setLayout(new BorderLayout());
    }

    protected void createGlobalProgressBar() {
        $objectMap.put("globalProgressBar", globalProgressBar = new JProgressBar());
        
        globalProgressBar.setName("globalProgressBar");
        globalProgressBar.setIndeterminate(true);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(TuttiActionUIHandler.class));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(TuttiActionUIModel.class));
    }

    protected void createRootPanel() {
        $objectMap.put("rootPanel", rootPanel = new JPanel());
        
        rootPanel.setName("rootPanel");
        rootPanel.setLayout(new BorderLayout());
    }

    protected void createTaskActionLabel() {
        $objectMap.put("taskActionLabel", taskActionLabel = new JLabel());
        
        taskActionLabel.setName("taskActionLabel");
    }

    protected void createTaskPanel() {
        $objectMap.put("taskPanel", taskPanel = new JPanel());
        
        taskPanel.setName("taskPanel");
        taskPanel.setLayout(new BorderLayout());
        taskPanel.setVisible(false);
    }

    protected void createTaskProgressBar() {
        $objectMap.put("taskProgressBar", taskProgressBar = new JProgressBar());
        
        taskProgressBar.setName("taskProgressBar");
        taskProgressBar.setIndeterminate(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JDialog0
        add(SwingUtil.boxComponentWithJxLayer(rootPanel), BorderLayout.CENTER);
        addChildrenToRootPanel();
        addChildrenToGlobalPanel();
        addChildrenToTaskPanel();
        
        // apply 9 property setters
        busyBlockLayerUI.setBlockingColor(handler.getConfig().getColorBlockingLayer());
        busyBlockLayerUI.setBlock(true);
        globalPanel.setBorder(new TitledBorder((String) null));
        globalActionLabel.setBorder(new EmptyBorder(5, 5, 5, 5));
        taskPanel.setBorder(new TitledBorder((String) null));
        taskActionLabel.setBorder(new EmptyBorder(5, 5, 5, 5));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JDialog0", $JDialog0);
        createBusyBlockLayerUI();
        createHandler();
        createModel();
        createRootPanel();
        createGlobalPanel();
        createGlobalActionLabel();
        createGlobalProgressBar();
        createTaskPanel();
        createTaskActionLabel();
        createTaskProgressBar();
        // inline creation of $JDialog0
        setName("$JDialog0");
        SwingUtil.setComponentHeight($JDialog0,200);
        setModal(true);
        setUndecorated(true);
        SwingUtil.setComponentWidth($JDialog0,300);
        
        $completeSetup();
    }

}