
package fr.ifremer.tutti.ui.swing.util;

/*
 * #%L
 * Tutti :: UI
 * $Id: AbstractTuttiTabContainerUIHandler.java 715 2013-04-01 20:46:21Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/util/AbstractTuttiTabContainerUIHandler.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiUIContext;

import javax.swing.DefaultSingleSelectionModel;
import javax.swing.JTabbedPane;
import java.awt.Component;

/**
 * UI containing a tab panel.
 *
 * @param <M> type of the ui model
 * @author kmorin <kmorin@codelutin.com>
 * @since 0.3
 */
public abstract class AbstractTuttiTabContainerUIHandler<M, UI extends TuttiUI<M, ?>> extends AbstractTuttiUIHandler<M, UI> {
//
//    private final static Log log = LogFactory.getLog(AbstractTuttiTabContainerUIHandler.class);

    protected AbstractTuttiTabContainerUIHandler(TuttiUIContext context, UI ui) {
        super(context, ui);
    }

    /** @return the tab panel of the UI */
    protected abstract JTabbedPane getTabPanel();

    /**
     * Method called when the user selects a tab.
     *
     * @param currentIndex
     * @param newIndex
     * @return <code>false</code> if you want to prevent the tab change,
     *         <code>true</code> otherwise
     */
    protected boolean onTabChanged(int currentIndex, int newIndex) {
        boolean result = true;
        if (currentIndex != newIndex) {
            TabHandler handler = getTabHandler(currentIndex);
            if (handler != null) {
                result = handler.onHideTab(currentIndex, newIndex);
            }

            handler = getTabHandler(newIndex);
            if (handler != null) {
                handler.onShowTab(currentIndex, newIndex);
            }
        }
        return result;
    }

    /**
     * Returns the tab handler of the tab i.
     *
     * @param index the index of the tab
     * @return the tab handler of the index i if the handler implements
     *         the {@link TabHandler} interface,
     *         <code>null</code> otherwise
     */
    protected TabHandler getTabHandler(int index) {
        TabHandler tabHandler = null;
        JTabbedPane tabPanel = getTabPanel();
        if (index >= 0 && index < tabPanel.getTabCount()) {
            Component tab = tabPanel.getComponentAt(index);
            if (TuttiUI.class.isInstance(tab)) {
                TuttiUI tuttiTab = (TuttiUI) tabPanel.getComponentAt(index);
                AbstractTuttiUIHandler handler = tuttiTab.getHandler();
                if (TabHandler.class.isInstance(handler)) {
                    tabHandler = (TabHandler) handler;
                }
            }
        }
        return tabHandler;
    }

    @Override
    protected void initUI(TuttiUI ui) {
        super.initUI(ui);

        final JTabbedPane tabPanel = getTabPanel();
        tabPanel.setModel(new DefaultSingleSelectionModel() {

            @Override
            public void setSelectedIndex(int index) {
                int currentIndex = tabPanel.getSelectedIndex();
                boolean mustChangeTab = onTabChanged(currentIndex, index);

                if (mustChangeTab) {
                    super.setSelectedIndex(index);
                }
            }

        });
    }

    /**
     * Sets a {@link CustomTab} as tab component.
     *
     * @param index
     * @param model
     */
    protected void setCustomTab(int index, TabContentModel model) {
        getTabPanel().setTabComponentAt(index, new CustomTab(model));
    }
}
