package fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter;

/*
 * #%L
 * Tutti :: UI
 * $Id: RemoveMarineLitterBatchAction.java 765 2013-04-11 11:12:42Z kmorin $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.0/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/marinelitter/RemoveMarineLitterBatchAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.RemoveSpeciesSubBatchAction;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.table.AbstractSelectTableAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;

/**
 * To remove a selected marine litter batch in the table.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class RemoveMarineLitterBatchAction extends AbstractTuttiAction<MarineLitterBatchUIModel, MarineLitterBatchUI, MarineLitterBatchUIHandler> {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(RemoveMarineLitterBatchAction.class);

    protected RemoveSpeciesSubBatchAction removeSpeciesSubBatchAction;

    public RemoveMarineLitterBatchAction(MarineLitterBatchUIHandler handler) {
        super(handler, false);
    }

    int rowIndex;

    @Override
    protected void doAction() throws Exception {

        JXTable table = handler.getTable();

        rowIndex = table.getSelectedRow();

        Preconditions.checkState(rowIndex != -1,
                                 "Cant remove batch if none is selected");

        MarineLitterBatchTableModel tableModel = handler.getTableModel();
        MarineLitterBatchRowModel selectedBatch = tableModel.getEntry(rowIndex);

        boolean persisted = !TuttiEntities.isNew(selectedBatch);

        if (persisted) {

            // remove it from db

            String id = selectedBatch.getId();

            if (log.isInfoEnabled()) {
                log.info("Remove marineLitter with id: " + id);
            }

            TuttiPersistence persistenceService =
                    getContext().getPersistenceService();

            persistenceService.deleteMarineLitterBatch(id);
        }

        // update speciesUsed
        handler.removeFromMarineLitterCategoriesUsed(selectedBatch);
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();

        JXTable table = handler.getTable();

        MarineLitterBatchTableModel tableModel = handler.getTableModel();

        tableModel.removeRow(rowIndex);

        if (!tableModel.getRows().isEmpty()) {

            // select first row
            AbstractSelectTableAction.doSelectCell(table, 0, 0);
        }

        if (table.isEditing()) {

            // but no edit it
            table.getCellEditor().stopCellEditing();
        }
    }
}