package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos;

/*
 * #%L
 * Tutti :: UI
 * $Id: RemoveBenthosBatchAction.java 666 2013-03-23 18:20:58Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.0/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/benthos/RemoveBenthosBatchAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.table.AbstractSelectTableAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;

import java.util.Set;

/**
 * To remove a species batch and all his children.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class RemoveBenthosBatchAction extends AbstractTuttiAction<BenthosBatchUIModel, BenthosBatchUI, BenthosBatchUIHandler> {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(RemoveBenthosBatchAction.class);

    protected RemoveBenthosSubBatchAction removeSpeciesSubBatchAction;

    public RemoveBenthosBatchAction(BenthosBatchUIHandler handler) {
        super(handler, false);

        removeSpeciesSubBatchAction = new RemoveBenthosSubBatchAction(handler);
    }

    @Override
    protected void doAction() throws Exception {

        TuttiPersistence persistenceService =
                getContext().getPersistenceService();

        JXTable table = handler.getTable();

        int rowIndex = table.getSelectedRow();

        Preconditions.checkState(rowIndex != -1,
                                 "Cant remove batch if no batch selected");

        BenthosBatchTableModel tableModel = handler.getTableModel();
        BenthosBatchRowModel selectedBatch = tableModel.getEntry(rowIndex);

        Preconditions.checkState(!TuttiEntities.isNew(selectedBatch),
                                 "Can't remove batch if batch is not persisted");

        if (!selectedBatch.isBatchRoot()) {

            // remove all sub batches of his parent
            BenthosBatchRowModel parentBatch = selectedBatch.getParentBatch();

            // get parent row index
            int parentIndex = tableModel.getRowIndex(parentBatch);

            // select it
            table.setRowSelectionInterval(parentIndex, parentIndex);

            // remove all his children
            runAction(removeSpeciesSubBatchAction);

        } else {

            // remove selected batch and all his children

            // remove parent batch (will destroy all his childs from db)
            persistenceService.deleteBenthosBatch(selectedBatch.getId());

            // update speciesUsed
            handler.removeFromSpeciesUsed(selectedBatch);

            // collect of rows to remove from model
            Set<BenthosBatchRowModel> rowToRemove =
                    Sets.newHashSet(selectedBatch);

            handler.collectChildren(selectedBatch, rowToRemove);

            table.clearSelection();

            // remove all rows from the model
            getModel().getRows().removeAll(rowToRemove);

            // refresh table from parent batch row index to the end
            tableModel.fireTableDataChanged();

            if (!getModel().getRows().isEmpty()) {

                // select first row
                AbstractSelectTableAction.doSelectCell(table, 0, 0);

            }

            if (table.isEditing()) {

                // but no edit it
                table.getCellEditor().stopCellEditing();
            }

        }
    }

}
