package fr.ifremer.tutti.ui.swing.content.home;

/*
 * #%L
 * Tutti :: UI
 * $Id: CloneProtocolAction.java 694 2013-03-27 21:56:27Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.0/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/home/CloneProtocolAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.content.AbstractChangeScreenAction;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import jaxx.runtime.context.JAXXContextEntryDef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Opens the protocol creation screen with the data of an already existing protocol.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class CloneProtocolAction extends AbstractChangeScreenAction {

    /** Logger. */
    private static final Log log = LogFactory.getLog(CloneProtocolAction.class);

    public static final JAXXContextEntryDef<TuttiProtocol> CLONE_PROTOCOL_ENTRY = new JAXXContextEntryDef<TuttiProtocol>("cloneProtocol", TuttiProtocol.class);

    public CloneProtocolAction(MainUIHandler handler) {
        super(handler, true, TuttiScreen.EDIT_PROTOCOL);
    }

    @Override
    protected void doAction() throws Exception {
        Preconditions.checkState(getContext().isProtocolFilled());
        if (log.isInfoEnabled()) {
            log.info("Clone protocol: " + getContext().getProtocolId());
        }

        // get protocol
        TuttiProtocol protocol = getContext().getPersistenceService().getProtocol(getContext().getProtocolId());

        // remove id
        protocol.setId((String) null);

        // store protocol in context
        CLONE_PROTOCOL_ENTRY.setContextValue(getContext().getMainUI(), protocol);

        // removed selected protocol
        getContext().setProtocolId(null);

        super.doAction();
    }
}
