/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential.taxon;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.referential.Status;
import fr.ifremer.adagio.core.dao.referential.taxon.Author;
import fr.ifremer.adagio.core.dao.referential.taxon.AuthorDao;
import fr.ifremer.adagio.core.dao.referential.taxon.AuthorImpl;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceDocument;
import fr.ifremer.adagio.core.dao.technical.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;

public abstract class AuthorDaoBase
extends HibernateDaoSupport
implements AuthorDao {
    @Override
    public Object load(int transform, Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("Author.load - 'id' can not be null");
        }
        Integer entityPk = id;
        Object entity = this.getHibernateTemplate().get(AuthorImpl.class, (Serializable)entityPk);
        return this.transformEntity(transform, (Author)entity);
    }

    @Override
    public Author load(Integer id) {
        return (Author)this.load(0, id);
    }

    @Override
    public Collection<Author> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(AuthorImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public Author create(Author author) {
        return (Author)this.create(0, author);
    }

    @Override
    public Object create(int transform, Author author) {
        if (author == null) {
            throw new IllegalArgumentException("Author.create - 'author' can not be null");
        }
        this.getHibernateTemplate().save((Object)author);
        return this.transformEntity(transform, author);
    }

    @Override
    public Collection<Author> create(Collection<Author> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<Author> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Author.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    AuthorDaoBase.this.create(transform, (Author)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public Author create(String name, String location, String comments, Date creationDate, Timestamp updateDate, Collection<ReferenceDocument> referenceDocuments, Status status) {
        return (Author)this.create(0, name, location, comments, creationDate, updateDate, referenceDocuments, status);
    }

    @Override
    public Object create(int transform, String name, String location, String comments, Date creationDate, Timestamp updateDate, Collection<ReferenceDocument> referenceDocuments, Status status) {
        AuthorImpl entity = new AuthorImpl();
        entity.setName(name);
        entity.setLocation(location);
        entity.setComments(comments);
        entity.setCreationDate(creationDate);
        entity.setUpdateDate(updateDate);
        entity.setReferenceDocuments(referenceDocuments);
        entity.setStatus(status);
        return this.create(transform, entity);
    }

    @Override
    public Author create(Date creationDate, Status status) {
        return (Author)this.create(0, creationDate, status);
    }

    @Override
    public Object create(int transform, Date creationDate, Status status) {
        AuthorImpl entity = new AuthorImpl();
        entity.setCreationDate(creationDate);
        entity.setStatus(status);
        return this.create(transform, entity);
    }

    @Override
    public void update(Author author) {
        if (author == null) {
            throw new IllegalArgumentException("Author.update - 'author' can not be null");
        }
        this.getHibernateTemplate().update((Object)author);
    }

    @Override
    public void update(final Collection<Author> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Author.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    AuthorDaoBase.this.update((Author)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(Author author) {
        if (author == null) {
            throw new IllegalArgumentException("Author.remove - 'author' can not be null");
        }
        this.getHibernateTemplate().delete((Object)author);
    }

    @Override
    public void remove(Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("Author.remove - 'id' can not be null");
        }
        Integer entityPk = id;
        Author entity = this.load(id);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<Author> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Author.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, Author entity) {
        Author target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected Author toEntity(Object[] row) {
        Author target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof Author)) continue;
                target = (Author)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), AuthorImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), AuthorImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<Author> search(Search search) {
        return this.search(0, search);
    }
}

