/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.editor;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import org.nuiton.util.decorator.Decorator;
import org.nuiton.util.decorator.JXPathDecorator;

public class VesselTableCell {
    protected Decorator<Vessel> decorator;
    protected List<Vessel> vessels;
    protected Map<String, Vessel> vesselMap;

    public VesselTableCell(TuttiUIContext context) {
        DecoratorService decoratorService = context.getDecoratorService();
        this.decorator = decoratorService.getDecoratorByType(Vessel.class);
        this.vessels = Lists.newArrayList(context.getDataContext().getFishingVessels());
        this.vessels.addAll(context.getDataContext().getScientificVessels());
        this.vesselMap = TuttiEntities.splitById(this.vessels);
    }

    public TableCellEditor getNewTableCellEditor() {
        return new VesselTableCellEditor();
    }

    public TableCellRenderer getNewTableCellRenderer() {
        return new VesselTableCellRenderer();
    }

    protected class VesselTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        protected VesselTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String vesselId = String.valueOf(value);
            Vessel vessel = VesselTableCell.this.vesselMap.get(vesselId);
            return super.getTableCellRendererComponent(table, VesselTableCell.this.decorator.toString((Object)vessel), isSelected, hasFocus, row, column);
        }
    }

    protected class VesselTableCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 1L;

        protected VesselTableCellEditor() {
            super(new JComboBox());
            final BeanFilterableComboBox component = new BeanFilterableComboBox();
            component.setI18nPrefix("tutti.property.");
            component.setShowReset(Boolean.valueOf(true));
            this.setClickCountToStart(1);
            this.editorComponent = component;
            this.delegate = new DefaultCellEditor.EditorDelegate(){
                private static final long serialVersionUID = 1L;

                @Override
                public void setValue(Object value) {
                    if (value != null && String.class.isInstance(value)) {
                        value = VesselTableCell.this.vesselMap.get(value);
                    }
                    component.setSelectedItem(value);
                }

                @Override
                public Object getCellEditorValue() {
                    Vessel vessel;
                    String result = null;
                    Object selectedItem = component.getSelectedItem();
                    if (Vessel.class.isInstance(selectedItem) && (vessel = (Vessel)component.getSelectedItem()) != null) {
                        result = vessel.getId();
                    }
                    return result;
                }

                @Override
                public boolean shouldSelectCell(EventObject anEvent) {
                    if (anEvent instanceof MouseEvent) {
                        MouseEvent e = (MouseEvent)anEvent;
                        return e.getID() != 506;
                    }
                    return true;
                }

                @Override
                public boolean stopCellEditing() {
                    if (component.isEditable().booleanValue()) {
                        component.getCombobox().actionPerformed(new ActionEvent(VesselTableCellEditor.this, 0, ""));
                    }
                    return super.stopCellEditing();
                }
            };
            component.init((JXPathDecorator)VesselTableCell.this.decorator, VesselTableCell.this.vessels);
        }

        class VesselListCellRenderer
        extends DefaultListCellRenderer {
            private static final long serialVersionUID = 1L;

            VesselListCellRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return super.getListCellRendererComponent((JList<?>)list, VesselTableCell.this.decorator.toString(value), index, isSelected, cellHasFocus);
            }
        }
    }
}

