/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.tutti.TuttiIOUtil;
import fr.ifremer.tutti.TuttiTechnicalException;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.config.TuttiPersistenceConfig;
import fr.ifremer.tutti.persistence.service.synchro.ReferentialSynchronizeResult;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.referential.TuttiReferentialSynchronizeService;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionException;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionUI;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.Version;
import org.nuiton.util.updater.ApplicationInfo;
import org.nuiton.util.updater.ApplicationUpdaterCallback;

public class TuttiApplicationUpdaterCallBack
implements ApplicationUpdaterCallback {
    private static final Log log = LogFactory.getLog(TuttiApplicationUpdaterCallBack.class);
    protected final TuttiUIContext context;
    protected List<UpdateType> types;
    protected ProgressionModel progressionModel;
    protected boolean applicationUpdated;
    protected boolean dbUpdated;
    protected final AbstractTuttiAction action;

    public TuttiApplicationUpdaterCallBack(AbstractTuttiAction action, ProgressionModel progressionModel) {
        this.action = action;
        this.context = action.getContext();
        this.progressionModel = progressionModel;
    }

    public void setTypes(UpdateType ... types) {
        this.types = Lists.newArrayList((Object[])types);
    }

    public boolean isApplicationUpdated() {
        return this.applicationUpdated;
    }

    public boolean isDbUpdated() {
        return this.dbUpdated;
    }

    public Map<String, ApplicationInfo> updateToDo(Map<String, ApplicationInfo> appToUpdate) {
        HashMap result = Maps.newHashMap();
        for (UpdateType type : this.types) {
            ApplicationInfo info = this.getInfo(type, appToUpdate);
            if (info == null) continue;
            result.put(info.name, info);
            if (!UpdateType.DB.equals((Object)type)) continue;
            info.setAuthentication("tuttidb", new char[]{'3', 'R', 'A', 'C', 'e', 'v', '2', 'N', 'w', '8', 'u', 'E', 'D', 'E', 'v', 's', 'y', '0', 'v', 'J'});
        }
        if (this.types.contains((Object)UpdateType.DB)) {
            ApplicationInfo info = this.getInfo(UpdateType.DB, result);
            this.dbUpdated = info != null;
        }
        return result;
    }

    public void startUpdate(ApplicationInfo info) {
        if (UpdateType.DB.name().toLowerCase().equals(info.name)) {
            if (Version.VZERO.toString().equals(info.oldVersion)) {
                this.progressionModel.setMessage("T\u00e9l\u00e9chargement et installation de la base (version " + info.newVersion + ")");
            } else {
                this.progressionModel.setMessage("T\u00e9l\u00e9chargement et mise \u00e0 jour de la base (version " + info.newVersion + ")");
            }
        }
        if (UpdateType.JRE.name().toLowerCase().equals(info.name)) {
            this.progressionModel.setMessage("T\u00e9l\u00e9chargement et installation d'une nouvelle JRE (version " + info.newVersion + ")");
        }
        if (UpdateType.TUTTI.name().toLowerCase().equals(info.name)) {
            this.progressionModel.setMessage("T\u00e9l\u00e9chargement et installation d'une nouvelle version de Tutti (version " + info.newVersion + ")");
        }
        if (UpdateType.I18N.name().toLowerCase().equals(info.name)) {
            this.progressionModel.setMessage("T\u00e9l\u00e9chargement et installation d'une nouveau version I18N (version " + info.newVersion + ")");
        }
        if (UpdateType.HELP.name().toLowerCase().equals(info.name)) {
            this.progressionModel.setMessage("T\u00e9l\u00e9chargement et installation d'une nouveau version Help (version " + info.newVersion + ")");
        }
    }

    public void updateDone(Map<String, ApplicationInfo> appToUpdate, Map<String, Exception> appUpdateError) {
        boolean updateJRE = this.updateDoneJre(appToUpdate, appUpdateError);
        boolean updateTutti = this.updateDoneTutti(appToUpdate, appUpdateError);
        boolean updateI18n = this.updateDoneI18n(appToUpdate, appUpdateError);
        boolean updateHelp = this.updateDoneHelp(appToUpdate, appUpdateError);
        boolean doRestart = updateJRE || updateTutti || updateI18n || updateHelp;
        this.updateDoneDb(appToUpdate, appUpdateError);
        if (doRestart) {
            this.applicationUpdated = true;
        }
    }

    public void restart() {
        System.exit(88);
    }

    public void aborted(String propertiesURL, Exception eee) {
        if (log.isErrorEnabled()) {
            log.error((Object)("Could not update from " + propertiesURL), (Throwable)eee);
        }
        throw TuttiActionException.propagateError(this.action, eee);
    }

    protected boolean updateDoneJre(Map<String, ApplicationInfo> appToUpdate, Map<String, Exception> appUpdateError) {
        boolean doRestart = false;
        Exception error = this.getError(UpdateType.JRE, appUpdateError);
        if (error != null) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Could not update jre", (Throwable)error);
            }
        } else {
            ApplicationInfo info = this.getInfo(UpdateType.JRE, appToUpdate);
            if (info != null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("A jre update was downloaded (oldVersion: %s, newVersion: %s), will restart application to use it", info.oldVersion, info.newVersion));
                }
                doRestart = true;
            }
        }
        return doRestart;
    }

    protected boolean updateDoneTutti(Map<String, ApplicationInfo> appToUpdate, Map<String, Exception> appUpdateError) {
        boolean doRestart = false;
        Exception error = this.getError(UpdateType.TUTTI, appUpdateError);
        if (error != null) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Could not update tutti", (Throwable)error);
            }
        } else {
            ApplicationInfo info = this.getInfo(UpdateType.TUTTI, appToUpdate);
            if (info != null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("A tutti update was downloaded (oldVersion: %s, newVersion: %s), will restart application to use it", info.oldVersion, info.newVersion));
                }
                doRestart = true;
                TuttiPersistenceConfig persistenceConfig = this.context.getConfig().getServiceConfig().getPersistenceConfig();
                File enumerationPath = persistenceConfig.getDbEnumerationPath();
                TuttiIOUtil.forceDeleteOnExit((File)enumerationPath, (String)("Could not delete enumeration file " + enumerationPath));
                File dbConfPath = persistenceConfig.getDbConfigurationPath();
                TuttiIOUtil.forceDeleteOnExit((File)dbConfPath, (String)("Could not delete db conf file " + dbConfPath));
                File i18nDirectory = this.context.getConfig().getI18nDirectory();
                TuttiIOUtil.forceDeleteOnExit((File)i18nDirectory, (String)("Could not delete i18n directory " + i18nDirectory));
            }
        }
        return doRestart;
    }

    protected boolean updateDoneI18n(Map<String, ApplicationInfo> appToUpdate, Map<String, Exception> appUpdateError) {
        boolean doRestart = false;
        Exception error = this.getError(UpdateType.I18N, appUpdateError);
        if (error != null) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Could not update i18n", (Throwable)error);
            }
        } else {
            ApplicationInfo info = this.getInfo(UpdateType.I18N, appToUpdate);
            if (info != null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("A i18n update was downloaded (oldVersion: %s, newVersion: %s), will restart application to use it", info.oldVersion, info.newVersion));
                }
                doRestart = true;
            }
        }
        return doRestart;
    }

    protected boolean updateDoneHelp(Map<String, ApplicationInfo> appToUpdate, Map<String, Exception> appUpdateError) {
        boolean doRestart = false;
        Exception error = this.getError(UpdateType.HELP, appUpdateError);
        if (error != null) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Could not update help", (Throwable)error);
            }
        } else {
            ApplicationInfo info = this.getInfo(UpdateType.HELP, appToUpdate);
            if (info != null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("A help update was downloaded (oldVersion: %s, newVersion: %s), will restart application to use it", info.oldVersion, info.newVersion));
                }
                doRestart = true;
            }
        }
        return doRestart;
    }

    protected void updateDoneDb(Map<String, ApplicationInfo> appToUpdate, Map<String, Exception> appUpdateError) {
        Exception error = this.getError(UpdateType.DB, appUpdateError);
        if (error != null) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Could not update db", (Throwable)error);
            }
            throw new TuttiActionException(this.action, (Throwable)error);
        }
        ApplicationInfo info = this.getInfo(UpdateType.DB, appToUpdate);
        if (info != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("A db update was downloaded (oldVersion: %s, newVersion: %s), will process it.", info.oldVersion, info.newVersion));
            }
            TuttiPersistenceConfig persistenceConfig = this.regenerateDbConf();
            persistenceConfig.generateExternalDbFiles(true);
            if (Version.VZERO.toString().equals(info.oldVersion)) {
                this.prepareFirstDatabase(info);
            } else {
                this.synchronizetDatabase(info);
            }
        }
    }

    protected TuttiPersistenceConfig regenerateDbConf() {
        TuttiPersistenceConfig persistenceConfig = this.context.getConfig().getServiceConfig().getPersistenceConfig();
        this.context.showInformationMessage("Reg\u00e9n\u00e9rer les fichiers de configuration de la base");
        return persistenceConfig;
    }

    protected ApplicationInfo getInfo(UpdateType type, Map<String, ApplicationInfo> appToUpdate) {
        return appToUpdate.get(type.name().toLowerCase());
    }

    protected Exception getError(UpdateType type, Map<String, Exception> appUpdateError) {
        return appUpdateError.get(type.name().toLowerCase());
    }

    protected File getDbDirectory(ApplicationInfo info) {
        File[] sources = info.destDir.listFiles();
        Preconditions.checkState((sources != null && sources.length == 1 ? 1 : 0) != 0, (Object)("Downloaded db should contains one directory at " + info.destDir));
        File result = sources[0];
        return result;
    }

    protected void prepareFirstDatabase(ApplicationInfo info) {
        if (log.isInfoEnabled()) {
            log.info((Object)("First time database was downloaded at version: " + info.newVersion));
        }
        File source = this.getDbDirectory(info);
        File target = this.context.getConfig().getServiceConfig().getPersistenceConfig().getDbDirectory();
        if (log.isInfoEnabled()) {
            log.info((Object)("Copy from " + source + " to " + target));
        }
        try {
            FileUtils.copyDirectory((File)source, (File)target);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not copy directory content from " + source + " to " + target, e);
        }
        try {
            FileUtils.deleteDirectory((File)source.getParentFile());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not delete temporary directory " + target, e);
        }
    }

    protected void synchronizetDatabase(ApplicationInfo info) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("A database update was downloaded (oldVersion: %s, newVersion: %s), will launch a referential synchronize operation ", info.oldVersion, info.newVersion));
        }
        TuttiReferentialSynchronizeService service = this.context.getTuttiReferentialSynchronizeService();
        ReferentialSynchronizeResult result = new ReferentialSynchronizeResult();
        File dbDirectory = this.getDbDirectory(info);
        TuttiActionUI actionUI = this.context.getActionUI();
        actionUI.getModel().setProgressionModel(result.getProgressionModel());
        service.prepare(dbDirectory, result);
        if (!result.isSuccess()) {
            throw new TuttiTechnicalException("Could not prepare synchro", (Throwable)result.getError());
        }
        service.synchronize(dbDirectory, result);
        if (!result.isSuccess()) {
            throw new TuttiTechnicalException("Could not synchro db", (Throwable)result.getError());
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"Reset all caches.");
        }
        PersistenceService persistence = this.context.getPersistenceService();
        persistence.clearAllCaches();
        File target = this.context.getConfig().getServiceConfig().getPersistenceConfig().getDbDirectory();
        File versionFile = new File(target, "version.appup");
        if (log.isInfoEnabled()) {
            log.info((Object)("Replace content of file " + versionFile + " with " + info.newVersion));
        }
        try {
            FileUtils.writeStringToFile((File)versionFile, (String)info.newVersion);
        }
        catch (IOException e) {
            throw new TuttiTechnicalException("Could not write back new db version to file " + versionFile);
        }
    }

    public static enum UpdateType {
        JRE,
        TUTTI,
        I18N,
        HELP,
        DB;

    }
}

