/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential.taxon;

import fr.ifremer.adagio.core.dao.referential.StatusCode;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxon;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxonDao;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxonImpl;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonName;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonNameDaoBase;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonNameExtendDao;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonNameImpl;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonRefTaxVO;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonomicLevel;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonomicLevelCode;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonomicLevelImpl;
import fr.ifremer.adagio.core.dao.technical.hibernate.TemporaryDataHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.stereotype.Repository;

@Repository(value="taxonNameDao")
public class TaxonNameDaoImpl
extends TaxonNameDaoBase
implements TaxonNameExtendDao {
    private static final String QUERY_ALL_TAXON_REFTAX = "allTaxonNames";
    private static final String QUERY_ALL_TAXON_REFTAX_IS_REFERENT = "allTaxonNamesIsReferent";
    private static final String QUERY_TAXON_NAME_REFERENT = "taxonNameReferent";
    private static final Pattern COMMENT_PATTERN = Pattern.compile("([A-Z0-9]+)(?: - .*)?");
    @Resource(name="referenceTaxonDao")
    protected ReferenceTaxonDao referenceTaxonDao;

    @Autowired
    public TaxonNameDaoImpl(SessionFactory sessionFactory) {
        this.setSessionFactory(sessionFactory);
    }

    @Override
    public TaxonRefTaxVO[] getAllTaxonNames(boolean withSynonyms) {
        this.logger.debug((Object)"call getAllTaxonNames()");
        try {
            Session session = this.getSession(false);
            Query query = null;
            query = withSynonyms ? session.getNamedQuery(QUERY_ALL_TAXON_REFTAX) : session.getNamedQuery(QUERY_ALL_TAXON_REFTAX_IS_REFERENT);
            ArrayList<TaxonRefTaxVO> results = new ArrayList<TaxonRefTaxVO>();
            Iterator iterator = query.iterate();
            while (iterator.hasNext()) {
                Object[] cols = (Object[])iterator.next();
                TaxonRefTaxVO taxonNameRefTaxVO = this.loadTaxon(cols);
                results.add(taxonNameRefTaxVO);
            }
            if (results.size() == 0) {
                return null;
            }
            return results.toArray(new TaxonRefTaxVO[results.size()]);
        }
        catch (RuntimeException re) {
            this.logger.error((Object)"getAllTaxonNames failed", (Throwable)re);
            throw re;
        }
    }

    @Override
    public TaxonRefTaxVO getTaxonNameReferent(Integer referenceTaxonId) {
        this.logger.debug((Object)"call getTaxonRefTax()");
        try {
            Session session = this.getSession(false);
            Query query = session.getNamedQuery(QUERY_TAXON_NAME_REFERENT);
            query.setInteger("referenceTaxonId", referenceTaxonId.intValue());
            Object[] cols = (Object[])query.uniqueResult();
            if (cols == null) {
                throw new DataRetrievalFailureException("TaxonName with referenceTaxonId=" + referenceTaxonId + " could not found.");
            }
            TaxonRefTaxVO taxonNameRefTaxVO = this.loadTaxon(cols);
            return taxonNameRefTaxVO;
        }
        catch (RuntimeException re) {
            this.logger.error((Object)"getTaxonRefTax failed", (Throwable)re);
            throw re;
        }
    }

    @Override
    public TaxonRefTaxVO createAsTemporary(TaxonRefTaxVO taxonNameVO, String comments) {
        if (taxonNameVO == null) {
            throw new IllegalArgumentException("Argument 'taxonName' could not be null.");
        }
        if (taxonNameVO.getName() == null || taxonNameVO.getName().isEmpty()) {
            throw new IllegalArgumentException("Argument 'taxonName.name' could not be null or empty.");
        }
        this.logger.debug((Object)"call create(taxonName)");
        try {
            Session session = this.getSession(false);
            Integer referenceTaxonId = (Integer)TemporaryDataHelper.getNewNegativeIdForTemporaryData(session, ReferenceTaxonImpl.class);
            Integer taxonNameId = (Integer)TemporaryDataHelper.getNewNegativeIdForTemporaryData(session, TaxonNameImpl.class);
            ReferenceTaxon referenceTaxon = ReferenceTaxon.Factory.newInstance();
            referenceTaxon.setId(referenceTaxonId);
            referenceTaxon.setName("#TEMP\u00bf" + taxonNameVO.getName());
            referenceTaxon = this.referenceTaxonDao.create(referenceTaxon);
            TaxonName taxonName = TaxonName.Factory.newInstance();
            taxonName.setId(taxonNameId);
            taxonName.setIsTemporary(true);
            taxonName.setIsReferent(true);
            taxonName.setIsObsolete(false);
            taxonName.setReferenceTaxon(referenceTaxon);
            taxonName.setName("#TEMP\u00bf" + taxonNameVO.getName());
            taxonName.setIsNaming(false);
            taxonName.setIsVirtual(false);
            taxonName.setStartDate(new Date());
            taxonName.setCreationDate(new Date());
            taxonName.setUpperRank(1);
            TaxonomicLevel speciesTaxonomicLevel = (TaxonomicLevel)session.load(TaxonomicLevelImpl.class, (Serializable)((Object)TaxonomicLevelCode.SPECIES.getValue()));
            taxonName.setTaxonomicLevel(speciesTaxonomicLevel);
            StringBuffer commentsBuffer = new StringBuffer();
            if (taxonNameVO.getRefTaxCode() != null) {
                commentsBuffer.append(taxonNameVO.getRefTaxCode());
            }
            if (comments != null && !comments.isEmpty()) {
                if (commentsBuffer.length() > 0) {
                    commentsBuffer.append(" - ");
                }
                commentsBuffer.append(comments);
            }
            taxonName.setComments(commentsBuffer.toString());
            this.create(taxonName);
            TaxonRefTaxVO result = new TaxonRefTaxVO();
            result.setName(taxonNameVO.getName());
            result.setRefTaxCode(taxonNameVO.getRefTaxCode());
            result.setReferenceTaxonId(referenceTaxonId);
            result.setTaxonNameId(taxonNameId);
            result.setIsReference(true);
            result.setStatus(StatusCode.TEMPORARY);
            return result;
        }
        catch (RuntimeException re) {
            this.logger.error((Object)"create(taxonName) failed", (Throwable)re);
            throw re;
        }
    }

    protected TaxonRefTaxVO loadTaxon(Object[] cols) {
        Boolean tempStatus;
        Matcher matcher;
        TaxonRefTaxVO result = new TaxonRefTaxVO();
        int colIndex = 0;
        result.setReferenceTaxonId((Integer)cols[colIndex++]);
        result.setTaxonNameId((Integer)cols[colIndex++]);
        result.setIsReference((Boolean)cols[colIndex++]);
        String name = (String)cols[colIndex++];
        if (name != null && name.startsWith("#TEMP\u00bf")) {
            name = name.substring("#TEMP\u00bf".length());
        }
        result.setName(name);
        String comments = (String)cols[colIndex++];
        if (comments != null && comments.length() > 0 && (matcher = COMMENT_PATTERN.matcher(comments)).matches()) {
            String reftaxCode = matcher.group(1);
            result.setRefTaxCode(reftaxCode);
        }
        StatusCode status = (tempStatus = (Boolean)cols[colIndex++]) != false ? StatusCode.TEMPORARY : StatusCode.ENABLE;
        result.setStatus(status);
        return result;
    }
}

