/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.administration.user;

import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.dao.administration.user.Department;
import fr.ifremer.adagio.core.dao.administration.user.DepartmentImpl;
import fr.ifremer.adagio.core.dao.administration.user.Person;
import fr.ifremer.adagio.core.dao.administration.user.PersonDaoBase;
import fr.ifremer.adagio.core.dao.administration.user.PersonExtendDao;
import fr.ifremer.adagio.core.dao.administration.user.PersonImpl;
import fr.ifremer.adagio.core.dao.administration.user.UserProfil;
import fr.ifremer.adagio.core.dao.administration.user.UserProfilId;
import fr.ifremer.adagio.core.dao.administration.user.UserProfilImpl;
import fr.ifremer.adagio.core.dao.referential.Status;
import fr.ifremer.adagio.core.dao.referential.StatusCode;
import fr.ifremer.adagio.core.dao.referential.StatusImpl;
import fr.ifremer.adagio.core.dao.technical.hibernate.TemporaryDataHelper;
import java.io.Serializable;
import java.util.Date;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Repository(value="personDao")
@Lazy
public class PersonDaoImpl
extends PersonDaoBase
implements PersonExtendDao {
    @Autowired
    public PersonDaoImpl(SessionFactory sessionFactory) {
        this.setSessionFactory(sessionFactory);
    }

    @Override
    public Person createAsTemporary(String lastname, String firstname, Integer departmentId) {
        Session session = this.getSession(false);
        Integer personId = (Integer)TemporaryDataHelper.getNewNegativeIdForTemporaryData(session, PersonImpl.class);
        Person target = Person.Factory.newInstance();
        target.setId(personId);
        target.setLastname(lastname);
        target.setFirstname(firstname);
        target.setDepartment((Department)session.load(DepartmentImpl.class, (Serializable)departmentId));
        target.setCreationDate(new Date());
        target.setStatus((Status)session.load(StatusImpl.class, (Serializable)((Object)StatusCode.TEMPORARY.getValue())));
        UserProfil userProfil = (UserProfil)session.load(UserProfilImpl.class, (Serializable)UserProfilId.USER.getValue());
        target.setProfils(Sets.newHashSet((Object[])new UserProfil[]{userProfil}));
        target = this.create(target);
        return target;
    }
}

